/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import com.lowagie.text.Image;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.emitter.BorderInfo;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.TableBorder;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public abstract class PageDeviceRender
implements IAreaVisitor {
    public static final String IMAGE_FOLDER = "image";
    public static final int H_TEXT_SPACE = 30;
    public static final int V_TEXT_SPACE = 100;
    public static final int ignoredOverflow = 3000;
    protected float scale;
    protected IReportRunnable reportRunnable;
    protected ReportDesignHandle reportDesign;
    protected IReportContext context;
    protected IEmitterServices services;
    protected int currentX;
    protected int currentY;
    protected Stack rowStyleStack = new Stack();
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected Logger logger = Logger.getLogger(PageDeviceRender.class.getName());
    protected IPageDevice pageDevice;
    protected IPage pageGraphic;
    private static final int BODY_HEIGHT = 1;
    private static final int BODY_WIDTH = 2;
    private int extendDirection = 0;
    public static final int EXTEND_NONE = 0;
    public static final int EXTEND_ON_HORIZONTAL = 1;
    public static final int EXTEND_ON_VERTICAL = 2;
    public static final int EXTEND_ON_HORIZONTAL_AND_VERTICAL = 3;

    public abstract String getOutputFormat();

    public abstract IPageDevice createPageDevice(String var1, String var2, String var3, String var4, IReportContext var5, IReportContent var6) throws Exception;

    public void start(IReportContent rc) {
        ReportDesignHandle designHandle = rc.getDesign().getReportDesign();
        String title = designHandle.getStringProperty("title");
        String author = designHandle.getAuthor();
        String description = designHandle.getStringProperty("description");
        String subject = designHandle.getSubject();
        try {
            this.pageDevice = this.createPageDevice(title, author, subject, description, this.context, rc);
        }
        catch (Exception e) {
            this.log(e, Level.SEVERE);
        }
    }

    protected void log(Throwable t, Level level) {
        this.logger.log(level, t.getMessage(), t);
    }

    public void end(IReportContent rc) {
        try {
            this.pageDevice.close();
        }
        catch (Exception e) {
            this.log(e, Level.WARNING);
        }
    }

    public void setTotalPage(ITextArea totalPage) {
    }

    public void visitText(ITextArea textArea) {
        this.drawText(textArea);
    }

    public void visitImage(IImageArea imageArea) {
        this.drawImage(imageArea);
    }

    public void visitAutoText(ITemplateArea templateArea) {
    }

    public void visitContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.visitPage((PageArea)container);
        } else {
            this.startContainer(container);
            this.visitChildren(container);
            this.endContainer(container);
        }
    }

    protected void visitChildren(IContainerArea container) {
        Iterator iter = container.getChildren();
        while (iter.hasNext()) {
            IArea child = (IArea)iter.next();
            child.accept(this);
        }
    }

    private int getActualPageBodyWidth(PageArea page) {
        return this.getActualPageBodySize(page, 2);
    }

    private int getActualPageBodyHeight(PageArea page) {
        return this.getActualPageBodySize(page, 1);
    }

    private int getActualPageBodySize(PageArea page, int direction) {
        int pref = 0;
        IContainerArea body = page.getBody();
        if (body == null) {
            return 0;
        }
        Iterator iter = page.getBody().getChildren();
        while (iter.hasNext()) {
            AbstractArea area = (AbstractArea)iter.next();
            pref = direction == 1 ? Math.max(pref, area.getY() + area.getHeight()) : Math.max(pref, area.getX() + area.getWidth());
        }
        return pref;
    }

    protected void startContainer(IContainerArea container) {
        if (container.needClip()) {
            this.startClip(container);
        }
        if (container instanceof RowArea) {
            this.rowStyleStack.push(container.getStyle());
        } else if (container instanceof CellArea) {
            this.drawCell(container);
        } else {
            this.drawContainer(container);
        }
        this.currentX += this.getX(container);
        this.currentY += this.getY(container);
    }

    protected void drawCell(IContainerArea container) {
        Color rowbc = null;
        String rowImageUrl = null;
        IStyle rowStyle = null;
        if (this.rowStyleStack.size() > 0) {
            rowStyle = (IStyle)this.rowStyleStack.peek();
            rowbc = PropertyUtil.getColor(rowStyle.getProperty(20));
            rowImageUrl = this.getBackgroundImageUrl(rowStyle);
        }
        IStyle style = container.getStyle();
        Color bc = PropertyUtil.getColor(style.getProperty(20));
        String imageUrl = this.getBackgroundImageUrl(style);
        if (rowbc != null || rowImageUrl != null || bc != null || imageUrl != null) {
            int startX = this.currentX + this.getX(container);
            int startY = this.currentY + this.getY(container);
            int width = this.getWidth(container);
            int height = this.getHeight(container);
            if (rowbc != null) {
                this.pageGraphic.drawBackgroundColor(rowbc, startX, startY, width, height);
            }
            if (rowImageUrl != null) {
                this.drawBackgroundImage(rowStyle, rowImageUrl, startX, startY, width, height);
            }
            if (bc != null) {
                this.pageGraphic.drawBackgroundColor(bc, startX, startY, width, height);
            }
            if (imageUrl != null) {
                this.drawBackgroundImage(style, imageUrl, startX, startY, width, height);
            }
        }
    }

    protected void visitPage(PageArea page) {
        this.scale = page.getScale();
        if (page.isExtendToMultiplePages()) {
            int pageBodyHeight = this.getActualPageBodyHeight(page);
            int pageBodyWidth = this.getActualPageBodyWidth(page);
            IContainerArea pageBody = page.getBody();
            int definedBodyHeight = 0;
            int definedBodyWidth = 0;
            if (pageBody != null) {
                definedBodyHeight = pageBody.getHeight();
                definedBodyWidth = pageBody.getWidth();
            }
            if (pageBodyHeight > definedBodyHeight) {
                this.addExtendDirection(2);
            }
            if (pageBodyWidth > definedBodyWidth) {
                this.addExtendDirection(1);
            }
            this.offsetX = 0;
            this.offsetY = 0;
            if (this.extendDirection == 0) {
                this.addPage(page);
            } else if (this.extendDirection == 1) {
                do {
                    this.addPage(page);
                    this.offsetX += definedBodyWidth;
                } while (this.offsetX < pageBodyWidth - 3000);
            } else if (this.extendDirection == 2) {
                do {
                    this.addPage(page);
                    this.offsetY += definedBodyHeight;
                } while (this.offsetY < pageBodyHeight - 3000);
            } else if (this.extendDirection == 3) {
                while (true) {
                    this.addPage(page);
                    this.offsetX += definedBodyWidth;
                    if (this.offsetX < pageBodyWidth - 3000) continue;
                    this.offsetX = 0;
                    this.offsetY += definedBodyHeight;
                    if (this.offsetY >= pageBodyHeight - 3000) break;
                }
            }
            this.setExtendDirection(0);
        } else {
            this.addPage(page);
        }
    }

    protected void addPage(PageArea page) {
        this.newPage(page);
        this.currentX = 0;
        this.currentY = 0;
        IContainerArea pageRoot = page.getRoot();
        if (pageRoot != null) {
            IContainerArea pageBody;
            IContainerArea pageFooter;
            this.startContainer(page.getRoot());
            IContainerArea pageHeader = page.getHeader();
            if (pageHeader != null) {
                this.visitContainer(pageHeader);
            }
            if ((pageFooter = page.getFooter()) != null) {
                this.visitContainer(pageFooter);
            }
            if ((pageBody = page.getBody()) != null) {
                this.startContainer(pageBody);
                this.enterBody();
                this.visitChildren(pageBody);
                this.exitBody();
                this.endContainer(pageBody);
            }
            this.endContainer(page.getRoot());
        }
        this.endContainer(page);
    }

    private void enterBody() {
        this.currentX -= this.offsetX;
        this.currentY -= this.offsetY;
    }

    private void exitBody() {
        this.currentX += this.offsetX;
        this.currentY += this.offsetY;
    }

    protected void endContainer(IContainerArea container) {
        this.currentX -= this.getX(container);
        this.currentY -= this.getY(container);
        if (container instanceof PageArea) {
            this.pageGraphic.dispose();
        } else {
            if (container instanceof RowArea) {
                this.rowStyleStack.pop();
            }
            if (container instanceof TableArea) {
                this.drawTableBorder((TableArea)container);
            } else if (!(container instanceof CellArea)) {
                BorderInfo[] borders = this.cacheBorderInfo(container);
                this.drawBorder(borders);
            }
            if (container.needClip()) {
                this.endClip();
            }
        }
    }

    protected void newPage(IContainerArea page) {
        int pageHeight = this.getHeight(page);
        int pageWidth = this.getWidth(page);
        Color backgroundColor = PropertyUtil.getColor(page.getStyle().getProperty(20));
        this.pageGraphic = this.pageDevice.newPage(pageWidth, pageHeight, backgroundColor);
        IStyle style = page.getStyle();
        String imageUrl = this.getBackgroundImageUrl(style);
        if (imageUrl != null) {
            this.drawBackgroundImage(style, imageUrl, 0, 0, pageWidth, pageHeight);
        }
    }

    protected int getExtendDirection() {
        return this.extendDirection;
    }

    protected void setExtendDirection(int direction) {
        this.extendDirection = direction;
    }

    protected void addExtendDirection(int direction) {
        this.extendDirection |= direction;
    }

    private void startClip(IArea area) {
        int startX = this.currentX + this.getX(area);
        int startY = this.currentY + this.getY(area);
        int width = this.getWidth(area);
        int height = this.getHeight(area);
        this.pageGraphic.startClip(startX, startY, width, height);
    }

    private void endClip() {
        this.pageGraphic.endClip();
    }

    private void drawBackgroundImage(IStyle containerStyle, String imageUrl, int startX, int startY, int width, int height) {
        boolean yMode;
        float positionY;
        boolean xMode;
        float positionX;
        FloatValue positionValX = (FloatValue)containerStyle.getProperty(48);
        FloatValue positionValY = (FloatValue)containerStyle.getProperty(54);
        if (positionValX == null || positionValY == null) {
            return;
        }
        if (positionValX.getPrimitiveType() == 2) {
            positionX = PropertyUtil.getPercentageValue(positionValX);
            xMode = true;
        } else {
            positionX = this.getScaledValue(positionValX);
            xMode = false;
        }
        if (positionValY.getPrimitiveType() == 2) {
            positionY = PropertyUtil.getPercentageValue(positionValY);
            yMode = true;
        } else {
            positionY = this.getScaledValue(positionValY);
            yMode = false;
        }
        this.drawBackgroundImage(imageUrl, startX, startY, width, height, positionX, positionY, containerStyle.getBackgroundRepeat(), xMode, yMode);
    }

    protected String getBackgroundImageUrl(IStyle style) {
        String url;
        String imageUri = PropertyUtil.getBackgroundImage(style.getProperty(37));
        if (imageUri != null && (url = this.getImageUrl(imageUri)) != null && url.length() > 0) {
            return url;
        }
        return null;
    }

    protected void drawContainer(IContainerArea container) {
        IStyle style = container.getStyle();
        if (style == null) {
            return;
        }
        if (container.getContent() != null) {
            Color bc = PropertyUtil.getColor(style.getProperty(20));
            String imageUrl = this.getBackgroundImageUrl(style);
            if (bc != null || imageUrl != null) {
                int startX = this.currentX + this.getX(container);
                int startY = this.currentY + this.getY(container);
                int width = this.getWidth(container);
                int height = this.getHeight(container);
                if (bc != null) {
                    this.pageGraphic.drawBackgroundColor(bc, startX, startY, width, height);
                }
                if (imageUrl != null) {
                    this.drawBackgroundImage(style, imageUrl, startX, startY, width, height);
                }
            }
        }
    }

    private BorderInfo[] cacheCellBorder(CellArea container) {
        IStyle style = container.getStyle();
        if (style == null) {
            return null;
        }
        if (container.getContent() == null) {
            return null;
        }
        int borderTopWidth = this.getScaledValue(style.getProperty(57));
        int borderLeftWidth = this.getScaledValue(style.getProperty(51));
        int borderBottomWidth = this.getScaledValue(style.getProperty(22));
        int borderRightWidth = this.getScaledValue(style.getProperty(21));
        if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
            Color borderTopColor = PropertyUtil.getColor(style.getProperty(13));
            Color borderRightColor = PropertyUtil.getColor(style.getProperty(7));
            Color borderBottomColor = PropertyUtil.getColor(style.getProperty(8));
            Color borderLeftColor = PropertyUtil.getColor(style.getProperty(41));
            BorderInfo[] borders = new BorderInfo[]{new BorderInfo(0, 0, 0, 0, borderTopWidth, borderTopColor, style.getProperty(9), 0), new BorderInfo(0, 0, 0, 0, borderRightWidth, borderRightColor, style.getProperty(10), 1), new BorderInfo(0, 0, 0, 0, borderBottomWidth, borderBottomColor, style.getProperty(11), 2), new BorderInfo(0, 0, 0, 0, borderLeftWidth, borderLeftColor, style.getProperty(43), 3)};
            return borders;
        }
        return null;
    }

    private BorderInfo[] cacheBorderInfo(IContainerArea container) {
        IStyle style = container.getStyle();
        if (style == null) {
            return null;
        }
        if (container.getContent() == null) {
            return null;
        }
        int borderTopWidth = this.getScaledValue(style.getProperty(57));
        int borderLeftWidth = this.getScaledValue(style.getProperty(51));
        int borderBottomWidth = this.getScaledValue(style.getProperty(22));
        int borderRightWidth = this.getScaledValue(style.getProperty(21));
        if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
            Color borderTopColor = PropertyUtil.getColor(style.getProperty(13));
            Color borderRightColor = PropertyUtil.getColor(style.getProperty(7));
            Color borderBottomColor = PropertyUtil.getColor(style.getProperty(8));
            Color borderLeftColor = PropertyUtil.getColor(style.getProperty(41));
            int startX = this.currentX + this.getX(container);
            int startY = this.currentY + this.getY(container);
            BorderInfo[] borders = new BorderInfo[]{new BorderInfo(startX, startY + borderTopWidth / 2, startX + this.getWidth(container), startY + borderTopWidth / 2, borderTopWidth, borderTopColor, style.getProperty(9), 0), new BorderInfo(startX + this.getWidth(container) - borderRightWidth / 2, startY, startX + this.getWidth(container) - borderRightWidth / 2, startY + this.getHeight(container), borderRightWidth, borderRightColor, style.getProperty(10), 1), new BorderInfo(startX, startY + this.getHeight(container) - borderBottomWidth / 2, startX + this.getWidth(container), startY + this.getHeight(container) - borderBottomWidth / 2, borderBottomWidth, borderBottomColor, style.getProperty(11), 2), new BorderInfo(startX + borderLeftWidth / 2, startY, startX + borderLeftWidth / 2, startY + this.getHeight(container), borderLeftWidth, borderLeftColor, style.getProperty(43), 3)};
            return borders;
        }
        return null;
    }

    protected void drawText(ITextArea text) {
        IStyle contentStyle;
        CSSValue contentColor;
        IStyle style = text.getStyle();
        assert (style != null);
        int textX = this.currentX + this.getX(text);
        int textY = this.currentY + this.getY(text);
        float fontSize = text.getFontInfo().getFontSize();
        int x = textX + this.getScaledValue((int)(fontSize * 30.0f));
        int y = textY + this.getScaledValue((int)(fontSize * 100.0f));
        FontInfo fontInfo = new FontInfo(text.getFontInfo());
        fontInfo.setFontSize(fontInfo.getFontSize() * this.scale);
        int characterSpacing = this.getScaledValue(PropertyUtil.getDimensionValue(style.getProperty(49)));
        int wordSpacing = this.getScaledValue(PropertyUtil.getDimensionValue(style.getProperty(55)));
        Color color = PropertyUtil.getColor(style.getProperty(12));
        CSSValue align = style.getProperty(23);
        boolean linethrough = IStyle.LINE_THROUGH_VALUE.equals(style.getProperty(42));
        boolean overline = IStyle.OVERLINE_VALUE.equals(style.getProperty(15));
        boolean underline = IStyle.UNDERLINE_VALUE.equals(style.getProperty(39));
        boolean rtl = text instanceof TextArea ? (((TextArea)text).getRunLevel() & 1) != 0 : "rtl".equals(style.getProperty(0));
        IContent content = text.getContent();
        if (content != null && content.getHyperlinkAction() != null && (contentColor = (contentStyle = content.getStyle()).getProperty(12)) == null) {
            underline = true;
            color = Color.blue;
        }
        TextStyle textStyle = new TextStyle(fontInfo, characterSpacing, wordSpacing, color, linethrough, overline, underline, rtl, align);
        this.drawTextAt(text, x, y, this.getWidth(text), this.getHeight(text), textStyle);
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getText(), x, y, width, height, textStyle);
    }

    /*
     * Exception decompiling
     */
    protected void drawImage(IImageArea image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void drawBorder(TableBorder tb) {
        TableBorder.BorderSegment seg;
        TableBorder.BorderSegment seg2;
        if (tb == null) {
            return;
        }
        tb.findBreakPoints();
        TableBorder.Border border = null;
        for (Integer pos : tb.columnBorders.keySet()) {
            if (pos == tb.tableLRX) continue;
            border = (TableBorder.Border)tb.columnBorders.get(pos);
            int j = 0;
            while (j < border.segments.size()) {
                seg2 = (TableBorder.BorderSegment)border.segments.get(j);
                TableBorder.Border rs = (TableBorder.Border)tb.rowBorders.get(seg2.start);
                TableBorder.Border re = (TableBorder.Border)tb.rowBorders.get(seg2.end);
                if (rs != null && re != null) {
                    int sy = this.getScaledValue(rs.position + rs.width / 2);
                    int ey = this.getScaledValue(re.position + re.width / 2);
                    int x = this.getScaledValue(border.position + seg2.width / 2);
                    if (border.breakPoints.contains(new Integer(seg2.start))) {
                        sy = this.getScaledValue(rs.position);
                    }
                    if (border.breakPoints.contains(new Integer(seg2.end))) {
                        ey = seg2.end == tb.tableLRY ? this.getScaledValue(re.position) : this.getScaledValue(re.position + re.width);
                    }
                    this.drawBorder(new BorderInfo(this.currentX + x, this.currentY + sy, this.currentX + x, this.currentY + ey, this.getScaledValue(seg2.width), seg2.color, seg2.style, 3));
                }
                ++j;
            }
        }
        border = (TableBorder.Border)tb.columnBorders.get(tb.tableLRX);
        int j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorder.BorderSegment)border.segments.get(j);
            TableBorder.Border rs = (TableBorder.Border)tb.rowBorders.get(seg.start);
            TableBorder.Border re = (TableBorder.Border)tb.rowBorders.get(seg.end);
            if (rs != null && re != null) {
                int sy = this.getScaledValue(rs.position + rs.width / 2);
                int ey = this.getScaledValue(re.position + re.width / 2);
                int x = this.getScaledValue(border.position - seg.width / 2);
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sy = this.getScaledValue(rs.position);
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ey = seg.end == tb.tableLRY ? this.getScaledValue(re.position) : this.getScaledValue(re.position + re.width);
                }
                this.drawBorder(new BorderInfo(this.currentX + x, this.currentY + sy, this.currentX + x, this.currentY + ey, this.getScaledValue(seg.width), seg.color, seg.style, 1));
            }
            ++j;
        }
        for (Integer pos : tb.rowBorders.keySet()) {
            if (pos == tb.tableLRY) continue;
            border = (TableBorder.Border)tb.rowBorders.get(pos);
            int j2 = 0;
            while (j2 < border.segments.size()) {
                seg2 = (TableBorder.BorderSegment)border.segments.get(j2);
                TableBorder.Border cs = (TableBorder.Border)tb.columnBorders.get(seg2.start);
                TableBorder.Border ce = (TableBorder.Border)tb.columnBorders.get(seg2.end);
                if (cs != null && ce != null) {
                    int sx = this.getScaledValue(cs.position + cs.width / 2);
                    int ex = this.getScaledValue(ce.position + ce.width / 2);
                    int y = this.getScaledValue(border.position + seg2.width / 2);
                    if (border.breakPoints.contains(new Integer(seg2.start))) {
                        sx = seg2.start == tb.tableX && border.position != tb.tableY ? this.getScaledValue(cs.position + cs.width) : this.getScaledValue(cs.position);
                    }
                    if (border.breakPoints.contains(new Integer(seg2.end))) {
                        ex = seg2.end == tb.tableLRX ? (border.position == tb.tableY ? this.getScaledValue(ce.position) : this.getScaledValue(ce.position - ce.width)) : this.getScaledValue(ce.position + ce.width);
                    }
                    this.drawBorder(new BorderInfo(this.currentX + sx, this.currentY + y, this.currentX + ex, this.currentY + y, this.getScaledValue(seg2.width), seg2.color, seg2.style, 0));
                }
                ++j2;
            }
        }
        border = (TableBorder.Border)tb.rowBorders.get(tb.tableLRY);
        j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorder.BorderSegment)border.segments.get(j);
            TableBorder.Border cs = (TableBorder.Border)tb.columnBorders.get(seg.start);
            TableBorder.Border ce = (TableBorder.Border)tb.columnBorders.get(seg.end);
            if (cs != null && ce != null) {
                int sx = this.getScaledValue(cs.position + cs.width / 2);
                int ex = this.getScaledValue(ce.position + ce.width / 2);
                int y = this.getScaledValue(border.position - seg.width / 2);
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sx = this.getScaledValue(cs.position);
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ex = seg.end == tb.tableLRX ? this.getScaledValue(ce.position) : this.getScaledValue(ce.position + ce.width);
                }
                this.drawBorder(new BorderInfo(this.currentX + sx, this.currentY + y, this.currentX + ex, this.currentY + y, this.getScaledValue(seg.width), seg.color, seg.style, 2));
            }
            ++j;
        }
    }

    private void drawBorder(BorderInfo[] borders) {
        if (borders == null) {
            return;
        }
        ArrayList<BorderInfo> dbl = null;
        ArrayList<BorderInfo> solid = null;
        ArrayList<BorderInfo> dashed = null;
        ArrayList<BorderInfo> dotted = null;
        int i = 0;
        while (i < borders.length) {
            if ("double".equals(borders[i].borderStyle)) {
                if (dbl == null) {
                    dbl = new ArrayList<BorderInfo>();
                }
                dbl.add(borders[i]);
            } else if ("dashed".equals(borders[i].borderStyle)) {
                if (dashed == null) {
                    dashed = new ArrayList<BorderInfo>();
                }
                dashed.add(borders[i]);
            } else if ("dotted".equals(borders[i].borderStyle)) {
                if (dotted == null) {
                    dotted = new ArrayList<BorderInfo>();
                }
                dotted.add(borders[i]);
            } else {
                if (solid == null) {
                    solid = new ArrayList<BorderInfo>();
                }
                solid.add(borders[i]);
            }
            ++i;
        }
        if (dotted != null) {
            for (BorderInfo bi : dotted) {
                this.drawBorder(bi);
            }
        }
        if (dashed != null) {
            for (BorderInfo bi : dashed) {
                this.drawBorder(bi);
            }
        }
        if (solid != null) {
            for (BorderInfo bi : solid) {
                this.drawBorder(bi);
            }
        }
        if (dbl != null) {
            for (BorderInfo bi : dbl) {
                this.drawDoubleBorder(bi);
            }
        }
    }

    private void drawBorder(BorderInfo bi) {
        if ("double".equals(bi.borderStyle)) {
            this.drawDoubleBorder(bi);
        } else {
            this.pageGraphic.drawLine(bi.startX, bi.startY, bi.endX, bi.endY, bi.borderWidth, bi.borderColor, bi.borderStyle);
        }
    }

    private void drawDoubleBorder(BorderInfo bi) {
        int borderWidth = bi.borderWidth;
        int outerBorderWidth = borderWidth / 4;
        int innerBorderWidth = borderWidth / 4;
        int startX = bi.startX;
        int startY = bi.startY;
        int endX = bi.endX;
        int endY = bi.endY;
        Color borderColor = bi.borderColor;
        switch (bi.borderType) {
            case 0: {
                this.pageGraphic.drawLine(startX, startY - borderWidth / 2 + outerBorderWidth / 2, endX, endY - borderWidth / 2 + outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                this.pageGraphic.drawLine(startX, startY + borderWidth / 2 - innerBorderWidth / 2, endX, endY + borderWidth / 2 - innerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                break;
            }
            case 1: {
                this.pageGraphic.drawLine(startX + borderWidth / 2 - outerBorderWidth / 2, startY, endX + borderWidth / 2 - outerBorderWidth / 2, endY, outerBorderWidth, borderColor, "solid");
                this.pageGraphic.drawLine(startX - borderWidth / 2 + innerBorderWidth / 2, startY, endX - borderWidth / 2 + innerBorderWidth / 2, endY, innerBorderWidth, borderColor, "solid");
                break;
            }
            case 2: {
                this.pageGraphic.drawLine(startX, startY + borderWidth / 2 - outerBorderWidth / 2, endX, endY + borderWidth / 2 - outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                this.pageGraphic.drawLine(startX, startY - borderWidth / 2 + innerBorderWidth / 2, endX, endY - borderWidth / 2 + innerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                break;
            }
            case 3: {
                this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY, endX - borderWidth / 2 + outerBorderWidth / 2, endY, outerBorderWidth, borderColor, "solid");
                this.pageGraphic.drawLine(startX + borderWidth / 2 - innerBorderWidth / 2, startY, endX + borderWidth / 2 - innerBorderWidth / 2, endY, innerBorderWidth, borderColor, "solid");
            }
        }
    }

    private void drawBackgroundImage(String imageURI, int x, int y, int width, int height, float positionX, float positionY, String repeat, boolean xMode, boolean yMode) {
        if (imageURI == null) {
            return;
        }
        if (imageURI == null || "".equals(imageURI)) {
            return;
        }
        if (repeat == null) {
            repeat = "repeat";
        }
        Image img = null;
        try {
            img = Image.getInstance((URL)new URL(imageURI));
            int absPosX = xMode ? (int)(((float)width - img.scaledWidth() * 1000.0f) * positionX) : (int)positionX;
            int absPosY = yMode ? (int)(((float)height - img.scaledHeight() * 1000.0f) * positionY) : (int)positionY;
            this.pageGraphic.drawBackgroundImage(x, y, width, height, repeat, imageURI, absPosX, absPosY);
        }
        catch (Exception e) {
            this.log(e, Level.WARNING);
        }
    }

    private String getImageUrl(String imageUri) {
        URL url;
        String imageUrl = imageUri;
        if (this.reportDesign != null && (url = this.reportDesign.findResource(imageUri, 1)) != null) {
            imageUrl = url.toExternalForm();
        }
        return imageUrl;
    }

    protected int getX(IArea area) {
        return this.getScaledValue(area.getX());
    }

    protected int getY(IArea area) {
        return this.getScaledValue(area.getY());
    }

    protected int getWidth(IArea area) {
        return this.getScaledValue(area.getWidth());
    }

    protected int getHeight(IArea area) {
        return this.getScaledValue(area.getHeight());
    }

    protected int getScaledValue(int value) {
        return (int)((float)value * this.scale);
    }

    private int getScaledValue(CSSValue cssValue) {
        return this.getScaledValue(PropertyUtil.getDimensionValue(cssValue));
    }

    protected void drawTableBorder(TableArea table) {
        TableBorder tb = new TableBorder(table.getX(), table.getY());
        this.traverseRows(tb, table, tb.tableX, tb.tableY);
        this.drawBorder(tb);
    }

    private void traverseRows(TableBorder tb, IContainerArea container, int offsetX, int offsetY) {
        Iterator i = container.getChildren();
        while (i.hasNext()) {
            IArea area = (IArea)i.next();
            if (!(area instanceof IContainerArea)) continue;
            offsetX += area.getX();
            offsetY += area.getY();
            if (area instanceof RowArea) {
                this.handleBorderInRow(tb, (RowArea)area, offsetX, offsetY);
            } else {
                this.traverseRows(tb, (IContainerArea)area, offsetX, offsetY);
            }
            offsetX -= area.getX();
            offsetY -= area.getY();
        }
    }

    private void handleBorderInRow(TableBorder tb, RowArea row, int offsetX, int offsetY) {
        Iterator ri = row.getChildren();
        while (ri.hasNext()) {
            IArea area = (IArea)ri.next();
            if (!(area instanceof CellArea)) continue;
            CellArea cell = (CellArea)area;
            BorderInfo[] borders = this.cacheCellBorder(cell);
            int cellX = offsetX + cell.getX();
            int cellY = offsetY + cell.getY();
            int cellRx = cellX + cell.getWidth();
            int cellBy = cellY + cell.getHeight();
            tb.addColumn(cellRx);
            tb.addRow(cellBy);
            if (borders != null && borders[0].borderWidth != 0) {
                tb.setRowBorder(cellY, cellX, cellRx, borders[0].borderStyle, borders[0].borderWidth, borders[0].borderColor);
            }
            if (borders != null && borders[3].borderWidth != 0) {
                tb.setColumnBorder(cellX, cellY, cellBy, borders[3].borderStyle, borders[3].borderWidth, borders[3].borderColor);
            }
            if (borders != null && borders[2].borderWidth != 0) {
                tb.setRowBorder(cellBy, cellX, cellRx, borders[2].borderStyle, borders[2].borderWidth, borders[2].borderColor);
            }
            if (borders == null || borders[1].borderWidth == 0) continue;
            tb.setColumnBorder(cellRx, cellY, cellBy, borders[1].borderStyle, borders[1].borderWidth, borders[1].borderColor);
        }
    }
}

