/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;

public class BackgroundImageLayout {
    public static final int REPEAT_NONE = 0;
    public static final int REPEAT_X = 1;
    public static final int REPEAT_Y = 2;
    public static final int REPEAT_BOTH = 3;
    private Position areaPosition;
    private Position areaSize;
    private Position imagePosition;
    private Position imageSize;

    public BackgroundImageLayout(Position areaPosition, Position areaSize, Position imagePosition, Position imageSize) {
        this.areaPosition = areaPosition;
        this.areaSize = areaSize;
        this.imagePosition = imagePosition;
        this.imageSize = imageSize;
    }

    public List getImagePositions(int repeat) {
        if (repeat < 0 || repeat > 3) {
            throw new IllegalArgumentException(" repeat should in range 0-3 : " + repeat);
        }
        HashSet positions = new HashSet();
        this.calculateRepeatX(this.imagePosition, repeat, positions);
        if (BackgroundImageLayout.isRepeatY(repeat)) {
            float x = this.imagePosition.x;
            float y = this.imagePosition.y;
            while (y > this.areaPosition.y) {
                this.calculateRepeatX(new Position(x, y -= this.imageSize.y), repeat, positions);
            }
            y = this.imagePosition.y;
            while (y + this.imageSize.y < this.areaPosition.y + this.areaSize.y) {
                this.calculateRepeatX(new Position(x, y += this.imageSize.y), repeat, positions);
            }
        }
        List<Object> list = Arrays.asList(positions.toArray());
        Collections.sort(list);
        return list;
    }

    public List getImagePositions(String repeat) {
        int repeatMode = 3;
        if (!"repeat".equals(repeat)) {
            if ("repeat-x".equals(repeat)) {
                repeatMode = 1;
            } else if ("repeat-y".equals(repeat)) {
                repeatMode = 2;
            } else if ("no-repeat".equals(repeat)) {
                repeatMode = 0;
            }
        }
        return this.getImagePositions(repeatMode);
    }

    private void calculateRepeatX(Position initPosition, int repeat, Set positions) {
        positions.add(initPosition);
        if (BackgroundImageLayout.isRepeatX(repeat)) {
            float x = initPosition.x;
            float y = initPosition.y;
            while (x > this.areaPosition.x) {
                positions.add(new Position(x -= this.imageSize.x, y));
            }
            x = initPosition.x;
            while (x + this.imageSize.x < this.areaPosition.x + this.areaSize.x) {
                positions.add(new Position(x += this.imageSize.x, y));
            }
        }
    }

    private static boolean isRepeatX(int repeat) {
        return (repeat & 1) != 0;
    }

    private static boolean isRepeatY(int repeat) {
        return (repeat & 2) != 0;
    }
}

