/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.TableContentLayout;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class HTMLTableLayoutEmitter
extends ContentEmitterAdapter {
    static final Logger logger = Logger.getLogger(HTMLTableLayoutEmitter.class.getName());
    protected IContentEmitter emitter;
    protected TableContentLayout layout;
    protected Stack layoutEvents;
    protected IContentEmitter cellEmitter;
    protected HTMLLayoutContext context;
    protected Stack groupStack = new Stack();
    protected HashMap<String, UnresolvedRowHint> hintMap = new HashMap();
    protected boolean isFirst = true;
    int nestTableCount = 0;
    protected int lastRowId = -1;
    protected boolean firstCell = true;
    boolean hasDropCell = false;

    public HTMLTableLayoutEmitter(IContentEmitter emitter, HTMLLayoutContext context) {
        this.emitter = emitter;
        this.context = context;
    }

    public void end(IReportContent report) {
        this.emitter.end(report);
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void initialize(IEmitterServices service) {
        this.emitter.initialize(service);
    }

    public void start(IReportContent report) {
        this.emitter.start(report);
    }

    protected int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    protected boolean isContentFinished(IContent content) {
        if (this.context != null) {
            return this.context.getLayoutHint(content);
        }
        return true;
    }

    protected boolean allowPageBreak() {
        if (this.context != null) {
            return this.context.allowPageBreak();
        }
        return false;
    }

    public void startContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.startContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.startContent(content, this.emitter);
        }
    }

    public void endContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.endContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.endContent(content, this.emitter);
        }
    }

    public void resetLayout() {
        this.layout.reset();
        this.layoutEvents.clear();
        this.hasDropCell = false;
    }

    public void initLayout(ITableContent table) {
        String keyString = this.context.getHintMapKey(table.getInstanceID().toUniqueString());
        this.layout = new TableContentLayout(table, this.getOutputFormat(), this.context, keyString);
        this.layoutEvents = new Stack();
        UnresolvedRowHint hint = null;
        if (this.isFirst && this.context != null) {
            hint = this.context.getUnresolvedRowHint(keyString);
            this.isFirst = false;
        }
        if (hint == null) {
            hint = this.hintMap.get(keyString);
        }
        this.layout.setUnresolvedRowHint(hint);
    }

    public boolean isLayoutStarted() {
        return this.layout != null;
    }

    protected boolean hasDropCell() {
        return this.hasDropCell;
    }

    protected int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public void resolveCellsOfDrop(int groupLevel, boolean dropAll, boolean finished) {
        if (this.hasDropCell) {
            if (dropAll) {
                this.layout.resolveDropCells(this.createDropID(groupLevel, "all"), finished);
            } else {
                this.layout.resolveDropCells(this.createDropID(groupLevel, "detail"), finished);
            }
            this.hasDropCell = this.layout.hasDropCell();
        }
    }

    public void flush() {
        if (this.hasDropCell()) {
            return;
        }
        for (LayoutEvent event : this.layoutEvents) {
            switch (event.eventType) {
                case 0: 
                case 1: {
                    ContentEmitterUtil.startContent((IContent)event.value, this.emitter);
                    break;
                }
                case 2: 
                case 3: {
                    ContentEmitterUtil.endContent((IContent)event.value, this.emitter);
                    break;
                }
                case 4: {
                    this.flushRow(((StartInfo)event.value).rowId, 0, true);
                    break;
                }
                case 5: {
                    this.flushRow(((StartInfo)event.value).rowId, ((StartInfo)event.value).cellId, false);
                }
            }
        }
        this.resetLayout();
    }

    protected void flushRow(int rowId, int colId, boolean withStart) {
        int colCount = this.layout.getColCount();
        int columnId = this.layout.getColumnId(colId);
        Row row = this.layout.getRow(rowId);
        IRowContent rowContent = (IRowContent)row.getContent();
        if (withStart) {
            this.emitter.startRow(rowContent);
        }
        int j = columnId;
        while (j < colCount) {
            Cell cell = row.getCell(j);
            if (cell.getStatus() == 1) {
                CellContent content = (CellContent)cell.getContent();
                CellContentWrapper tempCell = new CellContentWrapper(content.cell);
                tempCell.setColumn(cell.getColId());
                tempCell.setRowSpan(cell.getRowSpan());
                tempCell.setColSpan(cell.getColSpan());
                this.emitter.startCell(tempCell);
                if (content.buffer != null) {
                    content.buffer.flush();
                }
                this.emitter.endCell(tempCell);
            }
            if (cell.getStatus() == 0) {
                IReportContent report = rowContent.getReportContent();
                ICellContent cellContent = report.createCellContent();
                cellContent.setParent(rowContent);
                cellContent.setColumn(cell.getColId() + 1);
                cellContent.setRowSpan(cell.getRowSpan());
                cellContent.setColSpan(cell.getColSpan());
                this.emitter.startCell(cellContent);
                this.emitter.endCell(cellContent);
            }
            ++j;
        }
        this.emitter.endRow(rowContent);
    }

    private boolean isNestTable() {
        return this.nestTableCount > 1;
    }

    public void startTable(ITableContent table) {
        ++this.nestTableCount;
        if (this.cellEmitter != null) {
            this.cellEmitter.startTable(table);
        } else if (!this.isNestTable()) {
            this.initLayout(table);
            this.emitter.startTable(this.layout.getWrappedTableContent());
            this.lastRowId = -1;
        } else {
            this.emitter.startTable(table);
        }
    }

    public void resolveAll(boolean finished) {
        this.layout.resolveDropCells(finished);
        UnresolvedRowHint hint = this.layout.getUnresolvedRow();
        if (hint != null) {
            this.hintMap.put(this.layout.getKeyString(), hint);
            if (this.context != null) {
                this.context.addUnresolvedRowHint(this.layout.getKeyString(), hint);
            }
        }
        this.hasDropCell = this.layout.hasDropCell();
    }

    public void createCell(int colId, int rowSpan, int colSpan, Cell.Content cellContent) {
        this.layout.createCell(colId, rowSpan, colSpan, cellContent);
        if (rowSpan < 0 || rowSpan > 1) {
            this.hasDropCell = true;
        }
    }

    public void endTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTable(table);
        } else if (!this.isNestTable()) {
            this.resolveAll(this.isContentFinished(table));
            this.flush();
            this.emitter.endTable(this.layout.getWrappedTableContent());
        } else {
            this.emitter.endTable(table);
        }
        --this.nestTableCount;
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = group.getGroupLevel();
                this.groupStack.push(new Integer(groupLevel));
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new LayoutEvent(0, group));
                    return;
                }
            }
            this.emitter.startTableGroup(group);
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = this.getGroupLevel();
                this.resolveCellsOfDrop(groupLevel, false, this.isContentFinished(group));
                this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(group));
                assert (!this.groupStack.isEmpty());
                this.groupStack.pop();
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new LayoutEvent(2, group));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableGroup(group);
        }
    }

    public void startTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, false, true);
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new LayoutEvent(1, band));
                    return;
                }
                this.flush();
            }
            this.emitter.startTableBand(band);
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (LayoutUtil.isRepeatableBand(band)) {
                    this.lastRowId = -1;
                }
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(band));
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new LayoutEvent(3, band));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableBand(band);
        }
    }

    public void startRow(IRowContent row) {
        this.firstCell = true;
        if (this.cellEmitter != null) {
            this.cellEmitter.startRow(row);
        } else {
            boolean isHidden = LayoutUtil.isHidden(row, this.emitter.getOutputFormat(), this.context.getOutputDisplayNone());
            if (!this.isNestTable()) {
                int rowId = row.getRowID();
                if (this.lastRowId >= 0 && rowId > this.lastRowId + 1) {
                    int i = this.lastRowId + 1;
                    while (i < rowId) {
                        IRowContent newRow = (IRowContent)row.cloneContent(false);
                        newRow.setParent(row.getParent());
                        newRow.setRowID(i);
                        this.startRow(newRow);
                        this.endRow(newRow);
                        ++i;
                    }
                }
                this.layout.createRow(row, isHidden);
                if (!isHidden) {
                    if (this.hasDropCell()) {
                        this.layoutEvents.push(new LayoutEvent(4, new StartInfo(this.layout.getRowCount() - 1, 0)));
                        return;
                    }
                    if (this.layout.hasUnResolvedRow() && !LayoutUtil.isRepeatableRow(row)) {
                        this.layoutEvents.push(new LayoutEvent(4, new StartInfo(this.layout.getRowCount() - 1, 0)));
                        this.hasDropCell = true;
                        return;
                    }
                }
            }
            if (!isHidden) {
                this.emitter.startRow(row);
            }
        }
    }

    public void endRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endRow(row);
        } else {
            boolean isHidden;
            if (!this.isNestTable()) {
                this.layout.endRow(row);
                this.lastRowId = row.getRowID();
                this.hasDropCell = this.layout.hasDropCell();
                if (this.hasDropCell()) {
                    return;
                }
                if (this.layoutEvents.size() > 0) {
                    this.flush();
                    return;
                }
            }
            if (!(isHidden = LayoutUtil.isHidden(row, this.emitter.getOutputFormat(), this.context.getOutputDisplayNone()))) {
                this.emitter.endRow(row);
            }
        }
    }

    public void startCell(ICellContent cell) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startCell(cell);
        } else if (!this.isNestTable()) {
            String dropType;
            CellDesign cellDesign;
            BufferedReportEmitter buffer = null;
            int colId = cell.getColumn();
            int colSpan = cell.getColSpan();
            int rowSpan = cell.getRowSpan();
            if (cell.getGenerateBy() instanceof CellDesign && (cellDesign = (CellDesign)cell.getGenerateBy()) != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
                rowSpan = this.createDropID(this.getGroupLevel(), dropType);
            }
            if (!(this.hasDropCell() || rowSpan >= 0 && rowSpan <= 1)) {
                this.layoutEvents.push(new LayoutEvent(5, new StartInfo(this.layout.getRowCount() - 1, colId)));
            }
            if (this.hasDropCell() || rowSpan < 0 || rowSpan > 1) {
                buffer = new BufferedReportEmitter(this.emitter);
                this.cellEmitter = buffer;
            }
            this.createCell(colId, rowSpan, colSpan, new CellContent(cell, buffer));
            if (this.hasDropCell()) {
                return;
            }
            ICellContent cc = this.layout.getWrappedCellContent(cell);
            if (this.firstCell && cc.getColumn() != 0) {
                ICellContent newCell = (ICellContent)cc.cloneContent(false);
                newCell.setParent(cc.getParent());
                newCell.setColumn(0);
                newCell.setColSpan(cc.getColumn());
                this.emitter.startCell(newCell);
                this.emitter.endCell(newCell);
            }
            this.emitter.startCell(cc);
        } else {
            this.emitter.startCell(cell);
        }
    }

    public void endCell(ICellContent cell) {
        this.firstCell = false;
        if (!this.isNestTable()) {
            if (this.cellEmitter != null) {
                this.cellEmitter = null;
                return;
            }
            this.emitter.endCell(this.layout.getWrappedCellContent(cell));
        } else if (this.cellEmitter != null) {
            this.cellEmitter.endCell(cell);
        } else {
            this.emitter.endCell(cell);
        }
    }

    public IContentEmitter getInternalEmitter() {
        return this.emitter;
    }

    public static class CellContent
    implements Cell.Content {
        protected ICellContent cell;
        protected BufferedReportEmitter buffer;

        public CellContent(ICellContent cell, BufferedReportEmitter buffer) {
            this.cell = cell;
            this.buffer = buffer;
        }

        public ICellContent getContent() {
            return this.cell;
        }

        public boolean isEmpty() {
            return this.buffer == null || this.buffer.isEmpty();
        }

        public void reset() {
            this.buffer = null;
        }
    }

    protected static class LayoutEvent {
        static final int START_GROUP = 0;
        static final int START_BAND = 1;
        static final int END_GROUP = 2;
        static final int END_BAND = 3;
        static final int ON_ROW = 4;
        static final int ON_FIRST_DROP_CELL = 5;
        int eventType;
        Object value;

        LayoutEvent(int type, Object value) {
            this.eventType = type;
            this.value = value;
        }
    }

    protected static class StartInfo {
        int rowId;
        int cellId;

        StartInfo(int rowId, int cellId) {
            this.rowId = rowId;
            this.cellId = cellId;
        }
    }
}

