/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.buffer.AbstractNode;
import org.eclipse.birt.report.engine.layout.html.buffer.HTMLPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.LeafBufferNode;
import org.eclipse.birt.report.engine.layout.html.buffer.PageNode;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;

public class CachedHTMLPageBuffer
extends HTMLPageBuffer
implements IPageBuffer {
    protected boolean cached = true;
    protected PageNode page = null;

    public CachedHTMLPageBuffer(HTMLLayoutContext context, boolean cached) {
        super(context);
        this.cached = cached;
    }

    public void startContent(IContent content, IContentEmitter emitter, boolean visible) {
        if (!this.cached) {
            super.startContent(content, emitter, visible);
            return;
        }
        LeafBufferNode leafNode = new LeafBufferNode(content, emitter, this.generator, visible);
        this.setup(leafNode, true);
    }

    public void endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) {
        if (!this.cached) {
            super.endContainer(content, finished, emitter, visible);
            return;
        }
        int type = content.getContentType();
        switch (type) {
            case 9: 
            case 14: {
                boolean isFinished = finished && !this.isRepeated;
                this._endContainer(content, isFinished, emitter, visible);
                break;
            }
            case 7: {
                this.page = (PageNode)this.currentNode;
                this._endContainer(content, finished, emitter, visible);
                this.finished = true;
                break;
            }
            default: {
                this._endContainer(content, finished, emitter, visible);
            }
        }
    }

    public void clearCache() {
        if (this.currentNode != null) {
            this.currentNode.start();
            this.cached = false;
        }
    }

    private void _endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) {
        ((AbstractNode)((Object)this.currentNode)).setFinished(finished);
        this.currentNode = this.currentNode.getParent();
    }

    protected void pageBreakEvent() {
        this.context.setPageHint(this.generator.getPageHint());
        long pageNumber = this.context.getPageNumber();
        ILayoutPageHandler pageHandler = this.context.getLayoutEngine().getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(pageNumber, this.context);
        }
    }

    public void addTableColumnHint(TableColumnHint hint) {
        this.columnHints.add(hint);
    }

    private void setup(AbstractNode node, boolean isFirst) {
        node.setFirst(isFirst);
        if (this.currentNode != null) {
            node.setParent(this.currentNode);
            this.currentNode.addChild(node);
        }
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public void setRepeated(boolean isRepeated) {
        this.isRepeated = isRepeated;
    }

    public void flush() {
        if (this.page != null) {
            this.context.addTableColumnHints(this.columnHints);
            this.context.generatePageRowHints(this.getTableKeys());
            this.page.flush();
            this.pageBreakEvent();
            if (!this.page.finished) {
                this.context.setPageNumber(this.context.getPageNumber() + 1L);
                this.context.setPageCount(this.context.getPageCount() + 1L);
            }
            this.generator.reset();
            this.context.clearPageHint();
            this.currentNode = null;
        }
    }
}

