/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.w3c.dom.css.CSSValue;

public abstract class PDFAbstractLM
implements ILayoutManager {
    protected static final int STATUS_START = 0;
    protected static final int STATUS_INPROGRESS = 1;
    protected static final int STATUS_END = 3;
    protected int status = 0;
    protected static Logger logger = Logger.getLogger(PDFAbstractLM.class.getName());
    protected PDFStackingLM parent;
    protected IContent content;
    protected PDFLayoutEngineContext context;
    protected IReportItemExecutor executor;
    protected boolean isFirst = true;
    protected boolean isLast = false;
    protected int specifiedWidth = 0;
    protected int specifiedHeight = 0;

    public IContent getContent() {
        return this.content;
    }

    public PDFAbstractLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        this.context = context;
        this.content = content;
        this.parent = parent;
        this.executor = executor;
    }

    public boolean layout() {
        boolean hasNextPage = false;
        switch (this.status) {
            case 0: {
                if (this.handleVisibility()) {
                    this.status = 3;
                    return false;
                }
                if (this.handlePageBreakBefore() || this.checkAvailableSpace()) {
                    this.status = 1;
                    return true;
                }
                this.status = 1;
            }
            case 1: {
                hasNextPage = this.layoutChildren();
                if (hasNextPage) {
                    if (!this.hasNextChild()) {
                        this.closeExecutor();
                        this.status = 3;
                    }
                    return true;
                }
                this.closeExecutor();
                this.status = 3;
                if (this.handlePageBreakAfter()) {
                    return true;
                }
            }
            case 3: {
                return false;
            }
        }
        return hasNextPage;
    }

    protected abstract boolean hasNextChild();

    protected void closeExecutor() {
        if (this.executor != null) {
            this.executor.close();
        }
    }

    protected abstract boolean layoutChildren();

    public boolean isFinished() {
        return this.status == 3;
    }

    protected boolean allowPageBreak() {
        return true;
    }

    public PDFStackingLM getParent() {
        return this.parent;
    }

    protected PDFLayoutManagerFactory getFactory() {
        return this.context.getFactory();
    }

    protected boolean handlePageBreakBefore() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakBefore();
        this.handlePageBreakBeforeAvoid(pageBreak);
        if (this.canPageBreak()) {
            return this.needPageBreakBefore(pageBreak);
        }
        return false;
    }

    protected boolean handlePageBreakAfter() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakAfter();
        this.handlePageBreakAfterAvoid(pageBreak);
        if (this.canPageBreak()) {
            return this.needPageBreakAfter(pageBreak);
        }
        return false;
    }

    protected void handlePageBreakBeforeAvoid(String pageBreak) {
        if (this.parent instanceof PDFBlockStackingLM) {
            ((PDFBlockStackingLM)this.parent).setKeepWithNext("avoid" == pageBreak);
        }
    }

    protected void handlePageBreakAfterAvoid(String pageBreak) {
        if ("avoid" == pageBreak && this.parent instanceof PDFBlockStackingLM) {
            ((PDFBlockStackingLM)this.parent).setKeepWithNext(true);
        }
    }

    protected boolean canPageBreak() {
        if (!this.context.allowPageBreak()) {
            return false;
        }
        PDFStackingLM p = this.parent;
        while (p != null) {
            if (!p.allowPageBreak()) {
                return false;
            }
            p = p.getParent();
        }
        return true;
    }

    protected boolean needPageBreakBefore(String pageBreak) {
        boolean ret = this.hasMasterPageChanged();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak || "soft" == pageBreak) {
            return true;
        }
        return ret;
    }

    protected boolean needPageBreakAfter(String pageBreak) {
        return "always" == pageBreak || "left" == pageBreak || "right" == pageBreak;
    }

    private boolean hasMasterPageChanged() {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        if (style == null) {
            return false;
        }
        String newMasterPage = style.getMasterPage();
        if (newMasterPage == null || "".equals(newMasterPage)) {
            return false;
        }
        String masterPage = this.context.getMasterPage();
        if (!newMasterPage.equalsIgnoreCase(masterPage) && (pageSetup = this.content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.context.setMasterPage(newMasterPage);
            return true;
        }
        return false;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        String masterPage = this.context.getMasterPage();
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return this.getDefaultMasterPage(report);
    }

    protected MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            MasterPageDesign pageDesign = pageSetup.getMasterPage(0);
            this.context.setMasterPage(pageDesign.getName());
            return pageDesign;
        }
        return null;
    }

    protected boolean handleVisibility() {
        if (this.isHidden()) {
            this.traverse(this.executor);
            return true;
        }
        return false;
    }

    private void traverse(IReportItemExecutor executor) {
        if (executor != null) {
            while (executor.hasNextChild()) {
                IReportItemExecutor child = executor.getNextChild();
                if (child == null) continue;
                child.execute();
                this.traverse(child);
                child.close();
            }
        }
    }

    public abstract void autoPageBreak();

    protected abstract void cancelChildren();

    public void cancel() {
        if (this.executor != null && this.status != 3) {
            this.cancelChildren();
            this.executor.close();
        }
    }

    protected void execute(IReportItemExecutor executor, IContent content) {
        if (executor != null) {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                content.getChildren().add(childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }
    }

    protected boolean checkAvailableSpace() {
        int leftHeight;
        if (this.parent != null && (leftHeight = this.parent.getCurrentMaxContentHeight()) < Math.max(5000, this.specifiedHeight)) {
            this.context.setAutoPageBreak(true);
            return true;
        }
        return false;
    }

    protected void removeBoxProperty(IStyle style) {
        this.removePadding(style);
        this.removeBorder(style);
        this.removeMargin(style);
    }

    protected void removePadding(IStyle style) {
        if (style != null) {
            style.setProperty(30, IStyle.NUMBER_0);
            style.setProperty(44, IStyle.NUMBER_0);
            style.setProperty(50, IStyle.NUMBER_0);
            style.setProperty(45, IStyle.NUMBER_0);
        }
    }

    protected void removeBorder(IStyle style) {
        if (style != null) {
            style.setProperty(51, IStyle.NUMBER_0);
            style.setProperty(21, IStyle.NUMBER_0);
            style.setProperty(57, IStyle.NUMBER_0);
            style.setProperty(22, IStyle.NUMBER_0);
        }
    }

    protected void removeMargin(IStyle style) {
        if (style != null) {
            style.setProperty(1, IStyle.NUMBER_0);
            style.setProperty(2, IStyle.NUMBER_0);
            style.setProperty(28, IStyle.NUMBER_0);
            style.setProperty(18, IStyle.NUMBER_0);
        }
    }

    protected boolean isHidden() {
        if (this.content != null) {
            IStyle style = this.content.getComputedStyle();
            boolean outputDisplayNone = this.context.getOutputDisplayNone();
            if (!outputDisplayNone && IStyle.NONE_VALUE.equals(style.getProperty(33))) {
                return true;
            }
            return this.isHiddenByVisibility();
        }
        return false;
    }

    protected boolean isHiddenByVisibility() {
        if (this.content != null) {
            IStyle style = this.content.getComputedStyle();
            ListValue formats = (ListValue)style.getProperty(35);
            if (formats.getLength() == 0) {
                return false;
            }
            String format = this.context.getFormat();
            int i = 0;
            while (i < formats.getLength()) {
                String hiddenFormat = formats.item(i).getCssText();
                if (format.equalsIgnoreCase(hiddenFormat) || "all".equalsIgnoreCase(hiddenFormat)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    protected void calculateSpecifiedHeight() {
        int calHeight;
        if (this.content != null && (calHeight = this.getDimensionValue(this.content.getHeight())) > 0) {
            this.specifiedHeight = Math.min(calHeight, this.context.getMaxHeight());
        }
    }

    protected void calculateSpecifiedWidth() {
        int calWidth;
        if (this.content != null && (calWidth = this.getDimensionValue(this.content.getWidth(), this.parent.getCurrentMaxContentWidth())) > 0 && calWidth < this.context.getMaxWidth()) {
            this.specifiedWidth = calWidth;
        }
    }

    protected void validateBoxProperty(IStyle style, int maxWidth, int maxHeight) {
        int leftMargin = this.getDimensionValue(style.getProperty(1), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(2), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(28), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(18), maxWidth);
        int leftPadding = Math.max(0, this.getDimensionValue(style.getProperty(30), maxWidth));
        int rightPadding = Math.max(0, this.getDimensionValue(style.getProperty(44), maxWidth));
        int topPadding = Math.max(0, this.getDimensionValue(style.getProperty(50), maxWidth));
        int bottomPadding = Math.max(0, this.getDimensionValue(style.getProperty(45), maxWidth));
        int leftBorder = Math.max(0, this.getDimensionValue(style.getProperty(51), 0));
        int rightBorder = Math.max(0, this.getDimensionValue(style.getProperty(21), 0));
        int topBorder = Math.max(0, this.getDimensionValue(style.getProperty(57), 0));
        int bottomBorder = Math.max(0, this.getDimensionValue(style.getProperty(22), 0));
        int[] vs = new int[]{rightMargin, leftMargin, rightPadding, leftPadding, rightBorder, leftBorder};
        this.resolveBoxConflict(vs, maxWidth);
        int[] hs = new int[]{bottomMargin, topMargin, bottomPadding, topPadding, bottomBorder, topBorder};
        this.resolveBoxConflict(hs, maxHeight);
        style.setProperty(1, new FloatValue(1, vs[1]));
        style.setProperty(2, new FloatValue(1, vs[0]));
        style.setProperty(28, new FloatValue(1, hs[1]));
        style.setProperty(18, new FloatValue(1, hs[0]));
        style.setProperty(30, new FloatValue(1, vs[3]));
        style.setProperty(44, new FloatValue(1, vs[2]));
        style.setProperty(50, new FloatValue(1, hs[3]));
        style.setProperty(45, new FloatValue(1, hs[2]));
        style.setProperty(51, new FloatValue(1, vs[5]));
        style.setProperty(21, new FloatValue(1, vs[4]));
        style.setProperty(57, new FloatValue(1, hs[5]));
        style.setProperty(22, new FloatValue(1, hs[4]));
    }

    protected int getDimensionValue(String d) {
        if (d == null) {
            return 0;
        }
        try {
            if (d.endsWith("in") || d.endsWith("in")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f);
            }
            if (d.endsWith("cm") || d.endsWith("CM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f / 2.54f);
            }
            if (d.endsWith("mm") || d.endsWith("MM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 7200.0f / 2.54f);
            }
            if (d.endsWith("px") || d.endsWith("PX")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() / 96.0f * 72000.0f);
            }
            return (int)Float.valueOf(d).floatValue();
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage());
            return 0;
        }
    }

    protected int getDimensionValue(DimensionType d) {
        return this.getDimensionValue(d, 0);
    }

    protected int getDimensionValue(DimensionType d, int referenceLength) {
        if (d == null) {
            return 0;
        }
        try {
            String units = d.getUnits();
            if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                double point = d.convertTo("pt") * 1000.0;
                return (int)point;
            }
            if (units.equals("px")) {
                double point = d.getMeasure() / 72.0 * 72000.0;
                return (int)point;
            }
            if (units.equals("%")) {
                double point = (double)referenceLength * d.getMeasure() / 100.0;
                return (int)point;
            }
            if (units.equals("em") || units.equals("ex")) {
                double point = (double)referenceLength * d.getMeasure();
                return (int)point;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return 0;
        }
        return 0;
    }

    protected int getDimensionValue(CSSValue value) {
        return this.getDimensionValue(value, 0);
    }

    protected int getDimensionValue(CSSValue value, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((double)((float)referenceLength * v) / 100.0);
                }
            }
        }
        return 0;
    }

    protected PDFTableLM getTableLayoutManager() {
        PDFStackingLM lm = this.parent;
        while (lm != null && !(lm instanceof PDFTableLM)) {
            lm = lm.getParent();
        }
        if (lm == null) assert (false);
        return (PDFTableLM)lm;
    }

    protected void resolveBoxConflict(int[] vs, int max) {
        int vTotal = 0;
        int i = 0;
        while (i < vs.length) {
            vTotal += vs[i];
            ++i;
        }
        this.resolveConflict(vs, max, vTotal, 0);
    }

    private void resolveConflict(int[] values, int maxTotal, int total, int start) {
        int length = values.length - start;
        if (length == 0) {
            return;
        }
        assert (length > 0);
        if (total > maxTotal) {
            int othersTotal = total - values[start];
            if (values[start] > 0) {
                values[start] = 0;
            }
            this.resolveConflict(values, maxTotal, othersTotal, start + 1);
        }
    }

    protected void removeBottomBorder(RowArea row) {
        Iterator iter = row.getChildren();
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            if (cell == null) continue;
            IStyle style = cell.getStyle();
            style.setProperty(22, IStyle.NUMBER_0);
        }
    }

    public boolean pageBreakBeforeAvoid() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakBefore();
        return "avoid" == pageBreak;
    }

    public boolean pageBreakAfterAvoid() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakAfter();
        return "avoid" == pageBreak;
    }

    public boolean pageBreakInsideAvoid() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakInside();
        return "avoid" == pageBreak;
    }

    public void close() {
    }

    protected IArea createBlockTextArea(String text, ITextContent content, FontInfo fi, Dimension contentDimension) {
        AbstractArea textArea = (AbstractArea)AreaFactory.createTextArea(content, text, fi);
        textArea.setWidth(Math.min(this.context.getMaxWidth(), contentDimension.getWidth()));
        textArea.setHeight(Math.min(this.context.getMaxHeight(), contentDimension.getHeight()));
        return textArea;
    }

    protected class ReportStackingExecutor
    extends ReportItemExecutorBase {
        IReportExecutor executor;

        public ReportStackingExecutor(IReportExecutor executor) {
            this.executor = executor;
        }

        public void close() {
            this.executor.close();
        }

        public IContent execute() {
            return null;
        }

        public IReportItemExecutor getNextChild() {
            return this.executor.getNextChild();
        }

        public boolean hasNextChild() {
            return this.executor.hasNextChild();
        }
    }
}

