/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class BlockStackingLayout
extends ContainerLayout {
    public BlockStackingLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.isInline = false;
    }

    protected void initialize() {
        this.currentContext = new ContainerLayout.ContainerContext(this);
        this.contextList.add(this.currentContext);
        this.createRoot();
        this.validateBoxProperty(this.content, this.currentContext.root.getStyle(), this.parent.getCurrentMaxContentWidth(), this.context.getMaxHeight());
        this.calculateSpecifiedWidth();
        this.offsetX = this.currentContext.root.getContentX();
        this.offsetY = this.currentContext.root.getContentY();
        if (this.specifiedWidth > 0) {
            this.currentContext.root.setAllocatedWidth(this.specifiedWidth);
        } else {
            this.currentContext.root.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        }
        this.currentContext.maxAvaWidth = this.currentContext.root.getContentWidth();
        this.currentContext.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.currentContext.maxAvaHeight = this.currentContext.root.getContentHeight();
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
        if (currentContext.root == null) {
            return;
        }
        if (!finished && currentContext.root.getChildrenCount() == 0) {
            return;
        }
        IStyle areaStyle = currentContext.root.getStyle();
        int height = currentContext.currentBP + this.getOffsetY() + this.getDimensionValue(areaStyle.getProperty(45)) + this.getDimensionValue(areaStyle.getProperty(22));
        this.calculateSpecifiedHeight();
        if (this.specifiedHeight > height) {
            CSSValue verticalAlign = areaStyle.getProperty(31);
            if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                int offset = this.specifiedHeight - height;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    Iterator iter = currentContext.root.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    Iterator iter = currentContext.root.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
            height = this.specifiedHeight;
        }
        currentContext.root.setHeight(height);
        if (this.parent != null) {
            this.parent.addToRoot((AbstractArea)currentContext.root, index);
        } else {
            this.content.setExtension(1, currentContext.root);
        }
    }

    protected void createRoot() {
        this.currentContext.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getLineHeight(contentStyle.getLineHeight());
        }
        return 0;
    }

    public String getTextAlign() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return contentStyle.getTextAlign();
        }
        return null;
    }
}

