/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableAreaLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;

public class RowLayout
extends ContainerLayout {
    protected TableLayout tbl = this.getTableLayoutManager();
    protected TableAreaLayout.Row unresolvedRow = null;

    public RowLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
    }

    protected void createRoot() {
        this.currentContext.root = AreaFactory.createRowArea((IRowContent)this.content);
    }

    protected void initialize() {
        this.calculateSpecifiedHeight();
        if (this.specifiedHeight > this.parent.getCurrentMaxContentHeight() && !this.parent.isPageEmpty()) {
            this.parent.autoPageBreak();
            if (this.isInBlockStacking && this.parent.contextList.size() > 1) {
                this.parent.closeExcludingLast();
            }
        }
        this.currentContext = new ContainerLayout.ContainerContext();
        this.contextList.add(this.currentContext);
        this.createRoot();
        this.currentContext.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.currentContext.root.setWidth(this.getCurrentMaxContentWidth());
        this.currentContext.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.currentContext.maxAvaHeight = this.currentContext.root.getContentHeight();
    }

    protected void closeLayout() {
        int size = this.contextList.size();
        int i = 0;
        while (i < size) {
            int parentSize = this.parent.contextList.size();
            this.closeLayout((ContainerLayout.ContainerContext)this.contextList.removeFirst(), parentSize - size + i, size, i, i == size - 1);
            ++i;
        }
        if (this.isInBlockStacking && size > 1) {
            this.parent.closeExcludingLast();
        }
        this.parent.gotoLastPage();
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int parentIndex, int size, int index, boolean finished) {
        if (currentContext.root != null) {
            int tableSize = this.tbl.contextList.size();
            if (this.unresolvedRow != null) {
                TableLayout.TableContext tc = (TableLayout.TableContext)this.tbl.contextList.get(tableSize - size + index);
                tc.layout.setUnresolvedRow(this.unresolvedRow);
            }
            boolean isRowEmpty = this.isRowEmpty(currentContext);
            if (finished || !isRowEmpty) {
                this.tbl.addRow((RowArea)currentContext.root, this.specifiedHeight, index, size);
                this.parent.addToRoot((AbstractArea)currentContext.root, parentIndex);
            }
            if (!finished && this.unresolvedRow == null) {
                TableLayout.TableContext tc = (TableLayout.TableContext)this.tbl.contextList.get(tableSize - size + index);
                this.unresolvedRow = isRowEmpty ? tc.layout.createUnresolvedRow((RowArea)currentContext.root) : tc.layout.getUnresolvedRow();
            }
        }
    }

    protected void closeExcludingLast() {
        int size = this.contextList.size();
        this.closeFirstN(size - 1);
    }

    protected void closeFirstN(int size) {
        int rowSize = this.contextList.size();
        int i = 0;
        while (i < size) {
            this.closeLayout((ContainerLayout.ContainerContext)this.contextList.removeFirst(), i, rowSize, i, false);
            ++i;
        }
        this.setCurrentContext(0);
        if (this.parent != null) {
            this.parent.closeFirstN(size);
        }
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
    }

    protected boolean isRowEmpty(ContainerLayout.ContainerContext currentContext) {
        Iterator iter = currentContext.root.getChildren();
        while (iter.hasNext()) {
            ContainerArea area = (ContainerArea)iter.next();
            if (area.getChildrenCount() <= 0) continue;
            return false;
        }
        return true;
    }

    protected void addToRoot(AbstractArea area) {
        CellArea cArea = (CellArea)area;
        this.currentContext.root.addChild(area);
        int columnID = cArea.getColumnID();
        int colSpan = cArea.getColSpan();
        if (colSpan > 1 && this.content.isRTL()) {
            columnID += colSpan - 1;
        }
        cArea.setPosition(this.tbl.getXPos(columnID), 0);
    }
}

