/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LineLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TextCompositor;

public class TextAreaLayout
extends ContainerLayout {
    private InlineStackingLayout parentLM;
    private TextCompositor comp = null;
    private ITextContent textContent = null;
    private static HashSet splitChar = new HashSet();

    static {
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\r'));
        splitChar.add(new Character('\n'));
    }

    public TextAreaLayout(LayoutEngineContext context, ContainerLayout parentContext, IContent content) {
        super(context, parentContext, content);
        this.parentLM = (InlineStackingLayout)parentContext;
        ITextContent textContent = (ITextContent)content;
        this.parentLM.setTextIndent(textContent);
        String text = textContent.getText();
        if (text != null && text.length() != 0) {
            this.transform(textContent);
            this.textContent = textContent;
            this.comp = new TextCompositor(textContent, context.getFontManager(), context.getBidiProcessing(), context.getFontSubstitution(), context.getTextWrapping(), context.isEnableHyphenation(), context.getLocale());
            ContainerLayout ancestor = this.parentLM;
            while (true) {
                if (ancestor == null) {
                    this.comp.setNewLineStatus(true);
                    return;
                }
                if (!ancestor.isRootEmpty()) {
                    this.comp.setNewLineStatus(false);
                    return;
                }
                if (ancestor instanceof LineLayout) {
                    this.comp.setNewLineStatus(ancestor.isRootEmpty());
                    return;
                }
                ancestor = ancestor.getParent();
            }
        }
    }

    public boolean addArea(AbstractArea area) {
        return false;
    }

    protected void createRoot() {
    }

    public void layout() {
        while (this.layoutChildren()) {
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean layoutChildren() {
        if (this.textContent != null) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            area = this.comp.getNextArea(this.getFreeSpace());
            this.addTextArea(area);
            this.comp.setNewLineStatus(false);
            if (!area.isLineBreak()) continue;
            if (this.newLine()) {
                this.comp.setNewLineStatus(true);
                continue;
            }
            return true;
lbl11:
            // 3 sources

            ** while (this.comp.hasNextArea())
        }
lbl12:
        // 1 sources

        return false;
    }

    protected boolean checkAvailableSpace() {
        return false;
    }

    public void addTextArea(AbstractArea textArea) {
        this.parentLM.addToRoot(textArea);
    }

    public boolean newLine() {
        return this.parentLM.endLine();
    }

    public int getFreeSpace() {
        return this.parentLM.getCurrentMaxContentWidth();
    }

    public void transform(ITextContent textContent) {
        String transformType = textContent.getComputedStyle().getTextTransform();
        if (transformType.equalsIgnoreCase("uppercase")) {
            textContent.setText(textContent.getText().toUpperCase());
        } else if (transformType.equalsIgnoreCase("lowercase")) {
            textContent.setText(textContent.getText().toLowerCase());
        } else if (transformType.equalsIgnoreCase("capitalize")) {
            textContent.setText(this.capitalize(textContent.getText()));
        }
        ArabicShaping shaping = new ArabicShaping(8);
        try {
            String shapingText = shaping.shape(textContent.getText());
            textContent.setText(shapingText);
        }
        catch (ArabicShapingException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = new Character(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    protected void closeLayout() {
    }

    protected void initialize() {
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
    }
}

