/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.birt.report.engine.layout.pdf.font.CharSegment;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;

public class FontCacheUtils {
    public static void main(String[] args) throws Exception {
        FontCacheUtils.createUnicodeText("unicode.txt");
        FontCacheUtils.createUnicodePDF("pdf", Locale.CHINESE, "unicode.pdf");
    }

    static void createUnicodeText(String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
        int seg = 0;
        while (seg < 255) {
            StringBuffer sb = new StringBuffer();
            sb.append(Integer.toHexString(seg * 255)).append('\n');
            writer.write(sb.toString());
            int hi = 0;
            while (hi < 16) {
                sb.setLength(0);
                int lo = 0;
                while (lo < 16) {
                    char ch = (char)(seg * 255 + hi * 16 + lo);
                    if (Character.isISOControl(ch)) {
                        ch = '?';
                    }
                    sb.append(ch).append(' ');
                    ++lo;
                }
                sb.append('\n');
                writer.write(sb.toString());
                ++hi;
            }
            ++seg;
        }
        ((Writer)writer).close();
    }

    static void createUnicodePDF(String format, Locale locale, String fileName) throws Exception {
        FontMappingManager manager = FontMappingManagerFactory.getInstance().getFontMappingManager(format, locale);
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
        document.open();
        int seg = 0;
        while (seg < 255) {
            PdfContentByte cb = writer.getDirectContent();
            cb.beginText();
            int hi = 0;
            while (hi < 16) {
                int lo = 0;
                while (lo < 16) {
                    int x = 100 + hi * 32;
                    int y = 100 + lo * 32;
                    char ch = (char)(seg * 255 + hi * 16 + lo);
                    String fontFamily = manager.getDefaultPhysicalFont(ch);
                    BaseFont bf = manager.createFont(fontFamily, 0);
                    cb.setFontAndSize(bf, 16.0f);
                    cb.setTextMatrix((float)x, (float)y);
                    cb.showText(new String(new char[]{ch}));
                    ++lo;
                }
                ++hi;
            }
            cb.endText();
            ++seg;
        }
        document.close();
    }

    static void createFontIndex(String fontName, String encoding, Writer writer) throws Exception {
        BaseFont font = BaseFont.createFont((String)fontName, (String)encoding, (boolean)false);
        ArrayList<CharSegment> charSegs = new ArrayList<CharSegment>();
        int start = 0;
        int end = 0;
        int ch = 0;
        while (ch < 65535) {
            if (font.charExists((char)ch)) {
                if (start == -1) {
                    start = ch;
                }
                end = ch;
            } else if (start != -1) {
                charSegs.add(new CharSegment(start, end, fontName));
                start = -1;
            }
            ch = (char)(ch + 1);
        }
        if (start != -1) {
            charSegs.add(new CharSegment(start, end, fontName));
        }
        int i = 0;
        while (i < charSegs.size()) {
            StringBuffer sb = new StringBuffer();
            sb.append("<block region-start=\"").append(start).append("\" region-end=\"").append(end).append("\"/>").append('\n');
            writer.write(sb.toString());
            ++i;
        }
    }
}

