/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class Chunk {
    private String text;
    private int offset;
    private FontInfo fontInfo;
    private int baseLevel;
    private int runLevel;
    public static final Chunk HARD_LINE_BREAK = new Chunk("\n");

    public Chunk(String text) {
        this(text, 0, 0, 0, null);
    }

    public Chunk(String text, int offset, FontInfo fi) {
        this(text, offset, 0, 0, fi);
    }

    public Chunk(Chunk chunk) {
        this(chunk.text, chunk.offset, chunk.baseLevel, chunk.runLevel, null);
    }

    public Chunk(String text, int offset, int baseLevel, int runLevel) {
        this(text, offset, baseLevel, runLevel, null);
    }

    public Chunk(String text, int offset, int baseLevel, int runLevel, FontInfo fi) {
        this.text = text;
        this.offset = offset;
        this.fontInfo = null;
        this.baseLevel = baseLevel;
        this.runLevel = runLevel;
        this.fontInfo = fi;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public int getLength() {
        if (this.text != null) {
            return this.text.length();
        }
        return 0;
    }

    public void setFontInfo(FontInfo fi) {
        this.fontInfo = fi;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setBaseLevel(int baseLevel) {
        this.baseLevel = baseLevel;
    }

    public int getBaseLevel() {
        return this.baseLevel;
    }

    public void setRunLevel(int runLevel) {
        this.runLevel = runLevel;
    }

    public int getRunLevel() {
        return this.runLevel;
    }
}

