/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.URIValue;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSValue;

public class HTMLStyleProcessor {
    private static Logger logger = Logger.getLogger(HTMLStyleProcessor.class.getName());
    private ReportDesignHandle report;
    private CSSEngine cssEngine = new BIRTCSSEngine();
    private static String[] FONT_SIZE = new String[]{"7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "7.5pt", "10pt", "7.5pt", "7.5pt", "10pt", "12pt", "13.8pt", "18pt", "23pt", "36pt"};

    public HTMLStyleProcessor(ReportDesignHandle report) {
        this.report = report;
    }

    public void execute(Element ele, HashMap styles) {
        String bgi;
        CSSValue value;
        StyleDeclaration style = null;
        StringBuffer strStyle = new StringBuffer();
        if ("b".equals(ele.getTagName())) {
            this.appendStyle(strStyle, "font-weight", "bold");
            ele = this.replaceElement(ele, "span");
        } else if ("center".equals(ele.getTagName())) {
            this.appendStyle(strStyle, "text-align", "center");
            ele = this.replaceElement(ele, "div");
        } else if ("font".equals(ele.getTagName())) {
            this.appendStyle(strStyle, "color", ele.getAttribute("color"));
            this.appendStyle(strStyle, "font-family", ele.getAttribute("face"));
            if (ele.hasAttribute("size")) {
                try {
                    int size = Integer.parseInt(ele.getAttribute("size"));
                    this.appendStyle(strStyle, "font-size", FONT_SIZE[size + 7]);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "There is a invalid value for property SIZE of element FONT in the HTML.");
                }
            }
            ele.removeAttribute("color");
            ele.removeAttribute("face");
            ele.removeAttribute("size");
            ele = this.replaceElement(ele, "span");
        }
        try {
            String inlineStyle = ele.getAttribute("style");
            if (inlineStyle != null && !"".equals(inlineStyle)) {
                strStyle.append(inlineStyle);
            }
            if (strStyle.length() > 0) {
                style = (StyleDeclaration)this.cssEngine.parseStyleDeclaration(strStyle.toString());
                styles.put(ele, style);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "The css statement is:" + ele.getAttribute("style"), e);
        }
        ele.removeAttribute("style");
        if (style != null && (value = style.getProperty(37)) != null && value instanceof URIValue && (bgi = ((URIValue)value).getStringValue()) != null && !"".equals(bgi)) {
            if (this.report != null) {
                if (FileUtil.isLocalResource(bgi)) {
                    String fileName;
                    URL url = this.report.findResource(bgi, 1);
                    if (url != null && (fileName = url.getFile()) != null) {
                        bgi = fileName;
                    }
                } else {
                    bgi = "url(" + bgi + ")";
                }
            }
            if (bgi != null) {
                style.setBackgroundImage(bgi);
            } else {
                style.removeProperty("background-image");
            }
        }
        if (style != null) {
            styles.put(ele, style);
        }
        int i = 0;
        while (i < ele.getChildNodes().getLength()) {
            Node child = ele.getChildNodes().item(i);
            if (child.getNodeType() == 1) {
                this.execute((Element)child, styles);
            }
            ++i;
        }
    }

    private Element replaceElement(Element oldEle, String tag) {
        Element newEle = oldEle.getOwnerDocument().createElement(tag);
        int i = 0;
        while (i < oldEle.getAttributes().getLength()) {
            String attrName = oldEle.getAttributes().item(i).getNodeName();
            newEle.setAttribute(attrName, oldEle.getAttribute(attrName));
            ++i;
        }
        Node child = oldEle.getFirstChild();
        while (child != null) {
            newEle.appendChild(child);
            child = oldEle.getFirstChild();
        }
        oldEle.getParentNode().replaceChild(newEle, oldEle);
        return newEle;
    }

    private void appendStyle(StringBuffer style, String name, String value) {
        if (name == null || "".equals(name) || value == null || "".equals(value)) {
            return;
        }
        style.append(String.valueOf(name) + ":" + value + ";");
    }
}

