/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataSetEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetRow;
import org.eclipse.birt.report.engine.script.internal.DtEScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptTextUtil;
import org.eclipse.birt.report.engine.script.internal.instance.DataSetInstance;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.mozilla.javascript.Scriptable;

public class DataSetScriptExecutor
extends DtEScriptExecutor
implements IBaseDataSetEventHandler {
    private static final String ON_FETCH = "onFetch";
    protected DataSetHandle dataSetHandle;
    protected IDataSetEventHandler eventHandler;
    private boolean useOnFetchEventHandler = false;
    private boolean useAfterCloseEventHandler = false;
    private boolean useAfterOpenEventHandler = false;
    private boolean useBeforeOpenEventHandler = false;
    private boolean useBeforeCloseEventHandler = false;

    public DataSetScriptExecutor(DataSetHandle dataSetHandle, ExecutionContext context) {
        super(context);
        this.dataSetHandle = dataSetHandle;
        String className = dataSetHandle.getEventHandlerClass();
        this.initEventHandler(className);
        this.useOnFetchEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getOnFetch());
        this.useAfterCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getAfterClose());
        this.useAfterOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getAfterOpen());
        this.useBeforeOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getBeforeOpen());
        this.useBeforeCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getBeforeClose());
    }

    protected void initEventHandler(String className) {
        if (className != null) {
            try {
                this.eventHandler = (IDataSetEventHandler)DataSetScriptExecutor.getInstance(className, this.context);
            }
            catch (ClassCastException e) {
                DataSetScriptExecutor.addClassCastException(this.context, e, (DesignElementHandle)this.dataSetHandle, IScriptedDataSetEventHandler.class);
            }
            catch (EngineException e) {
                DataSetScriptExecutor.addException(this.context, (Exception)((Object)e), (DesignElementHandle)this.dataSetHandle);
            }
        }
    }

    public void handleBeforeOpen(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status;
            if (!this.useBeforeOpenEventHandler && (status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), "beforeOpen", this.dataSetHandle.getBeforeOpen())).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeOpen(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleBeforeClose(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status;
            if (!this.useBeforeCloseEventHandler && (status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), "beforeClose", this.dataSetHandle.getBeforeClose())).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeClose(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterOpen(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status;
            if (!this.useAfterOpenEventHandler && (status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), "afterOpen", this.dataSetHandle.getAfterOpen())).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterOpen(new DataSetInstance(dataSet), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterClose(IDataSetInstanceHandle dataSet) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status;
            if (!this.useAfterCloseEventHandler && (status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), "afterClose", this.dataSetHandle.getAfterClose())).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterClose(this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleOnFetch(IDataSetInstanceHandle dataSet, IDataRow row) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status;
            if (!this.useOnFetchEventHandler && (status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), ON_FETCH, this.dataSetHandle.getOnFetch())).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.onFetch(new DataSetInstance(dataSet), new DataSetRow(row), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSetScriptExecutor.addException(this.context, e);
        }
    }

    protected ScriptExecutor.JSScriptStatus handleJS(Scriptable scope, String name, String method, String script) {
        return this.handleJS(scope, "DataSet", name, method, script);
    }
}

