/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.script.JSMethodRunner;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.mozilla.javascript.Scriptable;

public abstract class DtEScriptExecutor
extends ScriptExecutor {
    protected static final String DATA_SET = "DataSet";
    protected static final String DATA_SOURCE = "DataSource";
    protected static final String BEFORE_OPEN = "beforeOpen";
    protected static final String BEFORE_CLOSE = "beforeClose";
    protected static final String AFTER_OPEN = "afterOpen";
    protected static final String AFTER_CLOSE = "afterClose";
    protected ExecutionContext context;
    protected IReportContext reportContext;
    private JSMethodRunner runner;

    public DtEScriptExecutor(ExecutionContext context) {
        this.context = context;
        this.reportContext = context != null ? context.getReportContext() : null;
    }

    protected JSMethodRunner getRunner(Scriptable scope, String type, String name) {
        String scopeName = String.valueOf(type) + "[" + name + "]";
        this.runner = new JSMethodRunner(this.context.getScriptContext(), scope, scopeName);
        return this.runner;
    }

    protected ScriptExecutor.JSScriptStatus handleJS(Scriptable scope, String type, String name, String method, String script) {
        Object result;
        block4: {
            if (script == null || type == null || name == null || method == null) {
                return ScriptExecutor.JSScriptStatus.NO_RUN;
            }
            if (!DATA_SET.equals(type) && !DATA_SOURCE.equals(type)) {
                return ScriptExecutor.JSScriptStatus.NO_RUN;
            }
            result = null;
            try {
                JSMethodRunner jsr = this.getRunner(scope, type, name);
                result = jsr.runScript(method, script);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (this.context == null) break block4;
                this.context.addException(new EngineException("Error.ScriptEvaluationError", script, (Throwable)e));
            }
        }
        return new ScriptExecutor.JSScriptStatus(true, result);
    }

    protected abstract ScriptExecutor.JSScriptStatus handleJS(Scriptable var1, String var2, String var3, String var4);
}

