/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ScriptExecutor {
    public static final String PROPERTYSEPARATOR = EngineConstants.PROPERTYSEPARATOR;
    public static final String WEBAPP_CLASSPATH_KEY = "webapplication.projectclasspath";
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    public static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";
    protected static Logger log = Logger.getLogger(ScriptExecutor.class.getName());

    protected static JSScriptStatus handleJS(Object scope, ScriptExpression expr, ExecutionContext context) throws BirtException {
        return ScriptExecutor.handleJSInternal(scope, expr, context);
    }

    private static JSScriptStatus handleJSInternal(Object scope, ScriptExpression expr, ExecutionContext context) throws BirtException {
        if (expr != null) {
            try {
                if (scope != null) {
                    context.newScope(scope);
                }
                Object result = null;
                result = context.evaluate(expr);
                JSScriptStatus jSScriptStatus = new JSScriptStatus(true, result);
                return jSScriptStatus;
            }
            finally {
                if (scope != null) {
                    context.exitScope();
                }
            }
        }
        return JSScriptStatus.NO_RUN;
    }

    protected static boolean needOnCreate(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnCreate() != null || design.getJavaClass() != null;
    }

    protected static boolean needOnRender(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnRender() != null || design.getJavaClass() != null;
    }

    protected static boolean needOnPageBreak(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnPageBreak() != null || design.getJavaClass() != null;
    }

    protected static Object getInstance(DesignElementHandle element, ExecutionContext context) throws EngineException {
        if (element == null) {
            return null;
        }
        String className = element.getEventHandlerClass();
        return ScriptExecutor.getInstance(className, context);
    }

    protected static Object getInstance(ReportItemDesign element, ExecutionContext context) throws EngineException {
        if (element == null) {
            return null;
        }
        String className = element.getJavaClass();
        return ScriptExecutor.getInstance(className, context);
    }

    protected static Object getInstance(String className, ExecutionContext context) throws EngineException {
        if (className == null) {
            return null;
        }
        Object o = null;
        Class<?> c = null;
        try {
            ClassLoader classLoader = context.getApplicationClassLoader();
            c = classLoader.loadClass(className);
            o = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new EngineException("Error.ScriptClassNotFoundError", new Object[]{className}, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new EngineException("Error.ScriptClassIllegalAccessError", new Object[]{className}, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new EngineException("Error.ScriptClassInstantiationError", new Object[]{className}, (Throwable)e);
        }
        return o;
    }

    protected static void addClassCastException(ExecutionContext context, Exception e, DesignElementHandle handle, Class requiredInterface) {
        ScriptExecutor.addException(context, e, handle, "Error.ScriptClassCastError", new Object[]{handle.getEventHandlerClass(), requiredInterface.getName()});
    }

    protected static void addException(ExecutionContext context, Exception e) {
        ScriptExecutor.addException(context, e, "Error.UnhandledScriptError", null);
    }

    protected static void addException(ExecutionContext context, Exception e, DesignElementHandle handle) {
        ScriptExecutor.addException(context, e, handle, "Error.UnhandledScriptError", null);
    }

    private static void addException(ExecutionContext context, Exception e, String errorType, Object[] args) {
        log.log(Level.WARNING, e.getMessage(), e);
        if (context == null) {
            return;
        }
        if (args == null) {
            context.addException(new EngineException(errorType, e));
        } else {
            context.addException(new EngineException(errorType, args, (Throwable)e));
        }
    }

    private static void addException(ExecutionContext context, Exception e, DesignElementHandle handle, String errorType, Object[] args) {
        log.log(Level.WARNING, e.getMessage(), e);
        if (context == null) {
            return;
        }
        if (args == null) {
            context.addException(handle, (BirtException)new EngineException(errorType, e));
        } else {
            context.addException(handle, (BirtException)new EngineException(errorType, args, (Throwable)e));
        }
    }

    protected static class JSScriptStatus {
        private boolean didRun;
        private Object result;
        public static final JSScriptStatus NO_RUN = new JSScriptStatus(false, null);

        public JSScriptStatus(boolean didRun, Object result) {
            this.didRun = didRun;
            this.result = result;
        }

        public boolean didRun() {
            return this.didRun;
        }

        public Object result() {
            return this.result;
        }
    }
}

