/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import com.ibm.icu.util.ULocale;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.util.DeviceUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.InteractiveRenderer;

public final class SwingEventHandler
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");
    private Action acTooltip = null;
    private ShapedAction saHighlighted = null;
    private final Map lhmAllTriggers;
    private final IUpdateNotifier iun;
    private final ULocale lcl;
    private InteractiveRenderer iv = null;
    private StructureSource srcHighlight;
    private StructureSource srcToggleDataPoint;
    private StructureSource srcToggleVisibility;

    SwingEventHandler(InteractiveRenderer iv, Map _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
        this.iv = iv;
    }

    private final boolean isLeftButton(MouseEvent e) {
        return (e.getButton() & 1) == 1;
    }

    private final ShapedAction getShapedActionForConditionPoint(TriggerCondition[] tca, Point p) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        int i = 0;
        while (i < tca.length) {
            List tal = (List)this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                int j = tal.size() - 1;
                while (j >= 0) {
                    ShapedAction sa = (ShapedAction)tal.get(j);
                    if (p == null || sa.getShape().contains(p)) {
                        return sa;
                    }
                    --j;
                }
            }
            ++i;
        }
        return null;
    }

    private void handleAction(TriggerCondition[] tg, ComponentEvent event) {
        this.handleAction(tg, event, true);
    }

    private synchronized void handleAction(TriggerCondition[] tg, ComponentEvent event, boolean cleanState) {
        if (tg == null || event == null) {
            return;
        }
        Point p = null;
        if (event instanceof MouseEvent) {
            p = ((MouseEvent)event).getPoint();
        }
        boolean cfr_ignored_0 = event instanceof KeyEvent;
        ShapedAction sa = this.getShapedActionForConditionPoint(tg, p);
        if (sa == null) {
            int i = 0;
            while (i < tg.length) {
                if (this.lhmAllTriggers.get(tg[i]) != null) {
                    this.disableActions(this.getActionTypesForConditions(tg));
                }
                ++i;
            }
            return;
        }
        StructureSource src = sa.getSource();
        Action ac = null;
        int i = 0;
        while (i < tg.length) {
            ac = sa.getActionForCondition(tg[i]);
            if (ac != null) break;
            ++i;
        }
        if (ac == null) {
            return;
        }
        switch (ac.getType().getValue()) {
            case 0: {
                URLValue uv = (URLValue)ac.getValue();
                logger.log(1, String.valueOf(Messages.getString("SwingEventHandler.info.redirect.url", this.lcl)) + uv.getBaseUrl());
                DeviceUtil.openURL(uv.getBaseUrl());
                break;
            }
            case 1: {
                if (ac != this.acTooltip) {
                    this.hideTooltip();
                }
                this.acTooltip = ac;
                this.showTooltip(ac);
                break;
            }
            case 2: {
                this.srcToggleVisibility = this.handleGraphicAction(src, this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL, cleanState);
                break;
            }
            case 6: {
                this.srcToggleDataPoint = this.handleGraphicAction(src, this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, cleanState);
                break;
            }
            case 4: {
                this.srcHighlight = this.handleGraphicAction(src, this.srcHighlight, ActionType.HIGHLIGHT_LITERAL, cleanState);
                break;
            }
            case 5: {
                if (this.iun instanceof ICallBackNotifier) {
                    CallBackValue cv = (CallBackValue)ac.getValue();
                    ((ICallBackNotifier)this.iun).callback((Object)event, (Object)sa.getSource(), cv);
                    break;
                }
                logger.log(2, Messages.getString("SwingEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
            }
        }
    }

    private void disableActions(Set actions) {
        if (actions == null) {
            return;
        }
        for (ActionType action : actions) {
            if (action == null) continue;
            switch (action.getValue()) {
                case 1: {
                    if (this.acTooltip == null) break;
                    this.hideTooltip();
                    this.acTooltip = null;
                    break;
                }
                case 4: {
                    if (this.srcHighlight == null) break;
                    this.iv.unregisterAction(this.srcHighlight, ActionType.HIGHLIGHT_LITERAL);
                    this.srcHighlight = null;
                    this.iun.repaintChart();
                    break;
                }
                case 6: {
                    if (this.srcToggleDataPoint == null) break;
                    this.iv.unregisterAction(this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL);
                    this.srcToggleDataPoint = null;
                    this.iun.repaintChart();
                    break;
                }
                case 2: {
                    if (this.srcToggleVisibility == null) break;
                    this.iv.unregisterAction(this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL);
                    this.srcToggleVisibility = null;
                    this.iun.repaintChart();
                }
            }
        }
    }

    private StructureSource handleGraphicAction(StructureSource src, StructureSource previousSrc, ActionType actionType, boolean cleanState) {
        if (previousSrc == null) {
            previousSrc = src;
            this.iv.registerAction(src, actionType);
            this.iun.repaintChart();
        } else if (!this.iv.getSource(src).equals(this.iv.getSource(previousSrc))) {
            if (actionType == ActionType.HIGHLIGHT_LITERAL) {
                this.iv.unregisterAction(previousSrc, actionType);
                previousSrc = src;
                this.iv.registerAction(src, actionType);
            } else {
                previousSrc = src;
                if (this.iv.isRegisteredAction(src, actionType)) {
                    this.iv.unregisterAction(src, actionType);
                } else {
                    this.iv.registerAction(src, actionType);
                }
            }
            this.iun.repaintChart();
        } else if (cleanState) {
            this.iv.unregisterAction(previousSrc, actionType);
            previousSrc = null;
            this.iun.repaintChart();
        }
        return previousSrc;
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL}, e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEOUT_LITERAL}, e);
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL}, e);
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEUP_LITERAL}, e);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        ShapedAction sa = this.getShapedActionForConditionPoint(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL}, p);
        if (sa != null) {
            ((JComponent)this.iun.peerInstance()).setCursor(Cursor.getPredefinedCursor(12));
        } else {
            ((JComponent)this.iun.peerInstance()).setCursor(Cursor.getDefaultCursor());
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_HOVER_LITERAL, TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL}, e, false);
    }

    public void focusGained(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONFOCUS_LITERAL}, e);
    }

    public void focusLost(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONBLUR_LITERAL}, e);
    }

    public void keyPressed(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL}, e);
    }

    public void keyReleased(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL}, e);
    }

    public void keyTyped(KeyEvent e) {
    }

    private final void hideTooltip() {
        ((JComponent)this.iun.peerInstance()).setToolTipText(null);
    }

    private final void showTooltip(Action ac) {
        TooltipValue tv = (TooltipValue)ac.getValue();
        String tooltip = tv.getText().replaceAll("\\\n", "<br>");
        tooltip = !tooltip.equals(tv.getText()) ? "<html>" + tooltip + "</html>" : tv.getText();
        ((JComponent)this.iun.peerInstance()).setToolTipText(tooltip);
    }

    protected Set getActionTypesForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        HashSet<ActionType> set = new HashSet<ActionType>();
        int i = 0;
        while (i < tca.length) {
            List tal = (List)this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                for (ShapedAction sa : tal) {
                    ActionType actionType = sa.getActionForCondition(tca[i]).getType();
                    set.add(actionType);
                }
            }
            ++i;
        }
        return set;
    }
}

