/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.TextAdapter;
import org.eclipse.birt.chart.device.util.ChartTextLayout;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;

public final class ChartTextMetrics
extends TextAdapter {
    private int iLineCount = 0;
    private Object oText = null;
    private Graphics2D g2d = null;
    private FontMetrics fm = null;
    private ChartTextLayout[] tla = null;
    private String[] fsa = null;
    private transient Object bi = null;
    private Label la = null;
    private final IDisplayServer xs;
    private Insets ins = null;

    public ChartTextMetrics(IDisplayServer _xs, Label _la) {
        if (this.bi == null) {
            this.bi = new BufferedImage(1, 1, 1);
            this.g2d = (Graphics2D)((BufferedImage)this.bi).getGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.g2d = (Graphics2D)((BufferedImage)this.bi).getGraphics();
        }
        this.xs = _xs;
        this.la = _la;
        this.computeTextAntialiasing();
        this.reuse(this.la);
    }

    private void computeTextAntialiasing() {
        FontDefinition font = this.la.getCaption().getFont();
        if (font.isBold() || font.getRotation() % 90.0 != 0.0 || font.getSize() > 13.0f) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public final void reuse(Label la, double forceWrappingSize) {
        String[] sa;
        Font f = (Font)this.xs.createFont(la.getCaption().getFont());
        this.fm = this.g2d.getFontMetrics(f);
        FontRenderContext frc = this.g2d.getFontRenderContext();
        String s = la.getCaption().getValue();
        s = s == null ? IConstants.NULL_STRING : s.trim();
        if (s.length() == 0) {
            s = " ";
        }
        if ((sa = this.splitOnBreaks(s, forceWrappingSize)) == null) {
            this.iLineCount = 1;
            this.oText = s;
            this.tla = new ChartTextLayout[1];
            this.fsa = new String[1];
            this.tla[0] = new ChartTextLayout(s, f.getAttributes(), frc);
            this.fsa[0] = s;
        } else {
            this.iLineCount = sa.length;
            this.oText = sa;
            this.tla = new ChartTextLayout[this.iLineCount];
            this.fsa = new String[this.iLineCount];
            int i = 0;
            while (i < this.iLineCount) {
                this.tla[i] = new ChartTextLayout(sa[i], f.getAttributes(), frc);
                this.fsa[i] = sa[i];
                ++i;
            }
        }
        this.ins = la.getInsets().scaledInstance(this.pointsToPixels());
        if (forceWrappingSize > 0.0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.fsa.length) {
                sb.append(this.fsa[i]).append("\n");
                ++i;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            la.getCaption().setValue(sb.toString());
        }
    }

    public final double getHeight() {
        return this.fm.getHeight();
    }

    public final double getDescent() {
        return this.fm.getDescent();
    }

    private final double stringWidth() {
        if (this.iLineCount > 1) {
            double dMaxWidth = 0.0;
            int i = 0;
            while (i < this.iLineCount) {
                Rectangle2D r2d = this.fm.getStringBounds(this.fsa[0], this.g2d);
                double dWidth = r2d.getWidth();
                if (dWidth > dMaxWidth) {
                    dMaxWidth = dWidth;
                }
                ++i;
            }
            return Math.max(0.0, dMaxWidth);
        }
        if (this.iLineCount == 1) {
            double w = this.fm.getStringBounds(this.fsa[0], this.g2d).getWidth();
            return Math.max(0.0, w);
        }
        return 0.0;
    }

    final double pointsToPixels() {
        return (double)this.xs.getDpiResolution() / 72.0;
    }

    public final double getFullHeight() {
        return this.getHeight() * (double)this.getLineCount() + (this.ins.getTop() + this.ins.getBottom());
    }

    public final double getFullHeight(double fontHeight) {
        return fontHeight * (double)this.getLineCount() + this.ins.getTop() + this.ins.getBottom();
    }

    public final double getFullWidth() {
        return this.stringWidth() + (this.ins.getLeft() + this.ins.getRight());
    }

    public final int getLineCount() {
        return this.iLineCount;
    }

    public final String getLine(int iIndex) {
        return this.iLineCount > 1 ? ((String[])this.oText)[iIndex] : (String)this.oText;
    }

    public final ChartTextLayout getLayout(int iIndex) {
        return this.iLineCount > 1 ? this.tla[iIndex] : this.tla[0];
    }

    private String[] splitOnBreaks(String s, double maxSize) {
        int n;
        int j;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j)) != null && ss.length() > 0) {
                al.add(ss);
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        if (maxSize > 0.0) {
            ArrayList<String> nal = new ArrayList<String>();
            for (String ns : al) {
                AttributedString as = new AttributedString(ns, this.fm.getFont().getAttributes());
                LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), this.g2d.getFontRenderContext());
                while (lbm.getPosition() < ns.length()) {
                    int next = lbm.nextOffset((float)maxSize);
                    String ss = ns.substring(lbm.getPosition(), next);
                    lbm.setPosition(next);
                    nal.add(ss);
                }
            }
            al = nal;
        }
        if ((n = al.size()) == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        i = 0;
        while (i < al.size()) {
            sa[i] = (String)al.get(i);
            ++i;
        }
        return sa;
    }

    public void dispose() {
        if (this.bi != null) {
            ((BufferedImage)this.bi).flush();
            this.bi = null;
            this.g2d.dispose();
            this.g2d = null;
        }
    }
}

