/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.text.SimpleDateFormat;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.emitter.excel.GroupInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class ExcelUtil {
    protected static Logger log = Logger.getLogger(ExcelUtil.class.getName());
    protected static BigDecimal MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    protected static BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate().subtract(BigDecimal.ONE);
    protected static BigDecimal MAX_POSITIVE_DECIMAL_NUMBER = new BigDecimal(1.0E16).subtract(new BigDecimal("0.0000000000000001"));
    protected static BigDecimal MIN_POSITIVE_DECIMAL_NUMBER = new BigDecimal("0.000000000000001");
    protected static BigDecimal MIN_NEGATIVE_DECIMAL_NUMBER = new BigDecimal(-1.0E15).add(new BigDecimal("0.000000000000001"));
    protected static BigDecimal MAX_NEGATIVE_DECIMAL_NUMBER = MIN_POSITIVE_DECIMAL_NUMBER.negate();
    private static String validStr = "#.0<>()%_";
    private static String specialStr = "mMdDyYhHsSeEbBgGnN/*\"@";
    private static String currencySymbol = "\u00a3\u00a2\u20ac\uffe5\u00a5";
    private static String invalidBookmarkChars = "`~!@#$%^&*()-=+\\|[]{};:'\",./?>< \t\n\r\uff01\uffe5\uff08\uff09\uff1a\uff1b\uff0c";
    private static final int max_formula_length = 512;
    private static final String reg1 = "Total.(count|ave|sum|max|min)\\(";
    private static final String reg2 = "\\)";
    private static final String reg3 = "\\[";
    private static final String reg4 = "\\]";

    public static String ridQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static boolean isValidBookmarkName(String name) {
        if (name.equalsIgnoreCase("r")) {
            return false;
        }
        if (name.equalsIgnoreCase("c")) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (invalidBookmarkChars.indexOf(name.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        if (name.matches("[0-9].*")) {
            return false;
        }
        if (name.matches("([A-Za-z]|[A-Ha-h][A-Za-z]|[Ii][A-Va-v])[0-9]{1,5}")) {
            String[] strs = name.split("[A-Za-z]");
            if (strs.length > 0) {
                int rowId = 0;
                try {
                    rowId = Integer.parseInt(strs[strs.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
                return rowId > 65536;
            }
            return true;
        }
        return true;
    }

    public static String formatDate(Object data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        java.util.Date date = ExcelUtil.getDate(data);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static java.util.Date getDate(Object data) {
        java.util.Date date = null;
        date = data instanceof com.ibm.icu.util.Calendar ? ((com.ibm.icu.util.Calendar)data).getTime() : (data instanceof java.util.Date ? (java.util.Date)data : null);
        return date;
    }

    public static String formatNumberAsDecimal(Object data) {
        Number number = (Number)data;
        DecimalFormat numberFormat = new DecimalFormat("0.##############");
        numberFormat.setMaximumFractionDigits(15);
        return numberFormat.format(number);
    }

    /*
     * Unable to fully structure code
     */
    public static String formatNumberAsScienceNotation(Number data) {
        block5: {
            if (!ExcelUtil.$assertionsDisabled && !(data instanceof BigDecimal)) {
                throw new AssertionError();
            }
            bigDecimal = (BigDecimal)data;
            scale = 0;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                return "0";
            }
            prefix = "";
            if (bigDecimal.compareTo(BigDecimal.ZERO) == -1) {
                prefix = "-";
                bigDecimal = bigDecimal.negate();
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) != -1) ** GOTO lbl19
            while (bigDecimal.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal = bigDecimal.movePointRight(1);
                --scale;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                bigDecimal = bigDecimal.movePointLeft(1);
                ++scale;
lbl19:
                // 2 sources

                ** while (bigDecimal.compareTo((BigDecimal)BigDecimal.TEN) == 1)
            }
        }
        decimalFormat = new DecimalFormat("0.##############");
        number = decimalFormat.format(bigDecimal);
        sign = scale >= 0 ? "+" : "";
        return String.valueOf(prefix) + number + "E" + sign + scale;
    }

    public static String getType(Object val) {
        if (val instanceof Number) {
            return "NUMBER";
        }
        if (val instanceof java.util.Date) {
            return "DATE";
        }
        if (val instanceof Calendar) {
            return "CALENDAR";
        }
        return "STRING";
    }

    private static String replaceDateFormat(String pattern) {
        if (pattern == null) {
            String rg = "";
            return rg;
        }
        StringBuffer toAppendTo = new StringBuffer();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
                count = 0;
            }
            if (ch == '/') {
                toAppendTo.append('\\');
                toAppendTo.append(ch);
            } else if (ch == '\'') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append("\"");
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote) {
                prevCh = ch;
                ++count;
            } else {
                toAppendTo.append(ch);
            }
            ++i;
        }
        if (count > 0) {
            toAppendTo.append(ExcelUtil.subReplaceDateFormat(prevCh, count));
        }
        return toAppendTo.toString();
    }

    private static String subReplaceDateFormat(char ch, int count) {
        String current = "";
        int patternCharIndex = -1;
        String datePatternChars = "GyMdkHmsSEDFwWahKz";
        patternCharIndex = datePatternChars.indexOf(ch);
        if (patternCharIndex == -1) {
            int i = 0;
            while (i < count) {
                current = String.valueOf(current) + ch;
                ++i;
            }
            return current;
        }
        switch (patternCharIndex) {
            case 0: {
                current = "";
                break;
            }
            case 1: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 4: {
                current = "h";
                break;
            }
            case 5: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + "a";
                    ++i;
                }
                break;
            }
            case 14: {
                current = "AM/PM";
                break;
            }
            case 15: {
                int i = 0;
                while (i < count) {
                    current = String.valueOf(current) + ch;
                    ++i;
                }
                break;
            }
            case 17: {
                current = "";
                break;
            }
            default: {
                current = "";
            }
        }
        return current;
    }

    public static String getPattern(Object data, String val) {
        if (val != null && data instanceof java.util.Date) {
            return ExcelUtil.replaceDateFormat(val);
        }
        if (val == null && data instanceof Time) {
            return "Long Time";
        }
        if (val == null && data instanceof Date) {
            return "mmm d, yyyy";
        }
        if (val == null && data instanceof java.util.Date) {
            return "mmm d, yyyy h:mm AM/PM";
        }
        if (val != null && data instanceof Number) {
            if (val.indexOf("E") >= 0) {
                return "Scientific";
            }
            return new NumberFormatter(val).getPattern();
        }
        if (val != null && data instanceof String) {
            return new StringFormatter(val).getPattern();
        }
        return null;
    }

    public static String replaceAll(String str, String old, String news) {
        if (str == null) {
            return str;
        }
        int begin = 0;
        int idx = 0;
        int len = old.length();
        StringBuffer buf = new StringBuffer();
        while ((idx = str.indexOf(old, begin)) >= 0) {
            buf.append(str.substring(begin, idx));
            buf.append(news);
            begin = idx + len;
        }
        return new String(buf.append(str.substring(begin)));
    }

    public static String getValue(String val) {
        if (val == null) {
            return "NULL";
        }
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int convertToPt(String size) {
        try {
            int s = Integer.valueOf(size.substring(0, size.length() - 2));
            if (size.endsWith("in")) {
                return s * 72;
            }
            if (size.endsWith("cm")) {
                return (int)((double)s / 2.54 * 72.0);
            }
            if (size.endsWith("mm")) {
                return (int)((double)(s * 10) / 2.54 * 72.0);
            }
            if (size.endsWith("pc")) {
                return s;
            }
            return s;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "unknown size: " + size);
            return 0;
        }
    }

    public static boolean isBigNumber(Object number) {
        try {
            BigDecimal num = ExcelUtil.getBigDecimal(number);
            return num.compareTo(MAX_DOUBLE) == 1 || num.compareTo(MIN_DOUBLE) == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static BigDecimal getBigDecimal(Object number) {
        BigDecimal num = null;
        num = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        return num;
    }

    public static boolean displayedAsScientific(Object number) {
        BigDecimal num = ExcelUtil.getBigDecimal(number);
        if (num.compareTo(MAX_POSITIVE_DECIMAL_NUMBER) <= 0 && num.compareTo(MIN_POSITIVE_DECIMAL_NUMBER) >= 0) {
            return false;
        }
        return num.compareTo(MAX_NEGATIVE_DECIMAL_NUMBER) > 0 || num.compareTo(MIN_NEGATIVE_DECIMAL_NUMBER) < 0;
    }

    public static boolean isInfinity(Object number) {
        try {
            return Double.isInfinite((Double)number);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getColumnOfExp(String exp) {
        return exp.substring(exp.indexOf("dataSetRow["), exp.lastIndexOf("]") + 1);
    }

    public static String createFormula(String txt, String exp, List positions) {
        exp = ExcelUtil.getFormulaName(exp);
        StringBuffer sb = new StringBuffer(String.valueOf(exp) + "(");
        int i = 0;
        while (i < positions.size()) {
            GroupInfo.Position p = (GroupInfo.Position)positions.get(i);
            sb.append("R" + p.row + "C" + p.column + ",");
            ++i;
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (sb.length() > 512 || positions.size() == 0) {
            return txt;
        }
        return sb.toString();
    }

    private static String getFormulaName(String expression) {
        if (expression.startsWith("Total.sum")) {
            return "=SUM";
        }
        if (expression.startsWith("Total.ave")) {
            return "=AVERAGE";
        }
        if (expression.startsWith("Total.max")) {
            return "=MAX";
        }
        if (expression.startsWith("Total.min")) {
            return "=MIN";
        }
        if (expression.startsWith("Total.count")) {
            return "=COUNT";
        }
        throw new RuntimeException("Cannot parse the expression" + expression);
    }

    public static boolean isValidExp(String exp, String[] columnNames) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columnNames.length) {
            sb.append(String.valueOf(columnNames[i]) + "|");
            ++i;
        }
        String columnRegExp = "(" + sb.substring(0, sb.length() - 1) + ")";
        columnRegExp = columnRegExp.replaceAll(reg3, "Z");
        columnRegExp = columnRegExp.replaceAll(reg4, "Z");
        String aggregateRegExp = reg1 + columnRegExp + reg2;
        exp = exp.replaceAll(reg3, "Z");
        exp = exp.replaceAll(reg4, "Z");
        Pattern p = Pattern.compile(aggregateRegExp);
        Matcher m = p.matcher(exp);
        boolean agg = m.matches();
        p = Pattern.compile(columnRegExp);
        m = p.matcher(exp);
        return agg || m.matches();
    }

    public static String expression(String val, String target, String[] res, boolean casesenstive) {
        boolean flag = casesenstive ? target.equals(val) : target.equalsIgnoreCase(val);
        return flag ? res[1] : res[0];
    }

    public static int covertDimensionType(DimensionType value, int parent) {
        if ("%".equals(value.getUnits())) {
            return (int)(value.getMeasure() / 100.0 * (double)parent);
        }
        return (int)value.convertTo("pt");
    }

    public static String parse(String dateTime, Locale locale) {
        if (dateTime == null) {
            return "";
        }
        if (dateTime.indexOf("Date") != -1 || dateTime.indexOf("Time") != -1) {
            DateFormatter dateFormatter = new DateFormatter(dateTime, locale);
            dateTime = dateFormatter.getLocalizedFormatCode();
        }
        StringBuffer buffer = new StringBuffer();
        boolean inQuto = false;
        int count = 0;
        while (count < dateTime.length()) {
            char tempChar = dateTime.charAt(count);
            if (inQuto) {
                if (tempChar == '\'' && ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else if (tempChar == '\'') {
                    inQuto = false;
                } else if (specialStr.indexOf(tempChar) != -1) {
                    buffer.append("\\" + tempChar);
                } else {
                    buffer.append(tempChar);
                }
            } else if (tempChar == '\'') {
                if (ExcelUtil.nextIsQuto(dateTime, count)) {
                    buffer.append(tempChar);
                    ++count;
                } else {
                    inQuto = true;
                }
            } else if (tempChar == 'a') {
                buffer.append("AM/PM");
            } else if ("zZFWwGE".indexOf(tempChar) == -1) {
                if ("kK".indexOf(tempChar) != -1) {
                    buffer.append("h");
                } else {
                    buffer.append(tempChar);
                }
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String formatNumberPattern(String givenValue) {
        return ExcelUtil.formatNumberPattern(givenValue, Locale.getDefault());
    }

    public static String formatNumberPattern(String givenValue, Locale locale) {
        String returnStr = "";
        if (givenValue == null) {
            return "";
        }
        if (givenValue.length() == 1) {
            char ch = givenValue.charAt(0);
            if (ch == 'G' || ch == 'g' || ch == 'd' || ch == 'D') {
                return "###,##0.###";
            }
            if (ch == 'C' || ch == 'c') {
                return String.valueOf(ExcelUtil.getCurrencySymbol(locale)) + "###,##0.00";
            }
            if (ch == 'f' || ch == 'F') {
                return "#0.00";
            }
            if (ch == 'N' || ch == 'n') {
                return "###,##0.00";
            }
            if (ch == 'p' || ch == 'P') {
                return "###,##0.00 %";
            }
            if (ch == 'e' || ch == 'E') {
                return "0.000000E00";
            }
            if (ch == 'x' || ch == 'X') {
                return "####";
            }
        }
        if (givenValue.equals("Fixed")) {
            return "Fixed";
        }
        if (givenValue.equals("Percent")) {
            return "Percent";
        }
        if (givenValue.equals("Scientific")) {
            return "Scientific";
        }
        if (givenValue.equals("Standard")) {
            return "Standard";
        }
        if (givenValue.equals("General Number")) {
            return "General";
        }
        if (ExcelUtil.validType(givenValue)) {
            return givenValue;
        }
        int count = givenValue.length();
        boolean flag = false;
        int num = 0;
        while (num < count) {
            char temp = givenValue.charAt(num);
            if (temp == '\'') {
                if (flag) {
                    flag = false;
                } else {
                    char nextChar = givenValue.charAt(num + 1);
                    if (nextChar == '\'') {
                        returnStr = String.valueOf(returnStr) + '\'';
                        ++num;
                        flag = false;
                    } else {
                        flag = true;
                    }
                }
            } else if (flag) {
                returnStr = String.valueOf(returnStr) + "\\" + temp;
            } else if (specialStr.indexOf(temp) != -1) {
                returnStr = String.valueOf(returnStr) + "\\" + temp;
            } else if (temp == '\u00a4') {
                String symbol = ExcelUtil.getCurrencySymbol(locale);
                returnStr = String.valueOf(returnStr) + "\"" + symbol + "\"";
            } else {
                returnStr = currencySymbol.indexOf(temp) != -1 ? String.valueOf(returnStr) + "\"" + temp + "\"" : String.valueOf(returnStr) + temp;
            }
            ++num;
        }
        if (returnStr.indexOf("#") == -1 && returnStr.indexOf("0") == -1) {
            returnStr = String.valueOf(returnStr) + "#";
        }
        return returnStr;
    }

    private static String getCurrencySymbol(Locale locale) {
        NumberFormat format = NumberFormat.getCurrencyInstance(locale);
        String symbol = format.getCurrency().getSymbol();
        if (symbol.equals("EUR")) {
            symbol = "\u20ac";
        }
        if (symbol.equals("GBP")) {
            symbol = "\u00a3";
        }
        if (symbol.equals("XXX")) {
            symbol = "\u00a4";
        }
        return symbol;
    }

    protected static boolean validType(String str) {
        int count = 0;
        while (count < str.length()) {
            char ch = str.charAt(count);
            if (validStr.indexOf(ch) == -1) {
                return false;
            }
            ++count;
        }
        return true;
    }

    private static boolean nextIsQuto(String forPar, int index) {
        if (forPar.length() - 1 == index) {
            return false;
        }
        return forPar.charAt(index + 1) == '\'';
    }
}

