/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.GroupElementCommand;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.OdaLevel;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.CompatiblePropertyChangeTables;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCommand
extends AbstractPropertyCommand {
    public PropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        this.checkAllowedOperation();
        propName = StringUtil.trimString(propName);
        ElementPropertyDefn prop = this.element.getPropertyDefn(propName);
        if (prop == null) {
            throw new PropertyNameException(this.element, propName);
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        Structure struct;
        this.checkAllowedOperation();
        if (prop.isElementType()) {
            this.setElementTypeProperty(prop, value);
            return;
        }
        String propName = prop.getName();
        if (("toc".equals(propName) || "toc".equals(propName)) && value instanceof String) {
            Structure oldValue = (Structure)this.element.getLocalProperty(this.module, prop);
            if (oldValue != null) {
                StructureContext ref = new StructureContext(oldValue, (PropertyDefn)oldValue.getDefn().getMember("expressionValue"), null);
                this.setMember(ref, value);
                return;
            }
            value = StructureFactory.createTOC((String)value);
        }
        if ("extensionName".equals(prop.getName()) && this.element instanceof IExtendedItemModel) {
            throw new PropertyValueException(this.element, "extensionName", value, "Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN");
        }
        String mask = this.element.getPropertyMask(this.module, prop.getName());
        if ("lock".equalsIgnoreCase(mask)) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.VALUE_LOCKED");
        }
        if (this.element.isVirtualElement() && this.element instanceof Cell && ("colSpan".equalsIgnoreCase(propName = prop.getName()) || "rowSpan".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName))) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN");
        }
        if (this.element instanceof MasterPage) {
            propName = prop.getName();
            if (!((MasterPage)this.element).isCustomType(this.module) && ("width".equals(propName) || "height".equals(propName))) {
                throw new SemanticError(this.element, "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
            }
        }
        if ((value = this.validateCompatibleObject(prop, value)) instanceof Structure && (struct = (Structure)value).getContext() != null) {
            value = struct.copy();
        }
        if (prop.getName().equalsIgnoreCase("internalDimensionRef")) {
            this.checkSharedDimensionReference(prop, value);
        }
        Object inputValue = value;
        if ((value = this.validateValue(prop, value)) instanceof ElementRefValue && prop.getTypeCode() == 15) {
            this.checkRecursiveElementReference(prop, (ElementRefValue)value);
            this.checkDataBindingReference(prop, (ElementRefValue)value);
            if (inputValue instanceof String) {
                this.checkSharedDimensionReference(prop, value);
            }
        }
        if (this.element instanceof GroupElement && "groupName".equals(prop.getName())) {
            String name = (String)value;
            if (!NamePropertyType.isValidName(name)) {
                throw new NameException(this.element, name, "Error.NameException.INVALID_NAME");
            }
            if (!this.isGroupNameValidInContext(name)) {
                throw new NameException(this.element, name, "Error.NameException.DUPLICATE");
            }
        }
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop, value);
            return;
        }
        if ("refTemplateParameter".equals(prop.getName()) && value == null) {
            this.clearRefTemplateParameterProp(prop, null);
            return;
        }
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.doSetProperty(prop, value);
            return;
        }
        if (this.element instanceof ReportItem && ("dataSet".equals(propName) || "cube".equals(propName))) {
            ElementRefValue refValue;
            DesignElement container = this.element.getContainer();
            DataSet dataSet = null;
            Cube cube = null;
            if ("dataSet".equals(propName)) {
                ElementRefValue refValue2 = (ElementRefValue)value;
                if (refValue2 != null) {
                    dataSet = (DataSet)refValue2.getElement();
                }
            } else if ("cube".equals(propName) && (refValue = (ElementRefValue)value) != null) {
                cube = (Cube)refValue.getElement();
            }
            if (!ContainerContext.isValidContainerment(this.module, container, (ReportItem)this.element, dataSet, cube)) {
                throw new SemanticError(this.element, "Error.SemanticError.CANNOT_SPECIFY_DATA_OBJECT");
            }
        }
        if (this.element instanceof ReportItemTheme && "type".equals(propName) && !ReportItemTheme.isValidType((String)value)) {
            throw new PropertyValueException(this.element, "type", value, "Error.PropertyValueException.NOT_SUPPORTED_REPORT_ITEM_THEME_TYPE");
        }
        this.doSetProperty(prop, value);
    }

    private void setElementTypeProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        ContainerContext context = new ContainerContext(this.element, prop.getName());
        ActivityStack stack = this.getActivityStack();
        PropertyRecord record = new PropertyRecord(this.element, prop, value);
        stack.startTrans(record.getLabel());
        ContentCommand cmd = new ContentCommand(this.module, context);
        List contents = context.getContents(this.module);
        try {
            int i;
            if (contents != null) {
                i = contents.size() - 1;
                while (i >= 0) {
                    DesignElement content = contents.get(i);
                    cmd.remove(content);
                    --i;
                }
            }
            if (value instanceof DesignElement) {
                cmd.add((DesignElement)value);
            } else if (value instanceof DesignElementHandle) {
                cmd.add(((DesignElementHandle)value).getElement());
            } else if (value instanceof List) {
                contents = (List)value;
                i = 0;
                while (i < contents.size()) {
                    Object item = contents.get(i);
                    if (item instanceof DesignElement) {
                        cmd.add((DesignElement)item);
                    } else if (item instanceof DesignElementHandle) {
                        cmd.add(((DesignElementHandle)item).getElement());
                    }
                    ++i;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void clearRefTemplateParameterProp(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        assert (prop != null);
        assert ("refTemplateParameter".equals(prop.getName()));
        ActivityStack stack = this.module.getActivityStack();
        PropertyRecord record = new PropertyRecord(this.element, prop.getName(), value);
        stack.startTrans(record.getLabel());
        try {
            ElementRefValue templateParam = (ElementRefValue)this.element.getProperty(this.module, prop);
            TemplateParameterDefinition definition = (TemplateParameterDefinition)templateParam.getElement();
            this.doSetProperty(prop, value);
            if (definition != null && !definition.hasReferences()) {
                ContentCommand cmd = new ContentCommand(definition.getRoot(), definition.getContainerInfo());
                cmd.remove(definition);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    /*
     * Unable to fully structure code
     */
    private void doSetProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        oldValue = this.element.getLocalProperty(this.module, prop);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        propName = prop.getName();
        if (this.element instanceof ExtendedItem && (extendedItem = (ExtendedItem)this.element).isExtensionModelProperty(propName)) {
            extElement = ((ExtendedItem)this.element).getExtendedElement();
            if (extElement == null) {
                return;
            }
            extElement.checkProperty(propName, value);
            extElement.setProperty(propName, value);
            return;
        }
        if (this.element instanceof Level && propName.equals("dateTimeLevelType") && value != null) {
            stack = this.getActivityStack();
            record = new PropertyRecord(this.element, prop, value);
            record.setEventTarget(this.getEventTarget());
            stack.startTrans(record.getLabel());
            stack.execute(record);
            isFound = false;
            attributesPropertyDefn = this.element.getPropertyDefn("attributes");
            attrs = (List)this.element.getProperty(this.module, attributesPropertyDefn);
            if (attrs != null) {
                i = 0;
                while (i < attrs.size()) {
                    attr = (LevelAttribute)attrs.get(i);
                    if ("DateTime".equals(attr.getName())) {
                        isFound = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isFound) {
                cmd = new ComplexPropertyCommand(this.module, this.element);
                struct = null;
                if (this.element instanceof TabularLevel) {
                    attibute = new LevelAttribute();
                    attibute.setName("DateTime");
                    attibute.setDataType(this.getDataType((TabularLevel)this.element));
                    struct = attibute;
                } else if (this.element instanceof OdaLevel) {
                    attibute = new OdaLevelAttribute();
                    attibute.setName("DateTime");
                    attibute.setDataType("date-time");
                    struct = attibute;
                }
                if (attributesPropertyDefn != null && struct != null) {
                    try {
                        cmd.addItem(new StructureContext(this.element, attributesPropertyDefn, null), (Object)struct);
                    }
                    catch (SemanticException v0) {
                        if (!PropertyCommand.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        stack.rollback();
                    }
                }
            }
            stack.commit();
            return;
        }
        stack = this.getActivityStack();
        record = new PropertyRecord(this.element, prop, value);
        stack.startTrans(record.getLabel());
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        if ("dataBindingRef".equalsIgnoreCase(propName)) {
            try {
                if (this.element instanceof ListingElement) {
                    tmpCmd = new GroupElementCommand(this.module, new ContainerContext(this.element, 1));
                    tmpCmd.updateBindingRef((ElementRefValue)oldValue, (ElementRefValue)value);
                }
                if (value != null && ((ElementRefValue)value).isResolved() || oldValue == null || !((ElementRefValue)oldValue).isResolved()) ** GOTO lbl82
                this.localizeProperties(((ElementRefValue)oldValue).getElement());
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
        } else if (this.element instanceof Style || this.element instanceof StyledElement) {
            tmpPropName = null;
            if ("backgroundSizeWidth".equals(propName)) {
                tmpPropName = "backgroundSizeHeight";
            } else if ("backgroundSizeHeight".equals(propName)) {
                tmpPropName = "backgroundSizeWidth";
            }
            if (tmpPropName != null) {
                this.handleBackgroundSize(stack, tmpPropName, value);
            }
        }
lbl82:
        // 7 sources

        if (this.element instanceof TabularDimension && "internalDimensionRef".equals(propName)) {
            try {
                command = new NameCommand(this.module, this.element);
                command.checkDimension();
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
        }
        stack.commit();
    }

    private String getDataType(TabularLevel level) {
        String columnName = level.getStringProperty(this.module, "columnName");
        if (!StringUtil.isBlank(columnName)) {
            List resultSet;
            CachedMetaData metaData;
            DesignElement container = this.element.getContainer();
            DataSet dataSet = null;
            if (container instanceof TabularHierarchy) {
                dataSet = (DataSet)container.getReferenceProperty(this.module, "dataSet");
            }
            if (dataSet == null && container != null) {
                if ((container = container.getContainer()) instanceof Dimension) {
                    container = container.getContainer();
                }
                if (container instanceof TabularCube) {
                    dataSet = (DataSet)container.getReferenceProperty(this.module, "dataSet");
                }
            }
            if (dataSet != null && (metaData = (CachedMetaData)dataSet.getProperty(this.module, "cachedMetaData")) != null && (resultSet = (List)metaData.getProperty(this.module, "resultSet")) != null) {
                for (ResultSetColumn column : resultSet) {
                    if (!columnName.equals(column.getStringProperty(this.module, "name"))) continue;
                    String dataType = column.getStringProperty(this.module, "dataType");
                    if (dataType == null) break;
                    return dataType;
                }
            }
        }
        return "date-time";
    }

    private void handleBackgroundSize(ActivityStack stack, String anotherPropName, Object value) {
        ElementPropertyDefn anotherProp = this.element.getPropertyDefn(anotherPropName);
        assert (anotherProp != null);
        Object anotherPropLocalValue = this.element.getLocalProperty(this.module, anotherProp);
        if ("contain".equals(value) || "cover".equals(value)) {
            if (!value.equals(anotherPropLocalValue)) {
                PropertyRecord record = new PropertyRecord(this.element, anotherProp, value);
                stack.execute(record);
            }
        } else if ("contain".equals(anotherPropLocalValue) || "cover".equals(anotherPropLocalValue)) {
            PropertyRecord record = new PropertyRecord(this.element, anotherProp, value);
            stack.execute(record);
        }
    }

    private void localizeProperties(DesignElement targetElement) throws SemanticException {
        ReportItem reportItem = (ReportItem)this.element;
        this.recoverReferredReportItem(reportItem, targetElement);
        if (!(reportItem instanceof ListingElement) || !(targetElement instanceof ListingElement)) {
            return;
        }
        if (!ModelUtil.isCompatibleDataBindingElements(this.element, targetElement)) {
            return;
        }
        ListingElement listing = (ListingElement)reportItem;
        List<DesignElement> listingGroups = listing.getGroups();
        ListingElement targetListing = (ListingElement)targetElement;
        List<DesignElement> targetGroups = targetListing.getGroups();
        int size = Math.min(listingGroups.size(), targetGroups.size());
        int i = 0;
        while (i < size) {
            this.recoverReferredReportItem(listingGroups.get(i), targetGroups.get(i));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void recoverReferredReportItem(DesignElement source, DesignElement targetElement) throws SemanticException {
        Iterator<String> propNames = null;
        if (targetElement instanceof ReportItem) {
            propNames = ReportItemPropSearchStrategy.getDataBindingProperties(targetElement).iterator();
        } else {
            if (!(targetElement instanceof GroupElement)) {
                assert (false);
                return;
            }
            propNames = GroupPropSearchStrategy.getDataBindingPropties().iterator();
        }
        while (propNames.hasNext()) {
            ElementPropertyDefn sourcePropDefn;
            String propName = propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)targetElement.getDefn().getProperty(propName);
            if (propDefn == null || (sourcePropDefn = (ElementPropertyDefn)source.getDefn().getProperty(propName)) == null || propDefn != sourcePropDefn && !"filter".equalsIgnoreCase(propName)) continue;
            List<ComputedColumn> value = targetElement.getStrategy().getPropertyExceptRomDefault(this.module, targetElement, propDefn);
            if ("boundDataColumns".equals(propName)) {
                value = this.getValidColumnBindings(source, targetElement, value);
            }
            value = ModelUtil.copyValue(propDefn, value);
            PropertyRecord propRecord = new PropertyRecord(source, sourcePropDefn, value);
            this.getActivityStack().execute(propRecord);
        }
    }

    private List<ComputedColumn> getValidColumnBindings(DesignElement source, DesignElement target, List<ComputedColumn> value) {
        if (source instanceof ListingElement && target instanceof ListingElement) {
            return value;
        }
        if (source.getDefn() == target.getDefn()) {
            return value;
        }
        ArrayList<ComputedColumn> retValue = new ArrayList<ComputedColumn>();
        if (value != null) {
            int i = 0;
            while (i < value.size()) {
                ComputedColumn binding = value.get(i);
                if (binding.getAggregateOn() == null) {
                    retValue.add(binding);
                }
                ++i;
            }
        }
        return retValue;
    }

    private Object validateValue(ElementPropertyDefn prop, Object value) throws SemanticException {
        if (value == null) {
            return null;
        }
        Object input = value;
        if (value instanceof DesignElementHandle) {
            input = ((DesignElementHandle)value).getElement();
        }
        Object retValue = null;
        String propName = prop.getName();
        try {
            retValue = prop.validateValue(this.module, this.element, input);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(propName);
            throw ex;
        }
        if (!(retValue instanceof ElementRefValue)) {
            return retValue;
        }
        ElementRefValue refValue = (ElementRefValue)retValue;
        if (refValue.isResolved() && value instanceof DesignElementHandle && refValue.getElement() != ((DesignElementHandle)value).getElement()) {
            throw new SemanticError(this.element, new String[]{propName, refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        return retValue;
    }

    private void setIntrinsicProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        String propName = prop.getName();
        if ("name".equals(propName) && prop.getTypeCode() == 13) {
            String name = (String)value;
            NameCommand cmd = new NameCommand(this.module, this.element);
            cmd.setName(name);
        } else if ("extends".equals(propName)) {
            ExtendsCommand cmd = new ExtendsCommand(this.module, this.element);
            cmd.setExtendsRefValue((ElementRefValue)value);
        } else if ("style".equals(propName)) {
            StyleCommand cmd = new StyleCommand(this.module, this.element);
            cmd.setStyleRefValue((ElementRefValue)value);
        } else if ("units".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("extensionName".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("theme".equals(propName)) {
            ThemeCommand cmd = new ThemeCommand(this.module, this.element);
            cmd.setThemeRefValue((ElementRefValue)value);
        } else {
            this.doSetProperty(prop, value);
        }
    }

    private boolean isGroupNameValidInContext(String groupName) {
        assert (this.element instanceof GroupElement);
        if (groupName == null) {
            return true;
        }
        if (this.element.getContainer() != null) {
            DesignElement tmpContainer = this.element.getContainer();
            List<SemanticException> errors = GroupNameValidator.getInstance().validateForRenamingGroup((ListingHandle)tmpContainer.getHandle(this.module), (GroupHandle)this.element.getHandle(this.module), groupName);
            if (!errors.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void setMember(StructureContext ref, Object value) throws SemanticException {
        Object oldValue;
        Structure struct;
        this.checkAllowedOperation();
        PropertyDefn memberDefn = ref.getPropDefn();
        ElementPropertyDefn propDefn = ref.getElementProp();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        assert (memberDefn != null);
        if (value instanceof Structure && (struct = (Structure)value).getContext() != null) {
            value = struct.copy();
        }
        value = memberDefn.validateValue(this.module, this.element, value);
        if (memberDefn.getTypeCode() == 13 || memberDefn.getTypeCode() == 22) {
            this.checkItemName(ref, (String)value);
        }
        if (value instanceof ElementRefValue && memberDefn.getTypeCode() == 15) {
            this.checkRecursiveElementReference(memberDefn, (ElementRefValue)value);
        }
        if ((oldValue = ref.getLocalValue(this.module)) == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.ChangeItem");
        stack.startTrans(label);
        ref = this.makeLocalCompositeValue(ref);
        MemberRecord record = new MemberRecord(this.module, this.element, ref, value);
        record.setEventTarget(this.getEventTarget());
        stack.execute(record);
        Structure structure = ref.getStructure();
        List<SemanticException> semanticList = structure.validate(this.module, this.element);
        if (semanticList.size() > 0) {
            stack.rollback();
            throw semanticList.get(0);
        }
        stack.commit();
    }

    private void checkAllowedOperation() {
        if (this.element != null && this.element instanceof CssStyle) {
            throw new IllegalOperationException("Error.CssException.READONLY");
        }
    }

    private void checkDataBindingReference(PropertyDefn propDefn, ElementRefValue refValue) throws SemanticException {
        if ("dataBindingRef".equals(propDefn.getName()) && refValue.isResolved() && ModelUtil.checkContainerOrContent(this.element, refValue.getElement())) {
            throw new SemanticError(this.element, new String[]{this.element.getName(), refValue.getName()}, "Error.SemanticError.INVALID_DATA_BINDING_REF");
        }
    }

    private void checkSharedDimensionReference(PropertyDefn propDefn, Object value) throws SemanticException {
        ElementRefValue refValue;
        if (!"internalDimensionRef".equalsIgnoreCase(propDefn.getName())) {
            return;
        }
        if (value instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)value;
            if (!(handle.getContainer() instanceof ModuleHandle)) {
                throw new SemanticError(this.element, new String[]{this.element.getName(), handle.getName()}, "Error.SemanticError.INVALID_DATA_BINDING_REF");
            }
        } else if (value instanceof DesignElement) {
            DesignElement refElement = (DesignElement)value;
            if (!(refElement.getContainer() instanceof Module)) {
                throw new SemanticError(this.element, new String[]{this.element.getName(), refElement.getName()}, "Error.SemanticError.INVALID_DATA_BINDING_REF");
            }
        } else if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved() && !(refValue.getElement().getContainer() instanceof Module)) {
            throw new SemanticError(this.element, new String[]{this.element.getName(), refValue.getName()}, "Error.SemanticError.INVALID_DATA_BINDING_REF");
        }
    }

    private Object validateCompatibleObject(ElementPropertyDefn propDefn, Object value) {
        boolean isCompatible = false;
        if (propDefn.allowExpression()) {
            List tmpList;
            if (value != null && !(value instanceof List) && !(value instanceof Expression)) {
                isCompatible = true;
            }
            if (value != null && value instanceof List && !(tmpList = (List)value).isEmpty() && !(tmpList.get(0) instanceof Expression)) {
                isCompatible = true;
            }
        }
        if (!isCompatible) {
            return value;
        }
        String defaultType = CompatiblePropertyChangeTables.getDefaultExprType(this.element.getDefn().getName(), propDefn.getName(), Integer.MIN_VALUE);
        if (defaultType == null) {
            return value;
        }
        ArrayList retValue = value;
        int typeCode = propDefn.getTypeCode();
        switch (typeCode) {
            case 7: {
                retValue = new Expression(value, "javascript");
                break;
            }
            case 0: 
            case 21: {
                retValue = this.doValidateCompatibleObject(propDefn, propDefn.getType(), value);
                break;
            }
            case 20: {
                if (value instanceof List) {
                    PropertyType tmpSubType = propDefn.getSubType();
                    List tmpList = value;
                    retValue = new ArrayList();
                    int i = 0;
                    while (i < tmpList.size()) {
                        ((List)retValue).add(this.doValidateCompatibleObject(propDefn, tmpSubType, tmpList.get(i)));
                        ++i;
                    }
                    break;
                }
                PropertyType tmpSubType = propDefn.getSubType();
                Expression tmpExpr = this.doValidateCompatibleObject(propDefn, tmpSubType, value);
                retValue = new ArrayList();
                ((List)retValue).add(tmpExpr);
                break;
            }
        }
        return retValue;
    }

    private Expression doValidateCompatibleObject(PropertyDefn propDefn, PropertyType subType, Object value) {
        String validatedValue = null;
        try {
            validatedValue = (String)subType.validateValue(this.module, this.element, propDefn, value);
        }
        catch (PropertyValueException propertyValueException) {}
        return new Expression(validatedValue, "constant");
    }
}

