/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.bittorrent.Torrent;
import org.eclipse.bittorrent.TorrentServer;
import org.eclipse.bittorrent.internal.net.TorrentManager;

public final class TorrentConfiguration {
    public static boolean DEBUG = false;
    static File statePath = null;
    private static final Calendar calendar = Calendar.getInstance();
    private static IDebugListener debugListener;

    public static void debug(String message) {
        if (DEBUG && debugListener != null) {
            Date date = new Date(System.currentTimeMillis());
            calendar.setTime(date);
            int hour = calendar.get(10);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
            String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
            String secondString = second < 10 ? "0" + second : Integer.toString(second);
            debugListener.print(String.valueOf(hourString) + ":" + minuteString + ":" + secondString + " " + message);
        }
    }

    public static void setDebugListener(IDebugListener listener) {
        debugListener = listener;
    }

    public static void setConfigurationPath(File directory) {
        if (statePath != null) {
            return;
        }
        if (directory == null) {
            throw new IllegalArgumentException("The provided directory cannot be null");
        }
        if (directory.isFile()) {
            throw new IllegalArgumentException(String.valueOf(directory.getAbsolutePath()) + " is a file");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IllegalArgumentException("The directory " + directory.getAbsolutePath() + " could not be made");
        }
        if (!directory.canWrite()) {
            throw new IllegalArgumentException(String.valueOf(directory.getAbsolutePath()) + " cannot be written to");
        }
        statePath = directory;
        TorrentManager.setStatePath(statePath);
    }

    public static void remove(String hexHash) {
        if (hexHash == null) {
            throw new IllegalArgumentException("The hash cannot be null");
        }
        Torrent torrent = TorrentServer.remove(hexHash);
        if (torrent != null) {
            torrent.remove();
        } else {
            File[] files = statePath.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().startsWith(hexHash)) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    private TorrentConfiguration() {
    }

    public static interface IDebugListener {
        public void print(String var1);
    }
}

