/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent.internal.encode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bittorrent.internal.encode.BEncodedDictionary;

public final class Decode {
    public static int decodeFourByteNumber(byte[] bytes, int index) {
        return (bytes[index] & 0xFF) * 0x1000000 + (bytes[index + 1] & 0xFF) * 65536 + (bytes[index + 2] & 0xFF) * 256 + (bytes[index + 3] & 0xFF);
    }

    public static int decodeSignedByte(int num) {
        if ((num &= 0xFF) < 128) {
            return num + 127;
        }
        String str = Integer.toString(num, 2);
        char[] array = new char[8];
        int j = 0;
        while (j < str.length()) {
            array[j] = str.charAt(7 - j);
            ++j;
        }
        return Integer.parseInt(new String(array), 2);
    }

    private static String getInteger(String input) {
        return input.substring(1, input.indexOf(101));
    }

    private static String getString(String input) {
        int index = input.indexOf(58) + 1;
        int length = Integer.parseInt(input.substring(0, index - 1));
        return input.substring(index, index + length);
    }

    private static List getList(String string) {
        ArrayList list = new ArrayList(){
            private static final long serialVersionUID = 1093559083643494037L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                StringBuffer buffer;
                StringBuffer stringBuffer = buffer = new StringBuffer();
                synchronized (stringBuffer) {
                    buffer.append('l');
                    int i = 0;
                    while (i < this.size()) {
                        Object obj = this.get(i);
                        if (obj instanceof String) {
                            String string = (String)obj;
                            buffer.append(string.length()).append(':').append(string);
                        } else if (obj instanceof Long) {
                            buffer.append(String.valueOf('i') + String.valueOf(obj) + 'e');
                        } else if (obj instanceof List || obj instanceof BEncodedDictionary) {
                            buffer.append(obj.toString());
                        }
                        ++i;
                    }
                    buffer.append('e');
                }
                return buffer.toString();
            }
        };
        char ch = string.charAt(0);
        while (ch != 'e') {
            String value;
            if (Character.isDigit(ch)) {
                if (ch == '0') {
                    list.add("");
                    string = string.substring(2);
                } else {
                    value = Decode.getString(string);
                    string = string.substring(string.indexOf(value) + value.length());
                    list.add(value);
                }
            } else if (ch == 'd') {
                BEncodedDictionary dictionary = Decode.parse(string.substring(1));
                list.add(dictionary);
                String value2 = dictionary.toString();
                string = string.substring(value2.length());
            } else if (ch == 'l') {
                List aList = Decode.getList(string.substring(1));
                list.add(aList);
                string = string.substring(aList.toString().length());
            } else if (ch == 'i') {
                value = Decode.getInteger(string);
                string = string.substring(value.length() + 2);
                list.add(new Long(value));
            }
            ch = string.charAt(0);
        }
        return list;
    }

    private static String parse(String string, BEncodedDictionary dictionary) {
        String key = Decode.getString(string);
        char ch = (string = string.substring(string.indexOf(key) + key.length())).charAt(0);
        if (Character.isDigit(ch)) {
            if (ch == '0') {
                dictionary.put(key, "");
                string = string.substring(2);
            } else {
                String value = Decode.getString(string);
                string = string.substring(string.indexOf(value) + value.length());
                dictionary.put(key, value);
            }
        } else if (ch == 'd') {
            BEncodedDictionary aDictionary = Decode.parse(string.substring(1));
            dictionary.put(key, aDictionary);
            string = string.substring(aDictionary.toString().length());
        } else if (ch == 'l') {
            List list = Decode.getList(string.substring(1));
            dictionary.put(key, list);
            string = string.substring(list.toString().length());
        } else if (ch == 'i') {
            String value = Decode.getInteger(string);
            string = string.substring(value.length() + 2);
            dictionary.put(key, new Long(value));
        }
        return string;
    }

    private static BEncodedDictionary parse(String string) {
        BEncodedDictionary dictionary = new BEncodedDictionary();
        while (string.charAt(0) != 'e') {
            string = Decode.parse(string, dictionary);
        }
        return dictionary;
    }

    public static BEncodedDictionary bDecode(String string) {
        if (string.charAt(0) != 'd') {
            throw new IllegalArgumentException("The string must begin with a dictionary");
        }
        return Decode.parse(string.substring(1));
    }

    public static BEncodedDictionary bDecode(InputStream inputStream) throws IOException {
        return Decode.bDecode(Decode.read(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int ch = reader.read();
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            while (ch != -1) {
                buffer.append((char)ch);
                ch = reader.read();
            }
        }
        reader.close();
        return buffer.toString();
    }

    private Decode() {
    }
}

