/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ScandiumFormatter
extends Formatter {
    private final LogPolicy logPolicy = new LogPolicy();

    public int getCallersLineNumber(String className, String methodName) {
        StackTraceElement[] stackTrace;
        if (null == className || null == methodName) {
            return -1;
        }
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!className.equals(element.getClassName()) || !methodName.equals(element.getMethodName())) continue;
            return element.getLineNumber();
        }
        return -1;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        if (this.logPolicy.dateFormat != null) {
            builder.append(this.logPolicy.dateFormat.format(new Date(record.getMillis()))).append(": ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showThreadID")) {
            builder.append(String.format("%3d", record.getThreadID())).append(" ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showLevel")) {
            builder.append(record.getLevel().toString()).append(" ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showClass")) {
            builder.append("[").append(ScandiumFormatter.getSimpleClassName(record.getSourceClassName())).append("]: ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showMessage")) {
            builder.append(this.formatMessage(record)).append(" - ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showSource")) {
            int lineNo = this.getCallersLineNumber(record.getSourceClassName(), record.getSourceMethodName());
            builder.append("(").append(record.getSourceClassName()).append(".java:").append(lineNo).append(") ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showMethod")) {
            builder.append(record.getSourceMethodName()).append("() ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showThread")) {
            builder.append("in thread ").append(Thread.currentThread().getName());
        }
        builder.append(System.lineSeparator());
        ScandiumFormatter.append(builder, record.getThrown());
        return builder.toString();
    }

    private static void append(StringBuilder builder, Throwable throwable) {
        Throwable cause = throwable;
        while (null != cause) {
            StackTraceElement[] stackTrace;
            builder.append(cause).append(System.lineSeparator());
            for (StackTraceElement element : stackTrace = cause.getStackTrace()) {
                String filename;
                builder.append("\tat ").append(element.getClassName()).append(".").append(element.getMethodName());
                if (element.isNativeMethod()) {
                    builder.append("(Native Method)");
                }
                if (null == (filename = element.getFileName())) {
                    builder.append("(Unknown Source)");
                } else {
                    builder.append("(").append(filename);
                    int line = element.getLineNumber();
                    if (0 <= line) {
                        builder.append(":").append(line);
                    }
                    builder.append(")");
                }
                builder.append(System.lineSeparator());
            }
            if (null == (cause = cause.getCause())) continue;
            builder.append("caused by ");
        }
    }

    private static String getSimpleClassName(String absolute) {
        String[] parts = absolute.split("\\.");
        return parts[parts.length - 1];
    }

    private static class LogPolicy {
        private static final String LOG_POLICY_SHOW_CLASS = "californium.LogPolicy.showClass";
        private static final String LOG_POLICY_SHOW_LEVEL = "californium.LogPolicy.showLevel";
        private static final String LOG_POLICY_SHOW_METHOD = "californium.LogPolicy.showMethod";
        private static final String LOG_POLICY_SHOW_MESSAGE = "californium.LogPolicy.showMessage";
        private static final String LOG_POLICY_SHOW_SOURCE = "californium.LogPolicy.showSource";
        private static final String LOG_POLICY_SHOW_THREAD = "californium.LogPolicy.showThread";
        private static final String LOG_POLICY_SHOW_THREAD_ID = "californium.LogPolicy.showThreadID";
        private static final String LOG_POLICY_DATE_FORMAT = "californium.LogPolicy.dateFormat";
        private Map<String, Boolean> policy = new HashMap<String, Boolean>();
        private Format dateFormat = null;

        private LogPolicy() {
            this.addPolicy(LOG_POLICY_SHOW_CLASS, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_LEVEL, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_CLASS, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_MESSAGE, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_METHOD, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_SOURCE, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_THREAD, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_THREAD_ID, Boolean.TRUE);
            String df = LogManager.getLogManager().getProperty(LOG_POLICY_DATE_FORMAT);
            if (df != null) {
                if (!df.isEmpty()) {
                    this.dateFormat = new SimpleDateFormat(df);
                }
            } else {
                this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }

        private LogPolicy addPolicy(String propertyName, boolean defaultValue) {
            String flag = LogManager.getLogManager().getProperty(propertyName);
            if (flag != null) {
                this.policy.put(propertyName, Boolean.parseBoolean(flag));
            } else {
                this.policy.put(propertyName, defaultValue);
            }
            return this;
        }

        private boolean isEnabled(String propertyName) {
            Boolean result = this.policy.get(propertyName);
            return result != null ? result : false;
        }
    }
}

