/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;

public class DtlsConnectorConfig {
    private static final String EC_ALGORITHM_NAME = "EC";
    private boolean enableReuseAddress;
    private InetSocketAddress address;
    private X509Certificate[] trustStore = new X509Certificate[0];
    private Integer maxFragmentLengthCode = null;
    private int retransmissionTimeout = 1000;
    private int maxRetransmissions = 4;
    private boolean clientAuthenticationRequired = true;
    private boolean sendRawKey = true;
    private PskStore pskStore = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private X509Certificate[] certChain;
    private CipherSuite[] supportedCipherSuites;
    private int outboundMessageBufferSize = 100000;

    private DtlsConnectorConfig() {
    }

    public Integer getMaxFragmentLengthCode() {
        return this.maxFragmentLengthCode;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public int getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public int getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public X509Certificate[] getCertificateChain() {
        if (this.certChain == null) {
            return null;
        }
        return Arrays.copyOf(this.certChain, this.certChain.length);
    }

    public final CipherSuite[] getSupportedCipherSuites() {
        if (this.supportedCipherSuites == null) {
            return new CipherSuite[0];
        }
        return Arrays.copyOf(this.supportedCipherSuites, this.supportedCipherSuites.length);
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final PskStore getPskStore() {
        return this.pskStore;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate[] getTrustStore() {
        return this.trustStore;
    }

    public final boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public final boolean isSendRawKey() {
        return this.sendRawKey;
    }

    public boolean isAddressReuseEnabled() {
        return this.enableReuseAddress;
    }

    static /* synthetic */ CipherSuite[] access$702(DtlsConnectorConfig x0, CipherSuite[] x1) {
        x0.supportedCipherSuites = x1;
        return x1;
    }

    static /* synthetic */ X509Certificate[] access$1202(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.certChain = x1;
        return x1;
    }

    static /* synthetic */ X509Certificate[] access$1402(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.trustStore = x1;
        return x1;
    }

    public static final class Builder {
        private DtlsConnectorConfig config;
        private boolean clientOnly;

        public Builder(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config = new DtlsConnectorConfig();
            this.config.address = address;
        }

        public Builder setClientOnly() {
            this.clientOnly = true;
            return this;
        }

        public Builder setEnableAddressReuse(boolean enable) {
            this.config.enableReuseAddress = enable;
            return this;
        }

        public Builder setMaxFragmentLengthCode(Integer lengthCode) {
            if (lengthCode != null && (lengthCode < 1 || lengthCode > 4)) {
                throw new IllegalArgumentException("Maximum fragment length code must be one of {1, 2, 3, 4}");
            }
            this.config.maxFragmentLengthCode = lengthCode;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setSupportedCipherSuites(CipherSuite[] cipherSuites) {
            if (cipherSuites == null || cipherSuites.length == 0) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            for (CipherSuite suite : cipherSuites) {
                if (!CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)suite)) continue;
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            DtlsConnectorConfig.access$702(this.config, Arrays.copyOf(cipherSuites, cipherSuites.length));
            return this;
        }

        public Builder setSupportedCipherSuites(String[] cipherSuites) {
            CipherSuite[] suites = new CipherSuite[cipherSuites.length];
            for (int i = 0; i < cipherSuites.length; ++i) {
                if (CipherSuite.TLS_NULL_WITH_NULL_NULL.name().equals(cipherSuites[i])) {
                    throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
                }
                CipherSuite knownSuite = CipherSuite.getTypeByName(cipherSuites[i]);
                if (knownSuite == null) {
                    throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", cipherSuites[i]));
                }
                suites[i] = knownSuite;
            }
            DtlsConnectorConfig.access$702(this.config, suites);
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setPskStore(PskStore pskStore) {
            this.config.pskStore = pskStore;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, PublicKey publicKey) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (publicKey == null) {
                throw new NullPointerException("The public key must not be null");
            }
            this.config.privateKey = privateKey;
            this.config.publicKey = publicKey;
            DtlsConnectorConfig.access$1202(this.config, null);
            this.config.sendRawKey = true;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, boolean preferRawPublicKeys) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (certificateChain == null || certificateChain.length < 1) {
                throw new NullPointerException("The certificate chain must not be null or empty");
            }
            this.config.privateKey = privateKey;
            DtlsConnectorConfig.access$1202(this.config, Builder.toX509Certificates(certificateChain));
            this.config.publicKey = this.config.certChain[0].getPublicKey();
            this.config.sendRawKey = preferRawPublicKeys;
            return this;
        }

        public Builder setTrustStore(Certificate[] trustedCerts) {
            if (trustedCerts == null) {
                throw new NullPointerException("Trust store must not be null");
            }
            DtlsConnectorConfig.access$1402(this.config, Builder.toX509Certificates(trustedCerts));
            return this;
        }

        private static X509Certificate[] toX509Certificates(Certificate[] certs) {
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certs.length);
            for (Certificate cert : certs) {
                if (!X509Certificate.class.isInstance(cert)) {
                    throw new IllegalArgumentException("can only process X.509 certificates");
                }
                result.add((X509Certificate)cert);
            }
            return result.toArray(new X509Certificate[certs.length]);
        }

        private boolean isConfiguredWithKeyPair() {
            return this.config.privateKey != null && this.config.publicKey != null;
        }

        public DtlsConnectorConfig build() {
            if (this.config.getSupportedCipherSuites().length == 0) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.getSupportedCipherSuites().length == 0) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            block4: for (CipherSuite suite : this.config.getSupportedCipherSuites()) {
                switch (suite) {
                    case TLS_PSK_WITH_AES_128_CCM_8: 
                    case TLS_PSK_WITH_AES_128_CBC_SHA256: {
                        this.verifyPskBasedCipherConfig();
                        continue block4;
                    }
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8: 
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256: {
                        this.verifyEcBasedCipherConfig();
                        continue block4;
                    }
                }
            }
            return this.config;
        }

        private void verifyPskBasedCipherConfig() {
            if (this.config.pskStore == null) {
                throw new IllegalStateException("PSK store must be set when support for " + CipherSuite.TLS_PSK_WITH_AES_128_CCM_8.name() + " is configured");
            }
        }

        private void verifyEcBasedCipherConfig() {
            if (!this.clientOnly) {
                if (this.config.getPrivateKey() == null || this.config.getPublicKey() == null) {
                    throw new IllegalStateException("Identity must be set");
                }
                if (!DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.privateKey.getAlgorithm()) || !DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.getPublicKey().getAlgorithm())) {
                    throw new IllegalStateException("Keys must be ECDSA capable when support for an ECDHE_ECDSA based cipher suite is configured");
                }
            }
        }

        private void determineCipherSuitesFromConfig() {
            ArrayList<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            if (this.isConfiguredWithKeyPair()) {
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
            }
            if (this.config.pskStore != null) {
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256);
            }
            DtlsConnectorConfig.access$702(this.config, ciphers.toArray(new CipherSuite[0]));
        }
    }
}

