/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionListener;

public final class Connection
implements SessionListener {
    private static final Logger LOGGER = Logger.getLogger(Connection.class.getName());
    private final InetSocketAddress peerAddress;
    private volatile DTLSSession establishedSession;
    private final AtomicReference<Handshaker> ongoingHandshake = new AtomicReference();
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private boolean resumptionRequired = false;

    public Connection(InetSocketAddress peerAddress) {
        this(peerAddress, null);
    }

    public Connection(InetSocketAddress peerAddress, Handshaker ongoingHandshake) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.peerAddress = peerAddress;
        this.ongoingHandshake.set(ongoingHandshake);
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getEstablishedSession() {
        return this.establishedSession;
    }

    public boolean hasEstablishedSession() {
        return this.establishedSession != null;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake.get();
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake.get() != null;
    }

    public void setOngoingHandshake(Handshaker ongoingHandshake) {
        this.ongoingHandshake.set(ongoingHandshake);
    }

    public void terminateOngoingHandshake() {
        this.cancelPendingFlight();
        this.setOngoingHandshake(null);
    }

    public void setPendingFlight(DTLSFlight pendingFlight) {
        DTLSFlight flight = this.pendingFlight.getAndSet(pendingFlight);
        if (flight != null && flight != pendingFlight) {
            flight.cancelRetransmission();
        }
    }

    public void cancelPendingFlight() {
        this.setPendingFlight(null);
    }

    public DTLSSession getSession() {
        Handshaker handshaker;
        DTLSSession session = this.establishedSession;
        if (session == null && (handshaker = this.ongoingHandshake.get()) != null) {
            session = handshaker.getSession();
        }
        return session;
    }

    @Override
    public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
        this.ongoingHandshake.set(handshaker);
        LOGGER.log(Level.FINE, "Handshake with [{0}] has been started", handshaker.getPeerAddress());
    }

    @Override
    public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
        this.establishedSession = establishedSession;
        LOGGER.log(Level.FINE, "Session with [{0}] has been established", establishedSession.getPeer());
    }

    @Override
    public void handshakeCompleted(InetSocketAddress peer) {
        Handshaker handshaker = this.ongoingHandshake.getAndSet(null);
        if (handshaker != null) {
            this.cancelPendingFlight();
            LOGGER.log(Level.FINE, "Handshake with [{0}] has been completed", peer);
        }
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired;
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }
}

