/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Record;

public class DTLSFlight {
    private final List<Record> messages;
    private InetSocketAddress peerAddress;
    private DTLSSession session;
    private int tries;
    private int timeout = 0;
    private boolean retransmissionNeeded = false;
    private boolean cancelled;
    private TimerTask retransmitTask;

    @Deprecated
    public DTLSFlight() {
        this.messages = new ArrayList<Record>();
        this.tries = 0;
        this.timeout = 0;
    }

    @Deprecated
    public DTLSFlight(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.peerAddress = peerAddress;
        this.messages = new ArrayList<Record>();
    }

    public DTLSFlight(DTLSSession session) {
        if (session == null) {
            throw new NullPointerException("Session must not be null");
        }
        if (session.getPeer() == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.session = session;
        this.peerAddress = session.getPeer();
        this.messages = new ArrayList<Record>();
        this.retransmissionNeeded = true;
    }

    public void addMessage(List<Record> message) {
        this.messages.addAll(message);
    }

    public void addMessage(Record message) {
        this.messages.add(message);
    }

    public List<Record> getMessages() {
        return this.messages;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    @Deprecated
    public void setPeerAddress(InetSocketAddress peerAddress) {
        this.peerAddress = peerAddress;
    }

    public DTLSSession getSession() {
        return this.session;
    }

    @Deprecated
    public void setSession(DTLSSession session) {
        this.session = session;
    }

    public int getTries() {
        return this.tries;
    }

    public void incrementTries() {
        ++this.tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void incrementTimeout() {
        this.timeout *= 2;
    }

    public boolean isRetransmissionNeeded() {
        return this.retransmissionNeeded;
    }

    public void setRetransmissionNeeded(boolean needsRetransmission) {
        this.retransmissionNeeded = needsRetransmission;
    }

    private final void cancelCurrentRetransmission() {
        if (this.retransmitTask != null) {
            this.retransmitTask.cancel();
            this.retransmitTask = null;
        }
    }

    public synchronized void cancelRetransmission() {
        this.cancelled = true;
        this.cancelCurrentRetransmission();
    }

    public synchronized void setRetransmitTask(TimerTask retransmitTask) {
        if (this.cancelled) {
            retransmitTask.cancel();
        } else {
            this.cancelCurrentRetransmission();
            this.retransmitTask = retransmitTask;
        }
    }
}

