/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public final class PSKServerKeyExchange
extends ServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private static final Charset CHAR_SET_UTF8 = Charset.forName("UTF8");
    private final byte[] hintEncoded;
    private final String hint;

    public PSKServerKeyExchange(String hint, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hint = hint;
        this.hintEncoded = hint.getBytes(CHAR_SET_UTF8);
    }

    private PSKServerKeyExchange(byte[] hintEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hintEncoded = Arrays.copyOf(hintEncoded, hintEncoded.length);
        this.hint = new String(this.hintEncoded, CHAR_SET_UTF8);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hintEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity Hint: ").append(this.hint).append(System.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.hintEncoded.length, 16);
        writer.writeBytes(this.hintEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] hintEncoded = reader.readBytes(length);
        return new PSKServerKeyExchange(hintEncoded, peerAddress);
    }

    public String getHint() {
        return this.hint;
    }
}

