/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public final class SupportedEllipticCurvesExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int CURVE_BITS = 16;
    private final List<Integer> supportedGroups;

    public SupportedEllipticCurvesExtension(List<Integer> supportedGroupIds) {
        super(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        this.supportedGroups = new ArrayList<Integer>(supportedGroupIds);
    }

    public SupportedEllipticCurvesExtension(ECDHECryptography.SupportedGroup[] supportedGroups) {
        super(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        this.supportedGroups = new ArrayList<Integer>();
        for (ECDHECryptography.SupportedGroup group : supportedGroups) {
            this.supportedGroups.add(group.getId());
        }
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        int listLength = this.supportedGroups.size() * 2;
        writer.write(listLength + 2, 16);
        writer.write(listLength, 16);
        for (Integer groupId : this.supportedGroups) {
            writer.write(groupId, 16);
        }
    }

    public static HelloExtension fromExtensionData(byte[] extensionData) {
        DatagramReader reader = new DatagramReader(extensionData);
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (int listLength = reader.read(16); listLength > 0; listLength -= 2) {
            int id = reader.read(16);
            groupIds.add(id);
        }
        return new SupportedEllipticCurvesExtension(groupIds);
    }

    @Override
    public int getLength() {
        return 6 + this.supportedGroups.size() * 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: ").append(this.getLength() - 4);
        sb.append(System.lineSeparator()).append("\t\t\t\tElliptic Curves Length: ").append(this.getLength() - 6);
        sb.append(System.lineSeparator()).append("\t\t\t\tElliptic Curves (").append(this.supportedGroups.size()).append(" curves):");
        for (Integer curveId : this.supportedGroups) {
            ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(curveId);
            sb.append(System.lineSeparator()).append("\t\t\t\t\tElliptic Curve: ");
            if (group != null) {
                sb.append(group.name());
            } else {
                sb.append("unknown");
            }
            sb.append(" (").append(curveId).append(")");
        }
        return sb.toString();
    }

    public List<Integer> getSupportedGroupIds() {
        return Collections.unmodifiableList(this.supportedGroups);
    }
}

