/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ScandiumFormatter
extends Formatter {
    private LogPolicy logPolicy = new LogPolicy();

    @Override
    public String format(LogRecord record) {
        String stackTrace = "";
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            stackTrace = sw.toString();
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int lineNo = throwable != null && stack.length > 7 ? stack[7].getLineNumber() : (stack.length > 8 ? stack[8].getLineNumber() : -1);
        StringBuffer b = new StringBuffer();
        if (this.logPolicy.isEnabled("californium.LogPolicy.showThreadID")) {
            b.append(String.format("%2d", record.getThreadID())).append(" ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showLevel")) {
            b.append(record.getLevel().toString()).append(" ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showClass")) {
            b.append("[").append(ScandiumFormatter.getSimpleClassName(record.getSourceClassName())).append("]: ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showMessage")) {
            b.append(this.formatMessage(record));
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showSource")) {
            b.append(" - (").append(record.getSourceClassName()).append(".java:").append(lineNo).append(") ");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showMethod")) {
            b.append(record.getSourceMethodName()).append("()");
        }
        if (this.logPolicy.isEnabled("californium.LogPolicy.showThread")) {
            b.append(" in thread ").append(Thread.currentThread().getName());
        }
        if (this.logPolicy.dateFormat != null) {
            b.append(" at (").append(this.logPolicy.dateFormat.format(new Date(record.getMillis()))).append(")");
        }
        b.append("\n").append(stackTrace);
        return b.toString();
    }

    private static String getSimpleClassName(String absolute) {
        String[] parts = absolute.split("\\.");
        return parts[parts.length - 1];
    }

    private static class LogPolicy {
        private static final String LOG_POLICY_SHOW_CLASS = "californium.LogPolicy.showClass";
        private static final String LOG_POLICY_SHOW_LEVEL = "californium.LogPolicy.showLevel";
        private static final String LOG_POLICY_SHOW_METHOD = "californium.LogPolicy.showMethod";
        private static final String LOG_POLICY_SHOW_MESSAGE = "californium.LogPolicy.showMessage";
        private static final String LOG_POLICY_SHOW_SOURCE = "californium.LogPolicy.showSource";
        private static final String LOG_POLICY_SHOW_THREAD = "californium.LogPolicy.showThread";
        private static final String LOG_POLICY_SHOW_THREAD_ID = "californium.LogPolicy.showThreadID";
        private static final String LOG_POLICY_DATE_FORMAT = "californium.LogPolicy.dateFormat";
        private Map<String, Boolean> policy = new HashMap<String, Boolean>();
        private Format dateFormat = null;

        private LogPolicy() {
            this.addPolicy(LOG_POLICY_SHOW_CLASS, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_LEVEL, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_CLASS, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_MESSAGE, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_METHOD, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_SOURCE, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_THREAD, Boolean.TRUE);
            this.addPolicy(LOG_POLICY_SHOW_THREAD_ID, Boolean.TRUE);
            String df = LogManager.getLogManager().getProperty(LOG_POLICY_DATE_FORMAT);
            if (df != null) {
                if (!df.equals("")) {
                    this.dateFormat = new SimpleDateFormat(df);
                }
            } else {
                this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }

        private LogPolicy addPolicy(String propertyName, boolean defaultValue) {
            String flag = LogManager.getLogManager().getProperty(propertyName);
            if (flag != null) {
                this.policy.put(propertyName, Boolean.parseBoolean(flag));
            } else {
                this.policy.put(propertyName, defaultValue);
            }
            return this;
        }

        private boolean isEnabled(String propertyName) {
            Boolean result = this.policy.get(propertyName);
            return result != null ? result : false;
        }
    }
}

