/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionListener;

public final class Connection
implements SessionListener {
    private static final Logger LOGGER = Logger.getLogger(Connection.class.getName());
    private final InetSocketAddress peerAddress;
    private DTLSSession establishedSession;
    private Handshaker ongoingHandshake;
    private DTLSFlight pendingFlight;
    private boolean resumptionRequired = false;

    public Connection(InetSocketAddress peerAddress) {
        this(peerAddress, null);
    }

    public Connection(InetSocketAddress peerAddress, Handshaker ongoingHandshake) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.peerAddress = peerAddress;
        this.ongoingHandshake = ongoingHandshake;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getEstablishedSession() {
        return this.establishedSession;
    }

    public boolean hasEstablishedSession() {
        return this.establishedSession != null;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake;
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake != null;
    }

    public void setOngoingHandshake(Handshaker ongoingHandshake) {
        this.ongoingHandshake = ongoingHandshake;
    }

    public void terminateOngoingHandshake() {
        this.cancelPendingFlight();
        this.setOngoingHandshake(null);
    }

    public void setPendingFlight(DTLSFlight pendingFlight) {
        this.pendingFlight = pendingFlight;
    }

    public void cancelPendingFlight() {
        if (this.pendingFlight != null) {
            this.pendingFlight.cancelRetransmission();
            this.pendingFlight = null;
        }
    }

    public DTLSSession getSession() {
        if (this.establishedSession != null) {
            return this.establishedSession;
        }
        if (this.ongoingHandshake != null) {
            return this.ongoingHandshake.getSession();
        }
        return null;
    }

    @Override
    public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
        this.ongoingHandshake = handshaker;
        LOGGER.log(Level.FINE, "Handshake with [{0}] has been started", handshaker.getPeerAddress());
    }

    @Override
    public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
        this.establishedSession = establishedSession;
        LOGGER.log(Level.FINE, "Session with [{0}] has been established", establishedSession.getPeer());
    }

    @Override
    public void handshakeCompleted(InetSocketAddress peer) {
        if (this.ongoingHandshake != null) {
            this.cancelPendingFlight();
            this.ongoingHandshake = null;
            LOGGER.log(Level.FINE, "Handshake with [{0}] has been completed", peer);
        }
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired;
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }
}

