/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.auth;

import java.security.GeneralSecurityException;
import java.security.Principal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StandardCharsets;

public final class PrincipalSerializer {
    private static final int PSK_LENGTH_BITS = 16;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private PrincipalSerializer() {
    }

    public static void serialize(Principal principal, DatagramWriter writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null");
        }
        if (principal == null) {
            writer.writeByte(ClientAuthenticationType.ANONYMOUS.code);
        } else if (principal instanceof PreSharedKeyIdentity) {
            PrincipalSerializer.serializeIdentity((PreSharedKeyIdentity)principal, writer);
        } else if (principal instanceof RawPublicKeyIdentity) {
            PrincipalSerializer.serializeSubjectInfo((RawPublicKeyIdentity)principal, writer);
        } else if (principal instanceof X509CertPath) {
            PrincipalSerializer.serializeCertChain((X509CertPath)principal, writer);
        } else {
            throw new IllegalArgumentException("unsupported principal type: " + principal.getClass().getName());
        }
    }

    private static void serializeIdentity(PreSharedKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.PSK.code);
        byte[] virtualHost = principal.getVirtualHost() == null ? EMPTY_BYTE_ARRAY : principal.getVirtualHost().getBytes(StandardCharsets.UTF_8);
        PrincipalSerializer.writeBytesWithLength(16, virtualHost, writer);
        PrincipalSerializer.writeBytesWithLength(16, principal.getIdentity().getBytes(StandardCharsets.UTF_8), writer);
    }

    private static void serializeSubjectInfo(RawPublicKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.RPK.code);
        writer.writeBytes(principal.getSubjectInfo());
    }

    private static void serializeCertChain(X509CertPath principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.CERT.code);
        writer.writeBytes(principal.toByteArray());
    }

    private static void writeBytesWithLength(int lengthBits, byte[] bytesToWrite, DatagramWriter writer) {
        writer.write(bytesToWrite.length, lengthBits);
        writer.writeBytes(bytesToWrite);
    }

    public static Principal deserialize(DatagramReader reader) throws GeneralSecurityException {
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        int code = reader.read(8);
        ClientAuthenticationType type = ClientAuthenticationType.fromCode((byte)code);
        switch (type) {
            case CERT: {
                return PrincipalSerializer.deserializeCertChain(reader);
            }
            case PSK: {
                return PrincipalSerializer.deserializeIdentity(reader);
            }
            case RPK: {
                return PrincipalSerializer.deserializeSubjectInfo(reader);
            }
        }
        return null;
    }

    private static X509CertPath deserializeCertChain(DatagramReader reader) {
        byte[] certificatePath = Asn1DerDecoder.readSequenceEntity((DatagramReader)reader);
        return X509CertPath.fromBytes((byte[])certificatePath);
    }

    private static PreSharedKeyIdentity deserializeIdentity(DatagramReader reader) {
        byte[] bytes = PrincipalSerializer.readBytesWithLength(16, reader);
        String virtualHost = bytes.length == 0 ? null : new String(bytes, StandardCharsets.UTF_8);
        bytes = PrincipalSerializer.readBytesWithLength(16, reader);
        return new PreSharedKeyIdentity(virtualHost, new String(bytes, StandardCharsets.UTF_8));
    }

    private static RawPublicKeyIdentity deserializeSubjectInfo(DatagramReader reader) throws GeneralSecurityException {
        byte[] subjectInfo = Asn1DerDecoder.readSequenceEntity((DatagramReader)reader);
        return new RawPublicKeyIdentity(subjectInfo);
    }

    private static byte[] readBytesWithLength(int lengthBits, DatagramReader reader) {
        int length = reader.read(lengthBits);
        int available = reader.bitsLeft() / 8;
        if (available < length) {
            throw new IllegalArgumentException(length + " exceeds available " + available + " bytes!");
        }
        return reader.readBytes(length);
    }

    private static enum ClientAuthenticationType {
        ANONYMOUS(0),
        CERT(1),
        PSK(2),
        RPK(-1);

        private byte code;

        private ClientAuthenticationType(byte code) {
            this.code = code;
        }

        static ClientAuthenticationType fromCode(byte code) {
            for (ClientAuthenticationType type : ClientAuthenticationType.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("unknown ClientAuthenticationType: " + code);
        }
    }
}

