/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandshaker
extends Handshaker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClientHandshaker.class.getName());
    private ProtocolVersion maxProtocolVersion = new ProtocolVersion();
    private PublicKey serverPublicKey;
    private CertPath peerCertPath;
    private ECPublicKey ephemeralServerPublicKey;
    protected ClientHello clientHello = null;
    private final List<CipherSuite> preferredCipherSuites;
    protected Integer maxFragmentLengthCode;
    protected final List<CertificateTypeExtension.CertificateType> supportedClientCertificateTypes;
    protected final List<CertificateTypeExtension.CertificateType> supportedServerCertificateTypes;
    protected ServerHello serverHello;
    protected CertificateMessage serverCertificate = null;
    protected CertificateMessage clientCertificate = null;
    protected CertificateRequest certificateRequest = null;
    protected CertificateVerify certificateVerify = null;
    protected ServerKeyExchange serverKeyExchange = null;
    protected ServerHelloDone serverHelloDone;
    protected byte[] handshakeHash = null;
    protected final PskStore pskStore;
    protected ServerNames indicatedServerNames;
    protected SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm;

    public ClientHandshaker(DTLSSession session, RecordLayer recordLayer, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(true, session, recordLayer, sessionListener, config.getCertificateVerifier(), maxTransmissionUnit, config.getRpkTrustStore());
        this.privateKey = config.getPrivateKey();
        this.certificateChain = config.getCertificateChain();
        this.publicKey = config.getPublicKey();
        this.pskStore = config.getPskStore();
        this.preferredCipherSuites = Arrays.asList(config.getSupportedCipherSuites());
        this.maxFragmentLengthCode = config.getMaxFragmentLengthCode();
        this.sniEnabled = config.isSniEnabled();
        this.supportedServerCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        this.supportedClientCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        if (CipherSuite.containsCipherSuiteRequiringCertExchange(this.preferredCipherSuites)) {
            this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            if (this.certificateVerifier != null) {
                int index = config.isSendRawKey() != false ? 1 : 0;
                this.supportedServerCertificateTypes.add(index, CertificateTypeExtension.CertificateType.X_509);
            }
            if (this.privateKey != null && this.publicKey != null) {
                if (this.certificateChain == null || this.certificateChain.length == 0) {
                    this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                } else if (config.isSendRawKey().booleanValue()) {
                    this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                    this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
                } else {
                    this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
                    this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                }
            }
        }
    }

    final SignatureAndHashAlgorithm getNegotiatedSignatureAndHashAlgorithm() {
        return this.negotiatedSignatureAndHashAlgorithm;
    }

    @Override
    protected synchronized void doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format("Processing %s message from peer [%s]", new Object[]{message.getContentType(), message.getPeer()}));
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(StringUtil.lineSeparator()).append(message);
            }
            LOGGER.debug(msg.toString());
        }
        switch (message.getContentType()) {
            case ALERT: {
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                this.setCurrentReadState();
                LOGGER.debug("Processed {} message from peer [{}]", (Object)message.getContentType(), (Object)message.getPeer());
                break;
            }
            case HANDSHAKE: {
                this.recordLayer.cancelRetransmissions();
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                block5 : switch (handshakeMsg.getMessageType()) {
                    case HELLO_REQUEST: {
                        this.receivedHelloRequest();
                        break;
                    }
                    case HELLO_VERIFY_REQUEST: {
                        this.receivedHelloVerifyRequest((HelloVerifyRequest)handshakeMsg);
                        break;
                    }
                    case SERVER_HELLO: {
                        this.receivedServerHello((ServerHello)handshakeMsg);
                        break;
                    }
                    case CERTIFICATE: {
                        this.receivedServerCertificate((CertificateMessage)handshakeMsg);
                        break;
                    }
                    case SERVER_KEY_EXCHANGE: {
                        switch (this.getKeyExchangeAlgorithm()) {
                            case EC_DIFFIE_HELLMAN: {
                                this.receivedServerKeyExchange((ECDHServerKeyExchange)handshakeMsg);
                                break block5;
                            }
                            case PSK: {
                                this.serverKeyExchange = (PSKServerKeyExchange)handshakeMsg;
                                break block5;
                            }
                            case NULL: {
                                LOGGER.info("Received unexpected ServerKeyExchange message in NULL key exchange mode.");
                                break block5;
                            }
                        }
                        throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, handshakeMsg.getPeer()));
                    }
                    case CERTIFICATE_REQUEST: {
                        this.certificateRequest = (CertificateRequest)handshakeMsg;
                        break;
                    }
                    case SERVER_HELLO_DONE: {
                        this.receivedServerHelloDone((ServerHelloDone)handshakeMsg);
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case FINISHED: {
                        this.receivedServerFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                this.incrementNextReceiveSeq();
                LOGGER.debug("Processed {} message with sequence no [{}] from peer [{}]", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq(), handshakeMsg.getPeer()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException, GeneralSecurityException {
        message.verifyData(this.getMasterSecret(), false, this.handshakeHash);
        this.state = HandshakeType.FINISHED.getCode();
        this.sessionEstablished();
        this.handshakeCompleted();
    }

    private void receivedHelloRequest() throws HandshakeException {
        if (this.state < HandshakeType.HELLO_REQUEST.getCode()) {
            this.startHandshake();
        }
    }

    protected void receivedHelloVerifyRequest(HelloVerifyRequest message) throws HandshakeException {
        this.clientHello.setCookie(message.getCookie());
        this.clientHello.setFragmentLength(this.clientHello.getMessageLength());
        DTLSFlight flight = new DTLSFlight(this.getSession());
        flight.addMessage(this.wrapMessage(this.clientHello));
        this.recordLayer.sendFlight(flight);
    }

    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        if (this.serverHello != null && message.getMessageSeq() == this.serverHello.getMessageSeq()) {
            return;
        }
        this.serverHello = message;
        this.usedProtocol = message.getServerVersion();
        this.serverRandom = message.getRandom();
        this.session.setSessionIdentifier(message.getSessionId());
        this.session.setCipherSuite(message.getCipherSuite());
        this.session.setCompressionMethod(message.getCompressionMethod());
        if (message.getMaxFragmentLength() != null) {
            MaxFragmentLengthExtension.Length maxFragmentLength = message.getMaxFragmentLength().getFragmentLength();
            if (maxFragmentLength.code() == this.maxFragmentLengthCode.intValue()) {
                this.session.setMaxFragmentLength(maxFragmentLength.length());
            } else {
                throw new HandshakeException("Server wants to use other max. fragment size than proposed", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
        }
        this.session.setSendRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.serverHello.getClientCertificateType()));
        this.session.setReceiveRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.serverHello.getServerCertificateType()));
        this.session.setSniSupported(this.serverHello.hasServerNameExtension());
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        if (this.serverCertificate != null && this.serverCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.serverCertificate = message;
        this.verifyCertificate(this.serverCertificate);
        this.serverPublicKey = this.serverCertificate.getPublicKey();
        this.peerCertPath = message.getCertificateChain();
    }

    private void receivedServerKeyExchange(ECDHServerKeyExchange message) throws HandshakeException {
        if (this.serverKeyExchange != null && this.serverKeyExchange.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.serverKeyExchange = message;
        message.verifySignature(this.serverPublicKey, this.clientRandom, this.serverRandom);
        if (this.peerCertPath != null) {
            this.session.setPeerIdentity((Principal)new X509CertPath(this.peerCertPath));
        } else {
            this.session.setPeerIdentity((Principal)new RawPublicKeyIdentity(this.serverPublicKey));
        }
        this.ephemeralServerPublicKey = message.getPublicKey();
        try {
            this.ecdhe = new ECDHECryptography(this.ephemeralServerPublicKey.getParams());
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException(String.format("Cannot create ephemeral keys from domain params provided by server: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeerAddress()));
        }
    }

    private void receivedServerHelloDone(ServerHelloDone message) throws HandshakeException, GeneralSecurityException {
        ClientKeyExchange clientKeyExchange;
        if (this.serverHelloDone != null && this.serverHelloDone.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.serverHelloDone = message;
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.createCertificateMessage(flight);
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                clientKeyExchange = new ECDHClientKeyExchange(this.ecdhe.getPublicKey(), this.session.getPeer());
                byte[] premasterSecret = this.ecdhe.getSecret(this.ephemeralServerPublicKey).getEncoded();
                this.generateKeys(premasterSecret);
                break;
            }
            case PSK: {
                String virtualHostName = this.session.getVirtualHost();
                String identity = null;
                byte[] psk = null;
                PreSharedKeyIdentity pskIdentity = null;
                if (this.sniEnabled && virtualHostName != null) {
                    ServerNames virtualHost = ServerNames.newInstance().add(ServerName.fromHostName(virtualHostName));
                    if (!this.session.isSniSupported()) {
                        LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
                    }
                    if ((identity = this.pskStore.getIdentity(this.session.getPeer(), virtualHost)) == null) {
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
                        throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", this.session.getPeer(), virtualHostName), alert);
                    }
                    psk = this.pskStore.getKey(virtualHost, identity);
                    if (psk == null) {
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
                        throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", virtualHostName, identity), alert);
                    }
                    pskIdentity = new PreSharedKeyIdentity(virtualHostName, identity);
                } else {
                    identity = this.pskStore.getIdentity(this.session.getPeer());
                    if (identity == null) {
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
                        throw new HandshakeException(String.format("No Identity found for peer [address: %s]", this.session.getPeer()), alert);
                    }
                    psk = this.pskStore.getKey(identity);
                    if (psk == null) {
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
                        throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", identity), alert);
                    }
                    pskIdentity = new PreSharedKeyIdentity(identity);
                }
                LOGGER.debug("Using PSK identity: {}", (Object)pskIdentity);
                this.session.setPeerIdentity((Principal)pskIdentity);
                clientKeyExchange = new PSKClientKeyExchange(identity, this.session.getPeer());
                byte[] premasterSecret = this.generatePremasterSecretFromPSK(psk);
                this.generateKeys(premasterSecret);
                break;
            }
            case NULL: {
                clientKeyExchange = new NULLClientKeyExchange(this.session.getPeer());
                this.generateKeys(new byte[0]);
                break;
            }
            default: {
                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.getKeyExchangeAlgorithm()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer()));
            }
        }
        flight.addMessage(this.wrapMessage(clientKeyExchange));
        if (this.certificateRequest != null && this.negotiatedSignatureAndHashAlgorithm != null) {
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientHello.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverHello.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverCertificate.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverKeyExchange.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.certificateRequest.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.serverHelloDone.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientCertificate.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, clientKeyExchange.toByteArray());
            this.certificateVerify = new CertificateVerify(this.negotiatedSignatureAndHashAlgorithm, this.privateKey, this.handshakeMessages, this.session.getPeer());
            flight.addMessage(this.wrapMessage(this.certificateVerify));
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.md.update(this.clientHello.toByteArray());
        this.md.update(this.serverHello.toByteArray());
        if (this.serverCertificate != null) {
            this.md.update(this.serverCertificate.toByteArray());
        }
        if (this.serverKeyExchange != null) {
            this.md.update(this.serverKeyExchange.toByteArray());
        }
        if (this.certificateRequest != null) {
            this.md.update(this.certificateRequest.toByteArray());
        }
        this.md.update(this.serverHelloDone.toByteArray());
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.toByteArray());
        }
        this.md.update(clientKeyExchange.toByteArray());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.toByteArray());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        this.handshakeHash = this.md.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, this.handshakeHash, this.session.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        mdWithClientFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithClientFinished.digest();
        this.recordLayer.sendFlight(flight);
    }

    private void createCertificateMessage(DTLSFlight flight) throws HandshakeException {
        if (this.certificateRequest != null) {
            if (this.session.sendRawPublicKey()) {
                byte[] rawPublicKeyBytes = new byte[]{};
                PublicKey key = this.determineClientRawPublicKey(this.certificateRequest);
                if (key != null) {
                    rawPublicKeyBytes = key.getEncoded();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("sending CERTIFICATE message with client RawPublicKey [{}] to server", (Object)ByteArrayUtils.toHexString(rawPublicKeyBytes));
                }
                this.clientCertificate = new CertificateMessage(rawPublicKeyBytes, this.session.getPeer());
            } else {
                X509Certificate[] clientChain = this.determineClientCertificateChain(this.certificateRequest);
                X509Certificate[] truncatedChain = this.certificateRequest.removeTrustedCertificates(clientChain);
                LOGGER.debug("sending CERTIFICATE message with client certificate chain [length: {}] to server", (Object)truncatedChain.length);
                this.clientCertificate = new CertificateMessage(truncatedChain, this.session.getPeer());
            }
            flight.addMessage(this.wrapMessage(this.clientCertificate));
        }
    }

    PublicKey determineClientRawPublicKey(CertificateRequest certRequest) throws HandshakeException {
        if (this.publicKey == null) {
            throw new HandshakeException("no public key configured", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
        }
        this.negotiatedSignatureAndHashAlgorithm = certRequest.getSignatureAndHashAlgorithm(this.publicKey);
        if (this.negotiatedSignatureAndHashAlgorithm == null) {
            return null;
        }
        return this.publicKey;
    }

    X509Certificate[] determineClientCertificateChain(CertificateRequest certRequest) throws HandshakeException {
        if (this.certificateChain == null) {
            throw new HandshakeException("no client certificate configured", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
        }
        this.negotiatedSignatureAndHashAlgorithm = certRequest.getSignatureAndHashAlgorithm(this.certificateChain);
        if (this.negotiatedSignatureAndHashAlgorithm == null) {
            return new X509Certificate[0];
        }
        return this.certificateChain;
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello startMessage = new ClientHello(this.maxProtocolVersion, new SecureRandom(), this.preferredCipherSuites, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes, this.session.getPeer());
        this.clientRandom = startMessage.getRandom();
        startMessage.addCompressionMethod(CompressionMethod.NULL);
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            startMessage.addExtension(ext);
            LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", new Object[]{this.maxFragmentLengthCode, this.getPeerAddress()});
        }
        this.addServerNameIndication(startMessage);
        this.state = startMessage.getMessageType().getCode();
        this.clientHello = startMessage;
        DTLSFlight flight = new DTLSFlight(this.session);
        flight.addMessage(this.wrapMessage(startMessage));
        this.recordLayer.sendFlight(flight);
    }

    private void addServerNameIndication(ClientHello helloMessage) {
        if (this.sniEnabled && this.session.getVirtualHost() != null) {
            LOGGER.debug("adding SNI extension to CLIENT_HELLO message [{}]", (Object)this.session.getVirtualHost());
            helloMessage.addExtension(ServerNameExtension.forHostName(this.session.getVirtualHost()));
        }
    }
}

