/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CompressionMethod {
    NULL(0),
    DEFLATE(1);

    public static final int COMPRESSION_METHOD_BITS = 8;
    private static final Logger LOGGER;
    private int code;

    private CompressionMethod(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CompressionMethod getMethodByCode(int code) {
        switch (code) {
            case 0: {
                return NULL;
            }
            case 1: {
                return DEFLATE;
            }
        }
        LOGGER.debug("Unknown compression method code: {}", (Object)code);
        return null;
    }

    public static byte[] listToByteArray(List<CompressionMethod> compressionMethods) {
        DatagramWriter writer = new DatagramWriter();
        for (CompressionMethod compressionMethod : compressionMethods) {
            writer.write(compressionMethod.getCode(), 8);
        }
        return writer.toByteArray();
    }

    public static List<CompressionMethod> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CompressionMethod> compressionMethods = new ArrayList<CompressionMethod>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(8);
            CompressionMethod method = CompressionMethod.getMethodByCode(code);
            if (method == null) continue;
            compressionMethods.add(method);
        }
        return compressionMethods;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)CompressionMethod.class.getCanonicalName());
    }
}

