/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;

public abstract class HelloExtension {
    protected static final int TYPE_BITS = 16;
    protected static final int LENGTH_BITS = 16;
    private ExtensionType type;

    protected HelloExtension(ExtensionType type) {
        this.type = type;
    }

    public abstract int getLength();

    public final byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.type.getId(), 16);
        this.addExtensionData(writer);
        return writer.toByteArray();
    }

    protected abstract void addExtensionData(DatagramWriter var1);

    public static HelloExtension fromByteArray(int typeCode, byte[] extensionData, InetSocketAddress peerAddress) throws HandshakeException {
        ExtensionType type = ExtensionType.getExtensionTypeById(typeCode);
        if (type == null) {
            return null;
        }
        switch (type) {
            case ELLIPTIC_CURVES: {
                return SupportedEllipticCurvesExtension.fromExtensionData(extensionData);
            }
            case EC_POINT_FORMATS: {
                return SupportedPointFormatsExtension.fromExtensionData(extensionData);
            }
            case CLIENT_CERT_TYPE: {
                return ClientCertificateTypeExtension.fromExtensionData(extensionData);
            }
            case SERVER_CERT_TYPE: {
                return ServerCertificateTypeExtension.fromExtensionData(extensionData);
            }
            case MAX_FRAGMENT_LENGTH: {
                return MaxFragmentLengthExtension.fromExtensionData(extensionData, peerAddress);
            }
            case SERVER_NAME: {
                return ServerNameExtension.fromExtensionData(extensionData, peerAddress);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t\tExtension: ").append((Object)this.type).append(" (").append(this.type.getId()).append(")\n");
        return sb.toString();
    }

    final ExtensionType getType() {
        return this.type;
    }

    public static enum ExtensionType {
        SERVER_NAME(0, "server_name"),
        MAX_FRAGMENT_LENGTH(1, "max_fragment_length"),
        CLIENT_CERTIFICATE_URL(2, "client_certificate_url"),
        TRUSTED_CA_KEYS(3, "trusted_ca_keys"),
        TRUNCATED_HMAC(4, "truncated_hmac"),
        STATUS_REQUEST(5, "status_request"),
        USER_MAPPING(6, "user_mapping"),
        CLIENT_AUTHZ(7, "client_authz"),
        SERVER_AUTHZ(8, "server_authz"),
        CERT_TYPE(9, "cert_type"),
        ELLIPTIC_CURVES(10, "elliptic_curves"),
        EC_POINT_FORMATS(11, "ec_point_formats"),
        SRP(12, "srp"),
        SIGNATURE_ALGORITHMS(13, "signature_algorithms"),
        USE_SRTP(14, "use_srtp"),
        HEARTBEAT(15, "heartbeat"),
        APPLICATION_LAYER_PROTOCOL_NEGOTIATION(16, "application_layer_protocol_negotiation"),
        STATUS_REQUEST_V2(17, "status_request_v2"),
        SIGNED_CERTIFICATE_TIMESTAMP(18, "signed_certificate_timestamp"),
        CLIENT_CERT_TYPE(19, "client_certificate_type"),
        SERVER_CERT_TYPE(20, "server_certificate_type"),
        ENCRYPT_THEN_MAC(22, "encrypt_then_mac"),
        SESSION_TICKET_TLS(35, "SessionTicket TLS"),
        RENEGOTIATION_INFO(65281, "renegotiation_info");

        private int id;
        private String name;

        private ExtensionType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static ExtensionType getExtensionTypeById(int id) {
            for (ExtensionType type : ExtensionType.values()) {
                if (type.getId() != id) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

