/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.californium.scandium.util.ServerName;

public final class ServerNames
implements Iterable<ServerName> {
    private final Set<ServerName> names = new HashSet<ServerName>();
    int encodedLength;

    private ServerNames() {
    }

    private ServerNames(ServerName serverName) {
        this();
        this.add(serverName);
    }

    public static ServerNames newInstance() {
        return new ServerNames();
    }

    public static ServerNames newInstance(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("name must not be null");
        }
        return new ServerNames(serverName);
    }

    public ServerNames add(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("server name must not be null");
        }
        if (this.names.contains(serverName)) {
            throw new IllegalStateException("there already is a name of the given type");
        }
        this.names.add(serverName);
        ++this.encodedLength;
        this.encodedLength += 2;
        this.encodedLength += serverName.getName().length;
        return this;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public int size() {
        return this.names.size();
    }

    public byte[] get(ServerName.NameType type) {
        for (ServerName name : this.names) {
            if (!name.getType().equals((Object)type)) continue;
            return name.getName();
        }
        return null;
    }

    public ServerName getServerName(ServerName.NameType type) {
        for (ServerName name : this.names) {
            if (!name.getType().equals((Object)type)) continue;
            return name;
        }
        return null;
    }

    @Override
    public Iterator<ServerName> iterator() {
        return this.names.iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ServerNames[");
        Iterator<ServerName> iter = this.names.iterator();
        while (iter.hasNext()) {
            b.append(iter.next().getNameAsString());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }
}

