/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;

public final class PSKServerKeyExchange
extends ServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private final byte[] hintEncoded;
    private final String hint;

    public PSKServerKeyExchange(String hint, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hint = hint;
        this.hintEncoded = hint.getBytes(StandardCharsets.UTF_8);
    }

    private PSKServerKeyExchange(byte[] hintEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hintEncoded = Arrays.copyOf(hintEncoded, hintEncoded.length);
        this.hint = new String(this.hintEncoded, StandardCharsets.UTF_8);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hintEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity Hint: ").append(this.hint).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.hintEncoded.length, 16);
        writer.writeBytes(this.hintEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] hintEncoded = reader.readBytes(length);
        return new PSKServerKeyExchange(hintEncoded, peerAddress);
    }

    public String getHint() {
        return this.hint;
    }
}

