/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandshaker
extends Handshaker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServerHandshaker.class.getName());
    private DTLSFlight lastFlight;
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private CertPath peerCertPath;
    private List<CipherSuite> supportedCipherSuites;
    private List<CertificateTypeExtension.CertificateType> supportedClientCertificateTypes;
    private List<CertificateTypeExtension.CertificateType> supportedServerCertificateTypes;
    private CertificateTypeExtension.CertificateType negotiatedClientCertificateType;
    private CertificateTypeExtension.CertificateType negotiatedServerCertificateType;
    private ECDHECryptography.SupportedGroup negotiatedSupportedGroup;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    private ServerNames indicatedServerNames;
    protected CertificateMessage clientCertificate = null;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify = null;
    protected final PskStore pskStore;

    public ServerHandshaker(DTLSSession session, RecordLayer recordLayer, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) throws HandshakeException {
        this(0, session, recordLayer, sessionListener, config, maxTransmissionUnit);
    }

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, RecordLayer recordLayer, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(false, initialMessageSequenceNo, session, recordLayer, sessionListener, config.getCertificateVerifier(), maxTransmissionUnit, config.getRpkTrustStore());
        this.supportedCipherSuites = Arrays.asList(config.getSupportedCipherSuites());
        this.pskStore = config.getPskStore();
        this.privateKey = config.getPrivateKey();
        this.certificateChain = config.getCertificateChain();
        this.publicKey = config.getPublicKey();
        this.sniEnabled = config.isSniEnabled();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.supportedClientCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        this.supportedServerCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        if (CipherSuite.containsCipherSuiteRequiringCertExchange(this.supportedCipherSuites)) {
            if (this.clientAuthenticationRequired) {
                this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                if (config.getCertificateVerifier() != null) {
                    int index = config.isSendRawKey() != false ? 1 : 0;
                    this.supportedClientCertificateTypes.add(index, CertificateTypeExtension.CertificateType.X_509);
                }
            }
            if (this.privateKey != null && this.publicKey != null) {
                if (this.certificateChain == null || this.certificateChain.length == 0) {
                    this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                } else if (config.isSendRawKey().booleanValue()) {
                    this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                    this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
                } else {
                    this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
                    this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                }
            }
        }
    }

    @Override
    protected synchronized void doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.lastFlight != null) {
            LOGGER.debug("Received client's ({}) FINISHED message again, retransmitting last flight...", (Object)this.getPeerAddress());
            this.lastFlight.incrementTries();
            this.lastFlight.setNewSequenceNumbers();
            this.recordLayer.sendFlight(this.lastFlight);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Processing {} message from peer [{}]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(StringUtil.lineSeparator()).append(message);
            }
            LOGGER.debug(msg.toString(), (Object)message.getContentType(), (Object)message.getPeer());
        }
        switch (message.getContentType()) {
            case CHANGE_CIPHER_SPEC: {
                this.setCurrentReadState();
                LOGGER.debug("Processed {} message from peer [{}]", (Object)message.getContentType(), (Object)message.getPeer());
                break;
            }
            case HANDSHAKE: {
                this.recordLayer.cancelRetransmissions();
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case CLIENT_HELLO: {
                        this.receivedClientHello((ClientHello)handshakeMsg);
                        break;
                    }
                    case CERTIFICATE: {
                        this.receivedClientCertificate((CertificateMessage)handshakeMsg);
                        break;
                    }
                    case CLIENT_KEY_EXCHANGE: {
                        switch (this.getKeyExchangeAlgorithm()) {
                            case PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case ECDHE_PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((EcdhPskClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case EC_DIFFIE_HELLMAN: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case NULL: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((NULLClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            default: {
                                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, handshakeMsg.getPeer()));
                            }
                        }
                        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientKeyExchange.getRawMessage());
                        if (this.clientAuthenticationRequired && this.getKeyExchangeAlgorithm() == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN) break;
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case CERTIFICATE_VERIFY: {
                        this.receivedCertificateVerify((CertificateVerify)handshakeMsg);
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case FINISHED: {
                        this.receivedClientFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                if (this.lastFlight == null) {
                    this.incrementNextReceiveSeq();
                }
                LOGGER.debug("Processed {} message with message sequence no [{}] from peer [{}]", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq(), message.getPeer()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (this.clientCertificate != null && this.clientCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.clientCertificate = message;
        this.verifyCertificate(this.clientCertificate);
        this.clientPublicKey = this.clientCertificate.getPublicKey();
        this.peerCertPath = message.getCertificateChain();
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientCertificate.getRawMessage());
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        if (this.peerCertPath != null) {
            this.session.setPeerIdentity((Principal)new X509CertPath(this.peerCertPath));
        } else {
            this.session.setPeerIdentity((Principal)new RawPublicKeyIdentity(this.clientPublicKey));
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return;
        }
        if (CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.getKeyExchangeAlgorithm()) && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        DTLSFlight flight = new DTLSFlight(this.getSession());
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.getRawMessage());
        }
        this.md.update(this.clientKeyExchange.getRawMessage());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.getRawMessage());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
            mdWithClientFinished.update(message.toByteArray());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Cannot compute digest for server's Finish handshake message", (Throwable)e);
        }
        byte[] handshakeHash = this.md.digest();
        message.verifyData(this.getMasterSecret(), true, handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        handshakeHash = mdWithClientFinished.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, handshakeHash, this.session.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.recordLayer.sendFlight(flight);
        this.sessionEstablished();
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.md.update(clientHello.getRawMessage());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, clientHello.getRawMessage());
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(clientHello, flight);
        this.createServerKeyExchange(clientHello, flight);
        this.createCertificateRequest(clientHello, flight);
        ServerHelloDone serverHelloDone = new ServerHelloDone(this.session.getPeer());
        flight.addMessage(this.wrapMessage(serverHelloDone));
        this.md.update(serverHelloDone.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHelloDone.toByteArray());
        this.recordLayer.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ServerNameExtension serverNameExt;
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getClientVersion());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        SessionId sessionId = new SessionId();
        this.session.setSessionIdentifier(sessionId);
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, clientHello.getPeer()));
        }
        this.session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        MaxFragmentLengthExtension maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension();
        if (maxFragmentLengthExt != null) {
            this.session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), (Object)clientHello.getPeer());
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null) {
            if (this.sniEnabled) {
                this.indicatedServerNames = serverNameExt.getServerNames();
                serverHelloExtensions.addExtension(ServerNameExtension.emptyServerNameIndication());
                this.session.setSniSupported(true);
                LOGGER.debug("using server name indication received from peer [{}]", (Object)clientHello.getPeer());
            } else {
                LOGGER.warn("client [{}] included SNI in HELLO but SNI support is disabled", (Object)clientHello.getPeer());
            }
        }
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, this.session.getCipherSuite(), this.session.getCompressionMethod(), serverHelloExtensions, this.session.getPeer());
        flight.addMessage(this.wrapMessage(serverHello));
        this.md.update(serverHello.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHello.toByteArray());
    }

    private void createCertificateMessage(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        CertificateMessage certificateMessage = null;
        if (this.session.getCipherSuite().requiresServerCertificateMessage()) {
            certificateMessage = this.session.sendRawPublicKey() ? new CertificateMessage(this.publicKey.getEncoded(), this.session.getPeer()) : new CertificateMessage(this.certificateChain, this.session.getPeer());
            flight.addMessage(this.wrapMessage(certificateMessage));
            this.md.update(certificateMessage.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateMessage.toByteArray());
        }
    }

    private void createServerKeyExchange(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        HandshakeMessage serverKeyExchange = null;
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                this.signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(SignatureAndHashAlgorithm.HashAlgorithm.SHA256, SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA);
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new ECDHServerKeyExchange(this.signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new EcdhPskServerKeyExchange(this.ecdhe, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
        }
        if (serverKeyExchange != null) {
            flight.addMessage(this.wrapMessage(serverKeyExchange));
            this.md.update(serverKeyExchange.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverKeyExchange.toByteArray());
        }
    }

    private void createCertificateRequest(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        if (this.clientAuthenticationRequired && this.signatureAndHashAlgorithm != null) {
            CertificateRequest certificateRequest = new CertificateRequest(this.session.getPeer());
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            certificateRequest.addSignatureAlgorithm(new SignatureAndHashAlgorithm(this.signatureAndHashAlgorithm.getHash(), this.signatureAndHashAlgorithm.getSignature()));
            if (this.certificateVerifier != null) {
                certificateRequest.addCertificateAuthorities(this.certificateVerifier.getAcceptedIssuers());
            }
            flight.addMessage(this.wrapMessage(certificateRequest));
            this.md.update(certificateRequest.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateRequest.toByteArray());
        }
    }

    private byte[] receivedClientKeyExchange(ECDHClientKeyExchange message) {
        this.clientKeyExchange = message;
        byte[] premasterSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return premasterSecret;
    }

    private byte[] receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        String identity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(this.indicatedServerNames, identity);
        return this.configurePskCredentials(identity, psk, null);
    }

    private byte[] receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        String identity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(this.indicatedServerNames, identity);
        byte[] otherSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return this.configurePskCredentials(identity, psk, otherSecret);
    }

    private byte[] receivedClientKeyExchange(NULLClientKeyExchange message) {
        this.clientKeyExchange = message;
        return new byte[0];
    }

    @Override
    public void startHandshake() throws HandshakeException {
        HelloRequest helloRequest = new HelloRequest(this.session.getPeer());
        DTLSFlight flight = new DTLSFlight(this.getSession());
        flight.addMessage(this.wrapMessage(helloRequest));
        this.recordLayer.sendFlight(flight);
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, this.session.getPeer());
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private void negotiateCipherSuite(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        CertificateTypeExtension.CertificateType supportedServerCertType = this.getSupportedServerCertificateType(clientHello);
        CertificateTypeExtension.CertificateType supportedClientCertType = this.getSupportedClientCertificateType(clientHello);
        ECDHECryptography.SupportedGroup group = ServerHandshaker.negotiateNamedCurve(clientHello);
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !this.supportedCipherSuites.contains((Object)cipherSuite) || !this.isEligible(cipherSuite, supportedServerCertType, supportedClientCertType, group)) continue;
            this.negotiatedServerCertificateType = supportedServerCertType;
            this.negotiatedClientCertificateType = supportedClientCertType;
            this.negotiatedSupportedGroup = group;
            this.session.setCipherSuite(cipherSuite);
            this.addServerHelloExtensions(cipherSuite, clientHello, serverHelloExtensions);
            LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", new Object[]{cipherSuite.name(), this.getPeerAddress()});
            return;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
        throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
    }

    private boolean isEligible(CipherSuite cipher, CertificateTypeExtension.CertificateType supportedServerCertType, CertificateTypeExtension.CertificateType supportedClientCertType, ECDHECryptography.SupportedGroup group) {
        boolean result = true;
        if (cipher.isEccBased()) {
            result &= group != null;
        }
        if (cipher.requiresServerCertificateMessage()) {
            result &= supportedServerCertType != null;
            if (this.clientAuthenticationRequired) {
                result &= supportedClientCertType != null;
            }
        }
        return result;
    }

    private void addServerHelloExtensions(CipherSuite negotiatedCipherSuite, ClientHello clientHello, HelloExtensions extensions) {
        CertificateTypeExtension ext;
        if (this.negotiatedClientCertificateType != null) {
            this.session.setReceiveRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.negotiatedClientCertificateType));
            if (clientHello.getClientCertificateTypeExtension() != null) {
                ext = new ClientCertificateTypeExtension(false);
                ext.addCertificateType(this.negotiatedClientCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (this.negotiatedServerCertificateType != null) {
            this.session.setSendRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.negotiatedServerCertificateType));
            if (clientHello.getServerCertificateTypeExtension() != null) {
                ext = new ServerCertificateTypeExtension(false);
                ext.addCertificateType(this.negotiatedServerCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (negotiatedCipherSuite.isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
            extensions.addExtension(new SupportedPointFormatsExtension(formats));
        }
    }

    private static ECDHECryptography.SupportedGroup negotiateNamedCurve(ClientHello clientHello) {
        ECDHECryptography.SupportedGroup result;
        block2: {
            SupportedEllipticCurvesExtension extension;
            List<ECDHECryptography.SupportedGroup> preferredGroups;
            block1: {
                result = null;
                preferredGroups = ECDHECryptography.SupportedGroup.getPreferredGroups();
                extension = clientHello.getSupportedEllipticCurvesExtension();
                if (extension != null) break block1;
                if (preferredGroups.isEmpty()) break block2;
                result = preferredGroups.get(0);
                break block2;
            }
            for (Integer preferredGroupId : extension.getSupportedGroupIds()) {
                ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(preferredGroupId);
                if (group == null || !group.isUsable() || !preferredGroups.contains((Object)group)) continue;
                result = group;
                break;
            }
        }
        return result;
    }

    private CertificateTypeExtension.CertificateType getSupportedClientCertificateType(ClientHello clientHello) throws HandshakeException {
        ClientCertificateTypeExtension certTypeExt = clientHello.getClientCertificateTypeExtension();
        if (certTypeExt != null) {
            for (CertificateTypeExtension.CertificateType certType : certTypeExt.getCertificateTypes()) {
                if (!this.supportedClientCertificateTypes.contains((Object)certType)) continue;
                return certType;
            }
        } else if (this.supportedClientCertificateTypes.contains((Object)CertificateTypeExtension.CertificateType.X_509)) {
            return CertificateTypeExtension.CertificateType.X_509;
        }
        return null;
    }

    private CertificateTypeExtension.CertificateType getSupportedServerCertificateType(ClientHello clientHello) throws HandshakeException {
        ServerCertificateTypeExtension certTypeExt = clientHello.getServerCertificateTypeExtension();
        if (certTypeExt != null) {
            for (CertificateTypeExtension.CertificateType certType : certTypeExt.getCertificateTypes()) {
                if (!this.supportedServerCertificateTypes.contains((Object)certType)) continue;
                return certType;
            }
        } else if (this.supportedServerCertificateTypes.contains((Object)CertificateTypeExtension.CertificateType.X_509)) {
            return CertificateTypeExtension.CertificateType.X_509;
        }
        return null;
    }

    final CertificateTypeExtension.CertificateType getNegotiatedClientCertificateType() {
        return this.negotiatedClientCertificateType;
    }

    final CertificateTypeExtension.CertificateType getNegotiatedServerCertificateType() {
        return this.negotiatedServerCertificateType;
    }

    final ECDHECryptography.SupportedGroup getNegotiatedSupportedGroup() {
        return this.negotiatedSupportedGroup;
    }

    final ServerNames getIndicatedServerNames() {
        return this.indicatedServerNames;
    }

    @Override
    protected boolean isFirstMessageReceived(HandshakeMessage handshakeMessage) {
        if (HandshakeType.CLIENT_HELLO.equals((Object)handshakeMessage.getMessageType())) {
            Random messageRandom = ((ClientHello)handshakeMessage).getRandom();
            return Arrays.equals(this.clientRandom.getRandomBytes(), messageRandom.getRandomBytes());
        }
        return false;
    }

    private byte[] configurePskCredentials(String identity, byte[] psk, byte[] otherSecret) throws HandshakeException {
        String virtualHost = null;
        if (this.indicatedServerNames == null) {
            LOGGER.debug("client [{}] uses PSK identity [{}]", (Object)this.getPeerAddress(), (Object)identity);
        } else {
            ServerName serverName = this.indicatedServerNames.getServerName(ServerName.NameType.HOST_NAME);
            if (serverName == null) {
                LOGGER.debug("client [{}] provided invalid SNI extension which doesn't include a hostname", (Object)this.getPeerAddress());
            } else {
                virtualHost = new String(serverName.getName(), ServerName.CHARSET);
                LOGGER.debug("client [{}] uses PSK identity [{}] for server [{}]", new Object[]{this.getPeerAddress(), identity, virtualHost});
            }
        }
        if (psk == null) {
            throw new HandshakeException(String.format("cannot authenticate client, identity [%s] is unknown for server [%s]", identity, virtualHost), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY, this.session.getPeer()));
        }
        this.session.setPeerIdentity((Principal)new PreSharedKeyIdentity(virtualHost, identity));
        return this.generatePremasterSecretFromPSK(psk, otherSecret);
    }
}

