/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public class InMemoryPskStore
implements PskStore {
    private static final ServerName GLOBAL_SCOPE = ServerName.from(ServerName.NameType.UNDEFINED, new byte[0]);
    private final Map<ServerName, Map<String, byte[]>> scopedKeys = new ConcurrentHashMap<ServerName, Map<String, byte[]>>();
    private final Map<InetSocketAddress, Map<ServerName, String>> scopedIdentities = new ConcurrentHashMap<InetSocketAddress, Map<ServerName, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getKey(String identity) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            return InMemoryPskStore.getKeyFromMap(identity, this.scopedKeys.get(GLOBAL_SCOPE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getKey(ServerNames serverNames, String identity) {
        if (serverNames == null) {
            return this.getKey(identity);
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            for (ServerName serverName : serverNames) {
                byte[] key = InMemoryPskStore.getKeyFromMap(identity, this.scopedKeys.get(serverName));
                if (key == null) continue;
                return key;
            }
            return null;
        }
    }

    private static byte[] getKeyFromMap(String identity, Map<String, byte[]> keyMap) {
        byte[] key;
        byte[] result = null;
        if (keyMap != null && (key = keyMap.get(identity)) != null) {
            result = Arrays.copyOf(key, key.length);
        }
        return result;
    }

    public void setKey(String identity, byte[] key) {
        this.setKey(identity, key, GLOBAL_SCOPE);
    }

    public void setKey(String identity, byte[] key, String virtualHost) {
        this.setKey(identity, key, ServerName.fromHostName(virtualHost));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String identity, byte[] key, ServerName virtualHost) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("serverName must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            Map<String, byte[]> keysForServerName = this.scopedKeys.get(virtualHost);
            if (keysForServerName == null) {
                keysForServerName = new ConcurrentHashMap<String, byte[]>();
                this.scopedKeys.put(virtualHost, keysForServerName);
            }
            keysForServerName.put(identity, Arrays.copyOf(key, key.length));
        }
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, GLOBAL_SCOPE, identity, key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String virtualHost, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, ServerName.fromHostName(virtualHost), identity, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKnownPeer(InetSocketAddress peerAddress, ServerName virtualHost, String identity, byte[] key) {
        if (peerAddress == null) {
            throw new NullPointerException("peer address must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("virtual host must not be null");
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            Map<ServerName, String> identities = this.scopedIdentities.get(peerAddress);
            if (identities == null) {
                identities = new ConcurrentHashMap<ServerName, String>();
                this.scopedIdentities.put(peerAddress, identities);
            }
            identities.put(virtualHost, identity);
            this.setKey(identity, key, virtualHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdentity(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            return InMemoryPskStore.getIdentityFromMap(GLOBAL_SCOPE, this.scopedIdentities.get(peerAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        if (virtualHost == null) {
            return this.getIdentity(peerAddress);
        }
        if (peerAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            for (ServerName serverName : virtualHost) {
                String identity = InMemoryPskStore.getIdentityFromMap(serverName, this.scopedIdentities.get(peerAddress));
                if (identity == null) continue;
                return identity;
            }
            return null;
        }
    }

    private static String getIdentityFromMap(ServerName virtualHost, Map<ServerName, String> identities) {
        if (identities != null) {
            return identities.get(virtualHost);
        }
        return null;
    }
}

