/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidator;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticCertificateVerifier
implements CertificateVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StaticCertificateVerifier.class.getName());
    private final X509Certificate[] rootCertificates;

    public StaticCertificateVerifier(X509Certificate[] rootCertificates) {
        this.rootCertificates = rootCertificates;
    }

    @Override
    public void verifyCertificate(CertificateMessage message, DTLSSession session) throws HandshakeException {
        if (this.rootCertificates != null && this.rootCertificates.length == 0) {
            return;
        }
        Set<TrustAnchor> trustAnchors = StaticCertificateVerifier.getTrustAnchors(this.rootCertificates);
        try {
            PKIXParameters params = new PKIXParameters(trustAnchors);
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(message.getCertificateChain(), params);
        }
        catch (GeneralSecurityException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Certificate validation failed", (Throwable)e);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated", alert);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.rootCertificates;
    }

    private static Set<TrustAnchor> getTrustAnchors(X509Certificate[] trustedCertificates) {
        HashSet<TrustAnchor> result = new HashSet<TrustAnchor>();
        if (trustedCertificates != null) {
            for (X509Certificate cert : trustedCertificates) {
                result.add(new TrustAnchor(cert, null));
            }
        }
        return result;
    }
}

