/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyAgreement;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyPairGenerator;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ECDHECryptography {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ECDHECryptography.class);
    private static final String KEYPAIR_GENERATOR_ALGORITHM = "EC";
    private static final ThreadLocalKeyPairGenerator KEYPAIR_GENERATOR = new ThreadLocalKeyPairGenerator("EC");
    private static final int PRIME = 1;
    private static final int BINARY = 2;
    private static final String KEY_AGREEMENT_ALGORITHM = "ECDH";
    private static final ThreadLocalKeyAgreement KEY_AGREEMENT = new ThreadLocalKeyAgreement("ECDH");
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;

    public ECDHECryptography(ECParameterSpec params) throws GeneralSecurityException {
        this.createKeys(params);
    }

    private ECDHECryptography(String supportedGroup) throws GeneralSecurityException {
        this.createKeys(new ECGenParameterSpec(supportedGroup));
    }

    public static ECDHECryptography fromNamedCurveId(int supportedGroupId) {
        SupportedGroup group = SupportedGroup.fromId(supportedGroupId);
        if (group == null) {
            return null;
        }
        try {
            return new ECDHECryptography(group.name());
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("Cannot create ephemeral keys for group [{}]: {}", new Object[]{group.name(), e.getMessage()});
            return null;
        }
    }

    private void createKeys(AlgorithmParameterSpec params) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)KEYPAIR_GENERATOR.current();
        keyPairGenerator.initialize(params, RandomManager.currentSecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = (ECPrivateKey)keyPair.getPrivate();
        this.publicKey = (ECPublicKey)keyPair.getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecretKey generateSecret(byte[] encodedPoint) {
        SecretKey secretKey = null;
        try {
            ECParameterSpec params = this.publicKey.getParams();
            DatagramReader reader = new DatagramReader(encodedPoint, false);
            ECPublicKey peerPublicKey = Asn1DerDecoder.readEcPublicKey((DatagramReader)reader, (ECParameterSpec)params);
            secretKey = this.generateSecret(peerPublicKey);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not generate the premaster secret", (Throwable)e);
        }
        return secretKey;
    }

    public SecretKey generateSecret(PublicKey peerPublicKey) {
        SecretKey secretKey = null;
        try {
            KeyAgreement keyAgreement = (KeyAgreement)KEY_AGREEMENT.current();
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(peerPublicKey, true);
            byte[] secret = keyAgreement.generateSecret();
            secretKey = SecretUtil.create(secret, "TlsPremasterSecret");
            Bytes.clear((byte[])secret);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not generate the premaster secret", (Throwable)e);
        }
        return secretKey;
    }

    public static byte[] trimZeroes(byte[] byeArray) {
        int count;
        for (count = 0; count < byeArray.length - 1 && byeArray[count] == 0; ++count) {
        }
        if (count == 0) {
            return byeArray;
        }
        if (count < byeArray.length) {
            byte[] trimmedByteArray = new byte[byeArray.length - count];
            System.arraycopy(byeArray, count, trimmedByteArray, 0, trimmedByteArray.length);
            return trimmedByteArray;
        }
        return Bytes.EMPTY;
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        int fieldSize = (curve.getField().getFieldSize() + 7) / 8;
        byte[] xb = ECDHECryptography.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECDHECryptography.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > fieldSize || yb.length > fieldSize) {
            LOGGER.error("Point coordinates do not match field size.");
            return null;
        }
        byte[] encoded = new byte[1 + fieldSize * 2];
        encoded[0] = 4;
        System.arraycopy(xb, 0, encoded, fieldSize - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, encoded, encoded.length - yb.length, yb.length);
        return encoded;
    }

    public static enum SupportedGroup {
        sect163k1(1),
        sect163r1(2),
        sect163r2(3),
        sect193r1(4),
        sect193r2(5),
        sect233k1(6),
        sect233r1(7),
        sect239k1(8),
        sect283k1(9),
        sect283r1(10),
        sect409k1(11),
        sect409r1(12),
        sect571k1(13),
        sect571r1(14),
        secp160k1(15),
        secp160r1(16),
        secp160r2(17),
        secp192k1(18, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37", "000000000000000000000000000000000000000000000000", "000000000000000000000000000000000000000000000003", "DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D", "9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D", "FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D", 1),
        secp192r1(19, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC", "64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1", "188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012", "07192B95FFC8DA78631011ED6B24CDD573F977A11E794811", "FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831", 1),
        secp224k1(20, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D", "00000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000000005", "A1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45C", "7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5", "010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7", 1),
        secp224r1(21, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", "B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", "B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21", "BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34", "FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", 1),
        secp256k1(22, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000007", "79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", "483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 1),
        secp256r1(23, 1, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 1),
        secp384r1(24, 1, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 1),
        secp521r1(25, 1, "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 1),
        brainpoolP256r1(26, 1, "A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", "7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", "26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", "8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", "547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", "A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 1),
        brainpoolP384r1(27, 1, "8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B412B1DA197FB71123ACD3A729901D1A71874700133107EC53", "7BC382C63D8C150C3C72080ACE05AFA0C2BEA28E4FB22787139165EFBA91F90F8AA5814A503AD4EB04A8C7DD22CE2826", "4A8C7DD22CE28268B39B55416F0447C2FB77DE107DCD2A62E880EA53EEB62D57CB4390295DBC9943AB78696FA504C11", "1D1C64F068CF45FFA2A63A81B7C13F6B8847A3E77EF14FE3DB7FCAFE0CBD10E8E826E03436D646AAEF87B2E247D4AF1E", "8ABE1D7520F9C2A45CB1EB8E95CFD55262B70B29FEEC5864E19C054FF99129280E4646217791811142820341263C5315", "8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B31F166E6CAC0425A7CF3AB6AF6B7FC3103B883202E9046565", 1),
        brainpoolP512r1(28, 1, "AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA703308717D4D9B009BC66842AECDA12AE6A380E62881FF2F2D82C68528AA6056583A48F3", "7830A3318B603B89E2327145AC234CC594CBDD8D3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CA", "3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CADC083E67984050B75EBAE5DD2809BD638016F723", "81AEE4BDD82ED9645A21322E9C4C6A9385ED9F70B5D916C1B43B62EEF4D0098EFF3B1F78E2D0D48D50D1687B93B97D5F7C6D5047406A5E688B352209BCB9F822", "7DDE385D566332ECC0EABFA9CF7822FDF209F70024A57B1AA000C55B881F8111B2DCDE494A5F485E5BCA4BD88A2763AED1CA2B2FA8F0540678CD1E0F3AD80892", "AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA70330870553E5C414CA92619418661197FAC10471DB1D381085DDADDB58796829CA90069", 1),
        ffdhe2048(256),
        ffdhe3072(257),
        ffdhe4096(258),
        ffdhe6144(259),
        ffdhe8192(260),
        arbitrary_explicit_prime_curves(65281),
        arbitrary_explicit_char2_curves(65282);

        private int id;
        private ECParameterSpec params = null;
        private boolean usable;

        private SupportedGroup(int code) {
            this.id = code;
        }

        private SupportedGroup(int code, int type, String p, String a, String b, String x, String y, String n2, int h) {
            this(code);
            ECField field;
            BigInteger bip = this.bi(p);
            switch (type) {
                case 1: {
                    field = new ECFieldFp(bip);
                    break;
                }
                case 2: {
                    field = new ECFieldF2m(bip.bitLength() - 1, bip);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot handle supported groups of type " + type);
                }
            }
            EllipticCurve curve = new EllipticCurve(field, this.bi(a), this.bi(b));
            ECPoint g = new ECPoint(this.bi(x), this.bi(y));
            this.params = new ECParameterSpec(curve, g, this.bi(n2), h);
            try {
                KeyPairGenerator gen = (KeyPairGenerator)KEYPAIR_GENERATOR.current();
                gen.initialize(new ECGenParameterSpec(this.name()));
                this.usable = true;
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug("Group [{}] is not supported by JRE", (Object)this.name());
            }
        }

        private BigInteger bi(String s) {
            return new BigInteger(s, 16);
        }

        public int getId() {
            return this.id;
        }

        public static SupportedGroup fromId(int id) {
            for (SupportedGroup group : SupportedGroup.values()) {
                if (group.getId() != id) continue;
                return group;
            }
            return null;
        }

        public ECParameterSpec getEcParams() {
            return this.params;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public static SupportedGroup[] getUsableGroups() {
            ArrayList<SupportedGroup> result = new ArrayList<SupportedGroup>();
            for (SupportedGroup group : SupportedGroup.values()) {
                if (!group.isUsable()) continue;
                result.add(group);
            }
            return result.toArray(new SupportedGroup[result.size()]);
        }

        public static List<SupportedGroup> getPreferredGroups() {
            SupportedGroup usableGroup = null;
            ArrayList<SupportedGroup> result = new ArrayList<SupportedGroup>();
            block3: for (SupportedGroup group : SupportedGroup.values()) {
                switch (group) {
                    case secp256r1: 
                    case secp384r1: 
                    case secp521r1: {
                        if (!group.isUsable()) continue block3;
                        result.add(group);
                        continue block3;
                    }
                    default: {
                        if (usableGroup != null || !group.isUsable()) continue block3;
                        usableGroup = group;
                    }
                }
            }
            if (result.isEmpty() && usableGroup != null) {
                result.add(usableGroup);
            }
            return result;
        }
    }
}

