/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionExecutionListener;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.slf4j.MDC;

public class MdcConnectionListener
implements ConnectionExecutionListener,
ConnectionListener {
    @Override
    public void onConnectionEstablished(Connection connection) {
    }

    @Override
    public void onConnectionRemoved(Connection connection) {
    }

    @Override
    public void beforeExecution(Connection connection) {
        ConnectionId cid;
        InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            MDC.put((String)"PEER", (String)StringUtil.toString((InetSocketAddress)peerAddress));
        }
        if ((cid = connection.getConnectionId()) != null) {
            MDC.put((String)"CONNECTION_ID", (String)cid.getAsString());
        }
        SessionId sid = connection.getSessionIdentity();
        DTLSSession session = connection.getSession();
        if (session != null) {
            sid = session.getSessionIdentifier();
            ConnectionId writeConnectionId = session.getWriteConnectionId();
            if (writeConnectionId != null && !writeConnectionId.isEmpty()) {
                MDC.put((String)"WRITE_CONNECTION_ID", (String)writeConnectionId.getAsString());
            }
        }
        if (sid != null) {
            MDC.put((String)"SESSION_ID", (String)sid.toString());
        }
    }

    @Override
    public void updateExecution(Connection connection) {
        this.beforeExecution(connection);
    }

    @Override
    public void afterExecution(Connection connection) {
        MDC.clear();
    }
}

