/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.EndpointUnconnectedException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.AlertHandler;
import org.eclipse.californium.scandium.ConnectionExecutionListener;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.CookieGenerator;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.DtlsHealthLogger;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.AvailableConnections;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionEvictedException;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsException;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeException;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.InMemoryConnectionStore;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ResumingClientHandshaker;
import org.eclipse.californium.scandium.dtls.ResumingServerHandshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionAdapter;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DTLSConnector
implements Connector,
RecordLayer {
    public static final String KEY_TLS_SERVER_HOST_NAME = "TLS_SERVER_HOST_NAME";
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSConnector.class);
    private static final Logger DROP_LOGGER = LoggerFactory.getLogger((String)(LOGGER.getName() + ".drops"));
    private static final int MAX_PLAINTEXT_FRAGMENT_LENGTH = 16384;
    private static final int MAX_CIPHERTEXT_EXPANSION = CipherSuite.getOverallMaxCiphertextExpansion();
    private static final int MAX_DATAGRAM_BUFFER_SIZE = 16409 + MAX_CIPHERTEXT_EXPANSION;
    private static final int TLS12_CID_PADDING = 0;
    private static final long CLIENT_HELLO_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final boolean MDC_SUPPORT;
    protected final DtlsConnectorConfig config;
    private final ResumptionSupportingConnectionStore connectionStore;
    private final Long autoResumptionTimeoutMillis;
    private final int thresholdHandshakesWithoutVerifiedPeer;
    private final AtomicInteger pendingHandshakesWithoutVerifiedPeer = new AtomicInteger();
    protected final DtlsHealth health;
    private final boolean serverOnly;
    private final String defaultHandshakeMode;
    private final int useExtendedWindowFilter;
    private final boolean useFilter;
    private final boolean useCidUpdateAddressOnNewerRecordFilter;
    private final AtomicInteger pendingOutboundMessagesCountdown = new AtomicInteger();
    private final List<Thread> receiverThreads = new LinkedList<Thread>();
    protected final ConnectionIdGenerator connectionIdGenerator;
    private final ProtocolVersion protocolVersionForHelloVerifyRequests;
    private ScheduledFuture<?> statusLogger;
    private InetSocketAddress lastBindAddress;
    private Integer maximumTransmissionUnit;
    private int ipv4Mtu = 576;
    private int ipv6Mtu = 1280;
    protected int inboundDatagramBufferSize = MAX_DATAGRAM_BUFFER_SIZE;
    private CookieGenerator cookieGenerator = new CookieGenerator();
    private Object alertHandlerLock = new Object();
    private volatile DatagramSocket socket;
    protected ScheduledExecutorService timer;
    private AtomicBoolean running = new AtomicBoolean(false);
    private volatile EndpointContextMatcher endpointContextMatcher;
    private volatile RawDataChannel messageHandler;
    private AlertHandler alertHandler;
    private SessionListener sessionListener;
    private ConnectionExecutionListener connectionExecutionListener;
    private ExecutorService executorService;
    private boolean hasInternalExecutor;

    public DTLSConnector(DtlsConnectorConfig configuration) {
        this(configuration, (SessionCache)null);
    }

    public DTLSConnector(DtlsConnectorConfig configuration, SessionCache sessionCache) {
        this(configuration, DTLSConnector.createConnectionStore(configuration, sessionCache));
    }

    protected static ResumptionSupportingConnectionStore createConnectionStore(DtlsConnectorConfig configuration, SessionCache sessionCache) {
        return new InMemoryConnectionStore(configuration.getMaxConnections(), configuration.getStaleConnectionThreshold(), sessionCache).setTag(configuration.getLoggingTag());
    }

    protected DTLSConnector(DtlsConnectorConfig configuration, final ResumptionSupportingConnectionStore connectionStore) {
        long thresholdInPercent;
        NewAdvancedCertificateVerifier certificateVerifier;
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        if (connectionStore == null) {
            throw new NullPointerException("Connection store must not be null");
        }
        this.config = configuration;
        this.connectionIdGenerator = this.config.getConnectionIdGenerator();
        this.protocolVersionForHelloVerifyRequests = this.config.getProtocolVersionForHelloVerifyRequests();
        this.pendingOutboundMessagesCountdown.set(this.config.getOutboundMessageBufferSize());
        this.autoResumptionTimeoutMillis = this.config.getAutoResumptionTimeoutMillis();
        this.serverOnly = this.config.isServerOnly();
        this.defaultHandshakeMode = this.config.getDefaultHandshakeMode();
        this.useExtendedWindowFilter = this.config.useExtendedWindowFilter();
        this.useFilter = this.config.useAntiReplayFilter() != false || this.useExtendedWindowFilter != 0;
        this.useCidUpdateAddressOnNewerRecordFilter = this.config.useCidUpdateAddressOnNewerRecordFilter();
        this.connectionStore = connectionStore;
        this.connectionStore.attach(this.connectionIdGenerator);
        this.connectionStore.setConnectionListener(this.config.getConnectionListener());
        ConnectionListener listener = this.config.getConnectionListener();
        if (listener instanceof ConnectionExecutionListener) {
            this.connectionExecutionListener = (ConnectionExecutionListener)((Object)listener);
        }
        HandshakeResultHandler handler = new HandshakeResultHandler(){

            @Override
            public void apply(PskSecretResult secretResult) {
                DTLSConnector.this.processAsynchronousHandshakeResult(secretResult);
            }

            @Override
            public void apply(HandshakeResult connectionResult) {
                DTLSConnector.this.processAsynchronousHandshakeResult(connectionResult);
            }
        };
        AdvancedPskStore advancedPskStore = this.config.getAdvancedPskStore();
        if (advancedPskStore != null) {
            advancedPskStore.setResultHandler(handler);
        }
        if ((certificateVerifier = this.config.getAdvancedCertificateVerifier()) != null) {
            certificateVerifier.setResultHandler(handler);
        }
        DtlsHealth healthHandler = this.config.getHealthHandler();
        Integer healthStatusInterval = this.config.getHealthStatusInterval();
        if (healthHandler == null && healthStatusInterval != null && healthStatusInterval > 0 && !(healthHandler = this.createDefaultHealthHandler(this.config)).isEnabled()) {
            healthHandler = null;
        }
        this.health = healthHandler;
        this.sessionListener = new SessionAdapter(){

            @Override
            public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
                DTLSConnector.this.sessionEstablished(handshaker, establishedSession);
            }

            @Override
            public void handshakeCompleted(Handshaker handshaker) {
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(true);
                }
                final Connection connection = handshaker.getConnection();
                ScheduledExecutorService timer = DTLSConnector.this.timer;
                if (timer != null) {
                    try {
                        timer.schedule(new Runnable(){

                            @Override
                            public void run() {
                                connection.startByClientHello(null);
                            }
                        }, CLIENT_HELLO_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                        return;
                    }
                    catch (RejectedExecutionException ex) {
                        LOGGER.debug("stopping.");
                    }
                }
                connection.startByClientHello(null);
            }

            @Override
            public void handshakeFailed(Handshaker handshaker, Throwable error) {
                List<RawData> listOut;
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(false);
                }
                if (!(listOut = handshaker.takeDeferredApplicationData()).isEmpty()) {
                    LOGGER.debug("Handshake with [{}] failed, report error to deferred {} messages", (Object)handshaker.getPeerAddress(), (Object)listOut.size());
                    for (RawData message : listOut) {
                        message.onError(error);
                    }
                }
                Connection connection = handshaker.getConnection();
                if (handshaker.isRemovingConnection()) {
                    connectionStore.remove(connection, false);
                } else if (handshaker.isProbing()) {
                    LOGGER.debug("Handshake with [{}] failed within probe!", (Object)handshaker.getPeerAddress());
                } else if (connection.getEstablishedSession() == handshaker.getSession()) {
                    if (error instanceof HandshakeException) {
                        AlertMessage alert = ((HandshakeException)error).getAlert();
                        if (alert != null && alert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
                            LOGGER.debug("Handshake with [{}] closed after session was established!", (Object)handshaker.getPeerAddress());
                        } else {
                            LOGGER.warn("Handshake with [{}] failed after session was established! {}", (Object)handshaker.getPeerAddress(), (Object)alert);
                        }
                    } else if (error instanceof ConnectionEvictedException) {
                        LOGGER.debug("Handshake with [{}] never get APPLICATION_DATA", (Object)handshaker.getPeerAddress(), (Object)error);
                    } else {
                        LOGGER.warn("Handshake with [{}] failed after session was established!", (Object)handshaker.getPeerAddress(), (Object)error);
                    }
                } else if (connection.hasEstablishedSession()) {
                    LOGGER.warn("Handshake with [{}] failed, but has an established session!", (Object)handshaker.getPeerAddress());
                } else {
                    LOGGER.warn("Handshake with [{}] failed, connection preserved!", (Object)handshaker.getPeerAddress());
                }
            }
        };
        int maxConnections = this.config.getMaxConnections();
        long threshold = ((long)maxConnections * (thresholdInPercent = (long)this.config.getVerifyPeersOnResumptionThreshold().intValue()) + 50L) / 100L;
        if (threshold == 0L && thresholdInPercent > 0L) {
            threshold = 1L;
        }
        this.thresholdHandshakesWithoutVerifiedPeer = (int)threshold;
    }

    protected DtlsHealth createDefaultHealthHandler(DtlsConnectorConfig configuration) {
        return new DtlsHealthLogger(configuration.getLoggingTag());
    }

    private final void sessionEstablished(Handshaker handshaker, final DTLSSession establishedSession) throws HandshakeException {
        try {
            List<Record> listIn;
            final Connection connection = handshaker.getConnection();
            this.connectionStore.putEstablishedSession(establishedSession, connection);
            SerialExecutor serialExecutor = connection.getExecutor();
            List<RawData> listOut = handshaker.takeDeferredApplicationData();
            if (!listOut.isEmpty()) {
                LOGGER.trace("Session with [{}] established, now process deferred {} messages", (Object)establishedSession.getPeer(), (Object)listOut.size());
                Iterator<RawData> i$ = listOut.iterator();
                while (i$.hasNext()) {
                    RawData message;
                    final RawData rawData = message = i$.next();
                    serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DTLSConnector.this.sendMessage(rawData, connection, establishedSession);
                        }
                    });
                }
            }
            if (!(listIn = handshaker.takeDeferredRecords()).isEmpty()) {
                LOGGER.trace("Session with [{}] established, now process deferred {} messages", (Object)establishedSession.getPeer(), (Object)listIn.size());
                Iterator<Record> i$ = listIn.iterator();
                while (i$.hasNext()) {
                    Record message;
                    final Record record = message = i$.next();
                    serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DTLSConnector.this.processRecord(record, connection);
                        }
                    });
                }
            }
        }
        catch (RejectedExecutionException ex) {
            LOGGER.debug("stopping.");
        }
    }

    protected void onInitializeHandshaker(Handshaker handshaker) {
    }

    private final void initializeHandshaker(Handshaker handshaker) {
        if (this.sessionListener != null) {
            handshaker.addSessionListener(this.sessionListener);
            if (this.health != null) {
                this.health.startHandshake();
            }
        }
        this.onInitializeHandshaker(handshaker);
    }

    public final synchronized void setExecutor(ExecutorService executor) {
        if (this.executorService != executor) {
            if (this.running.get()) {
                throw new IllegalStateException("cannot set new executor while connector is running");
            }
            this.executorService = executor;
        }
    }

    public final void close(InetSocketAddress peerAddress) {
        final Connection connection = this.getConnection(peerAddress, null, false);
        if (connection != null && connection.hasEstablishedSession()) {
            SerialExecutor serialExecutor = connection.getExecutor();
            serialExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    DTLSSession session = connection.getEstablishedSession();
                    if (session != null) {
                        DTLSConnector.this.terminateConnection(connection, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, connection.getPeerAddress()), session);
                    }
                }
            });
        }
    }

    public final synchronized void start() throws IOException {
        this.start(this.config.getAddress());
    }

    final synchronized void restart() throws IOException {
        if (this.lastBindAddress == null) {
            throw new IllegalStateException("Connector has never been started before");
        }
        this.start(this.lastBindAddress);
    }

    private synchronized ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void start(InetSocketAddress bindAddress) throws IOException {
        if (this.running.get()) {
            return;
        }
        this.init(bindAddress, new DatagramSocket(null), this.config.getMaxTransmissionUnit());
    }

    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        Integer healthStatusInterval;
        this.socket = socket;
        this.pendingOutboundMessagesCountdown.set(this.config.getOutboundMessageBufferSize());
        if (bindAddress.getPort() != 0 && this.config.isAddressReuseEnabled().booleanValue()) {
            LOGGER.info("Enable address reuse for socket!");
            socket.setReuseAddress(true);
            if (!socket.getReuseAddress()) {
                LOGGER.warn("Enable address reuse for socket failed!");
            }
        }
        Integer size = this.config.getSocketReceiveBufferSize();
        try {
            if (size != null && size != 0) {
                socket.setReceiveBufferSize(size);
            }
            if ((size = this.config.getSocketSendBufferSize()) != null && size != 0) {
                socket.setSendBufferSize(size);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("failed to apply {}", (Object)size, (Object)ex);
        }
        int recvBuffer = socket.getReceiveBufferSize();
        int sendBuffer = socket.getSendBufferSize();
        if (!socket.isBound()) {
            socket.bind(bindAddress);
        }
        if (!(this.lastBindAddress == null || socket.getLocalAddress().equals(this.lastBindAddress.getAddress()) && socket.getLocalPort() == this.lastBindAddress.getPort())) {
            if (this.connectionStore instanceof ResumptionSupportingConnectionStore) {
                this.connectionStore.markAllAsResumptionRequired();
            } else {
                this.connectionStore.clear();
            }
        }
        if (this.config.getMaxFragmentLengthCode() != null) {
            MaxFragmentLengthExtension.Length lengthCode = MaxFragmentLengthExtension.Length.fromCode(this.config.getMaxFragmentLengthCode());
            this.inboundDatagramBufferSize = lengthCode.length() + MAX_CIPHERTEXT_EXPANSION + 25;
        }
        if (this.config.getMaxTransmissionUnit() != null) {
            this.maximumTransmissionUnit = this.config.getMaxTransmissionUnit();
            LOGGER.info("Configured MTU [{}]", (Object)this.maximumTransmissionUnit);
        } else if (mtu != null) {
            this.maximumTransmissionUnit = mtu;
            LOGGER.info("Forced MTU [{}]", (Object)this.maximumTransmissionUnit);
        } else {
            InetAddress localInterfaceAddress = bindAddress.getAddress();
            if (localInterfaceAddress.isAnyLocalAddress()) {
                this.ipv4Mtu = NetworkInterfacesUtil.getIPv4Mtu();
                this.ipv6Mtu = NetworkInterfacesUtil.getIPv6Mtu();
                LOGGER.info("multiple network interfaces, using smallest MTU [IPv4 {}, IPv6 {}]", (Object)this.ipv4Mtu, (Object)this.ipv6Mtu);
            } else {
                NetworkInterface ni = NetworkInterface.getByInetAddress(localInterfaceAddress);
                boolean ipv6 = localInterfaceAddress instanceof Inet6Address;
                if (ni != null && ni.getMTU() > 0) {
                    if (ipv6) {
                        this.ipv6Mtu = ni.getMTU();
                    } else {
                        this.ipv4Mtu = ni.getMTU();
                    }
                } else if (ipv6) {
                    this.ipv6Mtu = NetworkInterfacesUtil.getIPv6Mtu();
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv6 instead", (Object)this.ipv6Mtu);
                } else {
                    this.ipv4Mtu = NetworkInterfacesUtil.getIPv4Mtu();
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv4 instead", (Object)this.ipv4Mtu);
                }
            }
            if (this.inboundDatagramBufferSize > this.config.getMaxTransmissionUnitLimit()) {
                if (this.ipv4Mtu > this.config.getMaxTransmissionUnitLimit()) {
                    this.ipv4Mtu = this.config.getMaxTransmissionUnitLimit();
                    LOGGER.info("Limit MTU IPv4[{}]", (Object)this.ipv4Mtu);
                }
                if (this.ipv6Mtu > this.config.getMaxTransmissionUnitLimit()) {
                    this.ipv6Mtu = this.config.getMaxTransmissionUnitLimit();
                    LOGGER.info("Limit MTU IPv6[{}]", (Object)this.ipv6Mtu);
                }
            } else {
                if (this.ipv4Mtu > this.inboundDatagramBufferSize) {
                    this.ipv4Mtu = this.inboundDatagramBufferSize;
                    LOGGER.info("Buffersize MTU IPv4[{}]", (Object)this.ipv4Mtu);
                }
                if (this.ipv6Mtu > this.inboundDatagramBufferSize) {
                    this.ipv6Mtu = this.inboundDatagramBufferSize;
                    LOGGER.info("Buffersize MTU IPv6[{}]", (Object)this.ipv6Mtu);
                }
            }
        }
        this.lastBindAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
        this.timer = this.executorService instanceof ScheduledExecutorService ? (ScheduledExecutorService)this.executorService : ExecutorsUtil.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("DTLS-Timer-" + this.lastBindAddress + "#", NamedThreadFactory.SCANDIUM_THREAD_GROUP));
        if (this.executorService == null) {
            int threadCount = this.config.getConnectionThreadCount();
            this.executorService = threadCount > 1 ? ExecutorsUtil.newFixedThreadPool((int)(threadCount - 1), (ThreadFactory)new DaemonThreadFactory("DTLS-Worker-" + this.lastBindAddress + "#", NamedThreadFactory.SCANDIUM_THREAD_GROUP)) : this.timer;
            this.hasInternalExecutor = true;
        }
        this.running.set(true);
        int receiverThreadCount = this.config.getReceiverThreadCount();
        for (int i = 0; i < receiverThreadCount; ++i) {
            Worker receiver = new Worker("DTLS-Receiver-" + i + "-" + this.lastBindAddress){
                private final byte[] receiverBuffer;
                private final DatagramPacket packet;
                {
                    this.receiverBuffer = new byte[DTLSConnector.this.inboundDatagramBufferSize];
                    this.packet = new DatagramPacket(this.receiverBuffer, DTLSConnector.this.inboundDatagramBufferSize);
                }

                @Override
                public void doWork() throws Exception {
                    if (MDC_SUPPORT) {
                        MDC.clear();
                    }
                    this.packet.setData(this.receiverBuffer);
                    DTLSConnector.this.receiveNextDatagramFromNetwork(this.packet);
                }
            };
            receiver.setDaemon(true);
            receiver.start();
            this.receiverThreads.add(receiver);
        }
        String mtuDescription = this.maximumTransmissionUnit != null ? this.maximumTransmissionUnit.toString() : "IPv4 " + this.ipv4Mtu + " / IPv6 " + this.ipv6Mtu;
        LOGGER.info("DTLSConnector listening on {}, recv buf = {}, send buf = {}, recv packet size = {}, MTU = {}", new Object[]{this.lastBindAddress, recvBuffer, sendBuffer, this.inboundDatagramBufferSize, mtuDescription});
        if (this.health != null && this.health.isEnabled() && (healthStatusInterval = this.config.getHealthStatusInterval()) != null) {
            this.statusLogger = this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.health.dump(DTLSConnector.this.config.getLoggingTag(), DTLSConnector.this.config.getMaxConnections(), DTLSConnector.this.connectionStore.remainingCapacity(), DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.get());
                }
            }, healthStatusInterval.intValue(), healthStatusInterval.intValue(), TimeUnit.SECONDS);
        }
    }

    public final synchronized void forceResumeSessionFor(InetSocketAddress peer) {
        Connection peerConnection = this.connectionStore.get(peer);
        if (peerConnection != null && peerConnection.hasEstablishedSession()) {
            peerConnection.setResumptionRequired(true);
        }
    }

    public final synchronized void forceResumeAllSessions() {
        this.connectionStore.markAllAsResumptionRequired();
    }

    public final synchronized void clearConnectionState() {
        this.connectionStore.clear();
    }

    private final DatagramSocket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ExecutorService shutdownTimer = null;
        ExecutorService shutdown = null;
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        DTLSConnector dTLSConnector = this;
        synchronized (dTLSConnector) {
            if (this.running.compareAndSet(true, false)) {
                if (this.statusLogger != null) {
                    this.statusLogger.cancel(false);
                    this.statusLogger = null;
                }
                LOGGER.info("Stopping DTLS connector on [{}]", (Object)this.lastBindAddress);
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.maximumTransmissionUnit = null;
                this.ipv4Mtu = 576;
                this.ipv6Mtu = 1280;
                this.connectionStore.stop(pending);
                if (this.executorService != this.timer) {
                    pending.addAll(this.timer.shutdownNow());
                    shutdownTimer = this.timer;
                    this.timer = null;
                }
                if (this.hasInternalExecutor) {
                    pending.addAll(this.executorService.shutdownNow());
                    shutdown = this.executorService;
                    this.executorService = null;
                    this.hasInternalExecutor = false;
                }
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                    try {
                        t.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.receiverThreads.clear();
            }
        }
        if (shutdownTimer != null) {
            try {
                if (!shutdownTimer.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] timer not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (shutdown != null) {
            try {
                if (!shutdown.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] executor not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Runnable job : pending) {
            try {
                job.run();
            }
            catch (Exception e) {
                LOGGER.warn("Shutdown DTLS connector:", (Throwable)e);
            }
        }
    }

    public synchronized void destroy() {
        this.stop();
        this.connectionStore.clear();
        this.messageHandler = null;
    }

    public Future<Void> startDropConnectionsForPrincipal(final Principal principal) {
        if (principal == null) {
            throw new NullPointerException("principal must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Principal> handler = new LeastRecentlyUsedCache.Predicate<Principal>(){

            public boolean accept(Principal connectionPrincipal) {
                return principal.equals(connectionPrincipal);
            }
        };
        return this.startTerminateConnectionsForPrincipal(handler);
    }

    public Future<Void> startTerminateConnectionsForPrincipal(LeastRecentlyUsedCache.Predicate<Principal> principalHandler) {
        return this.startTerminateConnectionsForPrincipal(principalHandler, true);
    }

    public Future<Void> startTerminateConnectionsForPrincipal(final LeastRecentlyUsedCache.Predicate<Principal> principalHandler, final boolean removeFromSessionCache) {
        if (principalHandler == null) {
            throw new NullPointerException("principal handler must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Connection> connectionHandler = new LeastRecentlyUsedCache.Predicate<Connection>(){

            public boolean accept(Connection connection) {
                Principal peer = null;
                SessionTicket ticket = connection.getSessionTicket();
                if (ticket != null) {
                    peer = ticket.getClientIdentity();
                } else {
                    DTLSSession session = connection.getSession();
                    if (session != null) {
                        peer = session.getPeerIdentity();
                    }
                }
                if (peer != null && principalHandler.accept((Object)peer)) {
                    DTLSConnector.this.connectionStore.remove(connection, removeFromSessionCache);
                }
                return false;
            }
        };
        return this.startForEach(connectionHandler);
    }

    public Future<Void> startForEach(LeastRecentlyUsedCache.Predicate<Connection> handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null!");
        }
        ForEachFuture result = new ForEachFuture();
        this.nextForEach(this.connectionStore.iterator(), handler, result);
        return result;
    }

    private void nextForEach(final Iterator<Connection> iterator, final LeastRecentlyUsedCache.Predicate<Connection> handler, final ForEachFuture result) {
        block4: {
            if (!result.isStopped() && iterator.hasNext()) {
                final Connection next = iterator.next();
                try {
                    next.getExecutor().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean done = true;
                            try {
                                if (!result.isStopped() && !handler.accept((Object)next)) {
                                    done = false;
                                    DTLSConnector.this.nextForEach(iterator, (LeastRecentlyUsedCache.Predicate<Connection>)handler, result);
                                }
                            }
                            catch (Exception exception) {
                                result.failed(exception);
                            }
                            finally {
                                if (done) {
                                    result.done();
                                }
                            }
                        }
                    });
                    return;
                }
                catch (RejectedExecutionException ex) {
                    if (handler.accept((Object)next)) break block4;
                    while (iterator.hasNext() && !handler.accept((Object)iterator.next()) && !result.isStopped()) {
                    }
                }
            }
        }
        result.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection getConnection(InetSocketAddress peerAddress, ConnectionId cid, boolean create) {
        ExecutorService executor = this.getExecutorService();
        ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
        synchronized (resumptionSupportingConnectionStore) {
            Connection connection;
            if (cid != null) {
                connection = this.connectionStore.get(cid);
            } else {
                connection = this.connectionStore.get(peerAddress);
                if (connection == null && create) {
                    LOGGER.trace("create new connection for {}", (Object)peerAddress);
                    Connection newConnection = new Connection(peerAddress, new SerialExecutor((Executor)executor));
                    newConnection.setExecutionListener(this.connectionExecutionListener);
                    if (this.running.get() && !this.connectionStore.put(newConnection)) {
                        return null;
                    }
                    return newConnection;
                }
            }
            if (connection == null) {
                LOGGER.trace("no connection available for {},{}", (Object)peerAddress, (Object)cid);
            } else if (!connection.isExecuting() && this.running.get()) {
                LOGGER.trace("revive connection for {},{}", (Object)peerAddress, (Object)cid);
                connection.setExecutor(new SerialExecutor((Executor)executor));
            } else {
                LOGGER.trace("connection available for {},{}", (Object)peerAddress, (Object)cid);
            }
            return connection;
        }
    }

    protected void receiveNextDatagramFromNetwork(DatagramPacket packet) throws IOException {
        DatagramSocket currentSocket = this.getSocket();
        if (currentSocket == null) {
            return;
        }
        currentSocket.receive(packet);
        if (packet.getLength() == 0) {
            return;
        }
        this.processDatagram(packet);
    }

    @Deprecated
    protected void processDatagram(DatagramPacket packet) {
        this.processDatagram(packet, null);
    }

    protected void processDatagram(DatagramPacket packet, InetSocketAddress router) {
        InetSocketAddress peerAddress = (InetSocketAddress)packet.getSocketAddress();
        if (MDC_SUPPORT) {
            MDC.put((String)"PEER", (String)StringUtil.toString((InetSocketAddress)peerAddress));
        }
        if (this.health != null) {
            this.health.receivingRecord(false);
        }
        long timestamp = ClockUtil.nanoRealtime();
        if (peerAddress.getPort() == 0) {
            DROP_LOGGER.trace("Discarding record with {} bytes from [{}] without source-port", (Object)packet.getLength(), (Object)peerAddress);
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            return;
        }
        DatagramReader reader = new DatagramReader(packet.getData(), packet.getOffset(), packet.getLength());
        List<Record> records = Record.fromReader(reader, peerAddress, router, this.connectionIdGenerator, timestamp);
        LOGGER.trace("Received {} DTLS records from {} using a {} byte datagram buffer", new Object[]{records.size(), peerAddress, this.inboundDatagramBufferSize});
        if (records.isEmpty()) {
            DROP_LOGGER.trace("Discarding {} malicious record with {} bytes from [{}]", (Object)packet.getLength(), (Object)peerAddress);
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            return;
        }
        if (!this.running.get()) {
            DROP_LOGGER.trace("Discarding {} records, startting with {} from [{}] on shutdown", new Object[]{records.size(), records.get(0).getType(), peerAddress});
            LOGGER.debug("Execution shutdown while processing incoming records from peer: {}", (Object)peerAddress);
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            return;
        }
        final Record firstRecord = records.get(0);
        if (records.size() == 1 && firstRecord.isNewClientHello()) {
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    if (MDC_SUPPORT) {
                        MDC.put((String)"PEER", (String)StringUtil.toString((InetSocketAddress)firstRecord.getPeerAddress()));
                    }
                    DTLSConnector.this.processNewClientHello(firstRecord);
                    if (MDC_SUPPORT) {
                        MDC.clear();
                    }
                }
            });
            return;
        }
        ConnectionId connectionId = firstRecord.getConnectionId();
        final Connection connection = this.getConnection(peerAddress, connectionId, false);
        if (connection == null) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            if (connectionId == null) {
                DROP_LOGGER.trace("Discarding {} records from [{}] received without existing connection", (Object)records.size(), (Object)peerAddress);
            } else {
                DROP_LOGGER.trace("Discarding {} records from [{},{}] received without existing connection", new Object[]{records.size(), peerAddress, connectionId});
            }
            return;
        }
        SerialExecutor serialExecutor = connection.getExecutor();
        for (final Record record : records) {
            try {
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (DTLSConnector.this.running.get()) {
                            DTLSConnector.this.processRecord(record, connection);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                break;
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                this.terminateConnection(connection, e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                break;
            }
        }
    }

    @Override
    public void processRecord(Record record, Connection connection) {
        try {
            DTLSSession session;
            if (record.getConnectionId() == null && !connection.equalsPeerAddress(record.getPeerAddress())) {
                long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - record.getReceiveNanos());
                DROP_LOGGER.debug("Drop received record {}, connection changed address {} => {}! (shift {}ms)", new Object[]{record.getType(), record.getPeerAddress(), connection.getPeerAddress(), delay});
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            int epoch = record.getEpoch();
            LOGGER.trace("Received DTLS record of type [{}], length: {}, [epoche:{},rseqn:{}]", new Object[]{record.getType(), record.getFragmentLength(), epoch, record.getSequenceNumber()});
            Handshaker handshaker = connection.getOngoingHandshake();
            if (handshaker != null && handshaker.isExpired()) {
                handshaker.handshakeFailed(new Exception("handshake already expired!"));
                if (this.connectionStore.get(connection.getConnectionId()) != connection) {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from peer [{}], handshake expired!", new Object[]{record.getType(), epoch, record.getSequenceNumber(), record.getPeerAddress()});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
                handshaker = null;
            }
            if ((session = connection.getSession(epoch)) == null) {
                if (handshaker != null && handshaker.getSession().getReadEpoch() == 0 && epoch == 1) {
                    handshaker.addRecordsForDeferredProcessing(record);
                } else {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from peer [{}] without an active session", new Object[]{record.getType(), epoch, record.getSequenceNumber(), record.getPeerAddress()});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                }
                return;
            }
            boolean closed = connection.isClosed();
            boolean discard = (this.useFilter || closed) && session != null && !session.isRecordProcessable((long)epoch, record.getSequenceNumber(), this.useExtendedWindowFilter);
            if (discard |= closed && session == null) {
                if (closed) {
                    DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] received from closed peer [{}]", new Object[]{record.getType(), epoch, record.getSequenceNumber(), record.getPeerAddress()});
                } else {
                    DROP_LOGGER.debug("Discarding duplicate {} record [epoch {}, rseqn {}] received from peer [{}]", new Object[]{record.getType(), epoch, record.getSequenceNumber(), record.getPeerAddress()});
                }
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            if (record.getType() == ContentType.TLS12_CID) {
                if (epoch == 0) {
                    DROP_LOGGER.debug("Discarding TLS_CID record received from peer [{}] during handshake", (Object)record.getPeerAddress());
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
            } else if (epoch > 0 && connection.expectCid()) {
                DROP_LOGGER.debug("Discarding record received from peer [{}], CID required!", (Object)record.getPeerAddress());
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            if (!record.isDecoded() || record.getType() != ContentType.APPLICATION_DATA) {
                record.applySession(session);
            }
            if (handshaker != null && handshaker.isProbing()) {
                if (connection.hasEstablishedSession()) {
                    this.connectionStore.removeFromEstablishedSessions(connection.getEstablishedSession(), connection);
                }
                connection.resetSession();
                handshaker.resetProbing();
                LOGGER.trace("handshake probe successful {}", (Object)connection.getPeerAddress());
            }
            switch (record.getType()) {
                case APPLICATION_DATA: {
                    this.processApplicationDataRecord(record, connection);
                    break;
                }
                case ALERT: {
                    this.processAlertRecord(record, connection, session);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    this.processChangeCipherSpecRecord(record, connection);
                    break;
                }
                case HANDSHAKE: {
                    this.processHandshakeRecord(record, connection);
                    break;
                }
                default: {
                    DROP_LOGGER.debug("Discarding record of unsupported type [{}] from peer [{}]", (Object)record.getType(), (Object)record.getPeerAddress());
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.warn("Unexpected error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
            this.terminateConnection(connection, e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.debug("Discarding {} received from peer [{}] caused by {}", new Object[]{record.getType(), record.getPeerAddress(), e.getMessage()});
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.debug("error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
        }
        catch (HandshakeException e) {
            LOGGER.debug("error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
        }
    }

    private void terminateOngoingHandshake(Connection connection, HandshakeException cause) {
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Aborting handshake with peer [{}]:", (Object)connection.getPeerAddress(), (Object)cause);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Aborting handshake with peer [{}]: {}", (Object)connection.getPeerAddress(), (Object)cause.getMessage());
            }
            handshaker.setFailureCause(cause);
            AlertMessage causingAlert = cause.getAlert();
            DTLSSession session = handshaker.getSession();
            if (!connection.hasEstablishedSession()) {
                this.terminateConnection(connection, causingAlert, session);
            } else {
                if (connection.getEstablishedSession() == handshaker.getSession()) {
                    if (causingAlert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
                        LOGGER.debug("Handshake with [{}] closed after session was established!", (Object)handshaker.getPeerAddress());
                    } else {
                        LOGGER.warn("Handshake with [{}] failed after session was established! {}", (Object)handshaker.getPeerAddress(), (Object)causingAlert);
                    }
                } else {
                    LOGGER.warn("Handshake with [{}] failed, but has an established session!", (Object)handshaker.getPeerAddress());
                }
                this.send(causingAlert, session);
            }
            handshaker.handshakeFailed(cause);
        }
    }

    private void terminateConnection(Connection connection, Throwable cause, AlertMessage.AlertLevel level, AlertMessage.AlertDescription description) {
        if (connection.hasEstablishedSession()) {
            this.terminateConnection(connection, new AlertMessage(level, description, connection.getPeerAddress()), connection.getEstablishedSession());
        } else if (connection.hasOngoingHandshake()) {
            this.terminateConnection(connection, new AlertMessage(level, description, connection.getPeerAddress()), connection.getOngoingHandshake().getSession());
        }
    }

    private void terminateConnection(Connection connection, AlertMessage alert, DTLSSession session) {
        if (alert == null) {
            LOGGER.trace("Terminating connection with peer [{}]", (Object)connection.getPeerAddress());
        } else {
            if (session == null) {
                throw new IllegalArgumentException("Session must not be null, if alert message is to be sent");
            }
            LOGGER.trace("Terminating connection with peer [{}], reason [{}]", (Object)connection.getPeerAddress(), (Object)alert.getDescription());
            this.send(alert, session);
        }
        if (alert != null && alert.getLevel() == AlertMessage.AlertLevel.WARNING && alert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
            connection.setResumptionRequired(true);
        } else {
            this.connectionStore.remove(connection);
        }
    }

    private void processApplicationDataRecord(Record record, Connection connection) {
        Handshaker ongoingHandshake = connection.getOngoingHandshake();
        DTLSSession session = connection.getEstablishedSession();
        if (session != null && !connection.isResumptionRequired()) {
            ApplicationMessage message = (ApplicationMessage)record.getFragment();
            this.updateConnectionAddress(record, connection, session);
            RawDataChannel channel = this.messageHandler;
            if (channel != null) {
                InetSocketAddress peer = session.getPeer();
                if (peer == null) {
                    session.setPeer(record.getPeerAddress());
                }
                DtlsEndpointContext context = session.getConnectionReadContext();
                if (peer == null) {
                    session.setPeer(null);
                    LOGGER.debug("Received APPLICATION_DATA from deprecated {}", (Object)record.getPeerAddress());
                }
                LOGGER.trace("Received APPLICATION_DATA for {}", (Object)context);
                RawData receivedApplicationMessage = RawData.inbound((byte[])message.getData(), (EndpointContext)context, (boolean)false, (long)record.getReceiveNanos());
                channel.receiveData(receivedApplicationMessage);
            }
        } else if (ongoingHandshake != null) {
            ongoingHandshake.addRecordsForDeferredProcessing(record);
        } else {
            DROP_LOGGER.debug("Discarding APPLICATION_DATA record received from peer [{}]", (Object)record.getPeerAddress());
        }
    }

    private void processAlertRecord(Record record, Connection connection, DTLSSession session) {
        AlertMessage alert = (AlertMessage)record.getFragment();
        Handshaker handshaker = connection.getOngoingHandshake();
        HandshakeException error = null;
        LOGGER.trace("Processing {} ALERT from [{}]: {}", new Object[]{alert.getLevel(), alert.getPeer(), alert.getDescription()});
        if (AlertMessage.AlertDescription.CLOSE_NOTIFY.equals((Object)alert.getDescription())) {
            if (connection.hasEstablishedSession()) {
                this.updateConnectionAddress(record, connection, session);
            } else {
                error = new HandshakeException("Received 'close notify'", alert);
                if (handshaker != null) {
                    handshaker.setFailureCause(error);
                }
            }
            if (!connection.isResumptionRequired()) {
                if (session.getPeer() != null) {
                    this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, alert.getPeer()), session);
                }
                if (connection.hasEstablishedSession()) {
                    connection.close(record);
                } else {
                    this.connectionStore.remove(connection);
                }
            }
        } else if (AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
            error = new HandshakeException("Received 'fatal alert/" + (Object)((Object)alert.getDescription()) + "'", alert);
            if (handshaker != null) {
                handshaker.setFailureCause(error);
            }
            this.connectionStore.remove(connection);
        }
        this.handleAlertInternal(alert.getPeer(), alert, connection);
        if (null != error && null != handshaker) {
            handshaker.handshakeFailed(error);
        }
    }

    private void updateConnectionAddress(Record record, Connection connection, DTLSSession session) {
        InetSocketAddress newAddress = null;
        if (session.markRecordAsRead(record.getEpoch(), record.getSequenceNumber()) || !this.useCidUpdateAddressOnNewerRecordFilter) {
            connection.setRouter(record.getRouter());
            newAddress = record.getPeerAddress();
        }
        connection.refreshAutoResumptionTime();
        this.connectionStore.update(connection, newAddress);
        Handshaker ongoingHandshake = connection.getOngoingHandshake();
        if (ongoingHandshake != null) {
            ongoingHandshake.handshakeCompleted();
        }
    }

    private void processChangeCipherSpecRecord(Record record, Connection connection) {
        Handshaker ongoingHandshaker = connection.getOngoingHandshake();
        if (ongoingHandshaker != null) {
            try {
                ongoingHandshaker.processMessage(record);
            }
            catch (HandshakeException e) {
                this.handleExceptionDuringHandshake(e, connection, record);
            }
        } else {
            DROP_LOGGER.debug("Received CHANGE_CIPHER_SPEC record from peer [{}] with no handshake going on", (Object)record.getPeerAddress());
        }
    }

    private void processHandshakeRecord(Record record, Connection connection) {
        LOGGER.trace("Received {} record from peer [{}]", (Object)record.getType(), (Object)record.getPeerAddress());
        try {
            if (record.isNewClientHello()) {
                throw new IllegalArgumentException("new CLIENT_HELLO must be processed by processClientHello!");
            }
            HandshakeMessage handshakeMessage = (HandshakeMessage)record.getFragment();
            switch (handshakeMessage.getMessageType()) {
                case CLIENT_HELLO: {
                    DROP_LOGGER.debug("Reject re-negotiation from peer {}", (Object)record.getPeerAddress());
                    DTLSSession session = connection.getEstablishedSession();
                    this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION, record.getPeerAddress()), session);
                    break;
                }
                case HELLO_REQUEST: {
                    this.processHelloRequest(connection);
                    break;
                }
                default: {
                    Handshaker handshaker = connection.getOngoingHandshake();
                    if (handshaker != null) {
                        handshaker.processMessage(record);
                        break;
                    }
                    DROP_LOGGER.debug("Discarding HANDSHAKE message [epoch={}] from peer [{}], no ongoing handshake!", (Object)record.getEpoch(), (Object)record.getPeerAddress());
                    break;
                }
            }
        }
        catch (HandshakeException e) {
            this.handleExceptionDuringHandshake(e, connection, record);
        }
    }

    private void processHelloRequest(Connection connection) throws HandshakeException {
        if (connection.hasOngoingHandshake()) {
            DROP_LOGGER.debug("Ignoring HELLO_REQUEST received from [{}] while already in an ongoing handshake with peer", (Object)connection.getPeerAddress());
        } else {
            DTLSSession session = connection.getEstablishedSession();
            this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION, connection.getPeerAddress()), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewClientHello(final Record record) {
        block21: {
            InetSocketAddress peerAddress = record.getPeerAddress();
            if (LOGGER.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder("Processing new CLIENT_HELLO from peer [").append(peerAddress).append("]").append(":").append(StringUtil.lineSeparator()).append(record);
                LOGGER.trace(msg.toString());
            }
            try {
                Connection connection;
                record.applySession(null);
                DTLSMessage message = record.getFragment();
                if (message instanceof FragmentedHandshakeMessage) {
                    LOGGER.debug("Received unsupported fragmented CLIENT_HELLO from peer [{}].", (Object)peerAddress);
                    this.discardRecord(record, new DtlsException("Fragmented CLIENT_HELLO is not supported!", peerAddress));
                    return;
                }
                final ClientHello clientHello = (ClientHello)message;
                final AvailableConnections connections = new AvailableConnections();
                if (!this.isClientInControlOfSourceIpAddress(clientHello, record, connections)) break block21;
                boolean verify = false;
                ExecutorService executorService = this.getExecutorService();
                ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
                synchronized (resumptionSupportingConnectionStore) {
                    connection = this.connectionStore.get(peerAddress);
                    if (connection != null && !connection.isStartedByClientHello(clientHello)) {
                        Connection sessionConnection = connections.getConnectionBySessionId();
                        if (sessionConnection != null && sessionConnection != connection) {
                            verify = true;
                        } else {
                            DTLSSession establishedSession;
                            Handshaker handshaker;
                            if (sessionConnection != null && sessionConnection == connection) {
                                connections.setRemoveConnectionBySessionId(true);
                            }
                            if ((handshaker = connection.getOngoingHandshake()) != null && ((establishedSession = connection.getEstablishedSession()) == null || handshaker.getSession() != establishedSession)) {
                                final DtlsException cause = new DtlsException("Received new CLIENT_HELLO from " + StringUtil.toDisplayString((InetSocketAddress)peerAddress), peerAddress);
                                handshaker.setFailureCause(cause);
                                connection.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (DTLSConnector.this.running.get()) {
                                            handshaker.handshakeFailed(cause);
                                        }
                                    }
                                });
                            }
                            connection = null;
                        }
                    }
                    if (connection == null) {
                        connection = new Connection(peerAddress, new SerialExecutor((Executor)executorService));
                        connection.setExecutionListener(this.connectionExecutionListener);
                        connection.startByClientHello(clientHello);
                        if (!this.connectionStore.put(connection)) {
                            return;
                        }
                    }
                }
                if (verify) {
                    this.sendHelloVerify(clientHello, record, null);
                } else {
                    connections.setConnectionByAddress(connection);
                    try {
                        connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (DTLSConnector.this.running.get()) {
                                    DTLSConnector.this.processClientHello(clientHello, record, connections);
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                        this.terminateConnection(connections.getConnectionByAddress(), e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                    }
                }
            }
            catch (HandshakeException e) {
                LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
            catch (GeneralSecurityException e) {
                DROP_LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
        }
    }

    private void processClientHello(ClientHello clientHello, Record record, AvailableConnections connections) {
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        Connection connection = connections.getConnectionByAddress();
        if (connection == null) {
            throw new NullPointerException("connection by address must not be null!");
        }
        if (!connection.equalsPeerAddress(record.getPeerAddress())) {
            DROP_LOGGER.info("Drop received CLIENT_HELLO, changed address {} => {}!", (Object)record.getPeerAddress(), (Object)connection.getPeerAddress());
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder("Processing CLIENT_HELLO from peer [").append(record.getPeerAddress()).append("]").append(":").append(StringUtil.lineSeparator()).append(record);
            LOGGER.trace(msg.toString());
        }
        try {
            if (connection.hasEstablishedSession() || connection.getOngoingHandshake() != null) {
                DROP_LOGGER.debug("Discarding received duplicate CLIENT_HELLO message [epoch={}] from peer [{}]!", (Object)record.getEpoch(), (Object)record.getPeerAddress());
            } else if (clientHello.hasSessionId()) {
                this.resumeExistingSession(clientHello, record, connections);
            } else {
                this.startNewHandshake(clientHello, record, connection);
            }
        }
        catch (HandshakeException e) {
            this.handleExceptionDuringHandshake(e, connection, record);
        }
    }

    private boolean isClientInControlOfSourceIpAddress(ClientHello clientHello, Record record, AvailableConnections connections) {
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        try {
            byte[] expectedCookie = null;
            byte[] providedCookie = clientHello.getCookie();
            if (providedCookie.length > 0) {
                expectedCookie = this.cookieGenerator.generateCookie(clientHello);
                if (MessageDigest.isEqual(expectedCookie, providedCookie)) {
                    return true;
                }
                byte[] pastCookie = this.cookieGenerator.generatePastCookie(clientHello);
                if (pastCookie != null && MessageDigest.isEqual(pastCookie, providedCookie)) {
                    return true;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("provided cookie must {} match {}. Send verify request to {}", new Object[]{StringUtil.byteArray2HexString((byte[])providedCookie, (char)'\u0000', (int)6), StringUtil.byteArray2HexString((byte[])expectedCookie, (char)'\u0000', (int)6), record.getPeerAddress()});
                }
            } else if (0 < this.thresholdHandshakesWithoutVerifiedPeer) {
                int pending = this.pendingHandshakesWithoutVerifiedPeer.get();
                LOGGER.trace("pending fast resumptions [{}], threshold [{}]", (Object)pending, (Object)this.thresholdHandshakesWithoutVerifiedPeer);
                if (pending < this.thresholdHandshakesWithoutVerifiedPeer) {
                    SessionTicket ticket;
                    Connection sessionConnection = this.connectionStore.find(clientHello.getSessionId());
                    connections.setConnectionBySessionId(sessionConnection);
                    if (sessionConnection != null && this.verifySessionForResumption(clientHello, ticket = sessionConnection.hasEstablishedSession() ? sessionConnection.getEstablishedSession().getSessionTicket() : sessionConnection.getSessionTicket())) {
                        return true;
                    }
                }
            }
            this.sendHelloVerify(clientHello, record, expectedCookie);
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new DtlsHandshakeException("Cannot compute cookie for peer", AlertMessage.AlertDescription.INTERNAL_ERROR, AlertMessage.AlertLevel.FATAL, clientHello.getPeer(), e);
        }
    }

    private void startNewHandshake(ClientHello clientHello, Record record, Connection connection) throws HandshakeException {
        DTLSSession newSession = new DTLSSession(record.getPeerAddress(), record.getSequenceNumber());
        ServerHandshaker handshaker = new ServerHandshaker(clientHello.getMessageSeq(), newSession, this, this.timer, connection, this.config);
        this.initializeHandshaker(handshaker);
        handshaker.processMessage(record);
    }

    private void resumeExistingSession(ClientHello clientHello, Record record, AvailableConnections connections) throws HandshakeException {
        boolean ok;
        Connection previousConnection;
        InetSocketAddress peerAddress = record.getPeerAddress();
        LOGGER.trace("Client [{}] wants to resume session with ID [{}]", (Object)peerAddress, (Object)clientHello.getSessionId());
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        Connection connection = connections.getConnectionByAddress();
        if (connection == null) {
            throw new NullPointerException("connection by address must not be null!");
        }
        if (!connection.equalsPeerAddress(peerAddress)) {
            throw new IllegalArgumentException("connection must have records address!");
        }
        SessionTicket ticket = null;
        if (!connections.isConnectionBySessionIdKnown()) {
            connections.setConnectionBySessionId(this.connectionStore.find(clientHello.getSessionId()));
        }
        if ((previousConnection = connections.getConnectionBySessionId()) != null && previousConnection.isActive() && !(ok = this.verifySessionForResumption(clientHello, ticket = previousConnection.hasEstablishedSession() ? previousConnection.getEstablishedSession().getSessionTicket() : previousConnection.getSessionTicket())) && ticket != null) {
            SecretUtil.destroy(ticket);
            ticket = null;
        }
        if (ticket != null) {
            DTLSSession sessionToResume = new DTLSSession(clientHello.getSessionId(), peerAddress, ticket, record.getSequenceNumber());
            ResumingServerHandshaker handshaker = new ResumingServerHandshaker(clientHello.getMessageSeq(), sessionToResume, this, this.timer, connection, this.config);
            this.initializeHandshaker(handshaker);
            SecretUtil.destroy(ticket);
            if (previousConnection.hasEstablishedSession()) {
                if (connections.isRemoveConnectionBySessionId()) {
                    this.connectionStore.remove(previousConnection, false);
                } else if (clientHello.getCookie().length == 0) {
                    this.pendingHandshakesWithoutVerifiedPeer.incrementAndGet();
                    handshaker.addSessionListener(new SessionAdapter(){

                        @Override
                        public void sessionEstablished(Handshaker currentHandshaker, DTLSSession establishedSession) throws HandshakeException {
                            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
                        }

                        @Override
                        public void handshakeFailed(Handshaker handshaker, Throwable error) {
                            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
                        }
                    });
                }
            }
            handshaker.processMessage(record);
        } else {
            LOGGER.trace("Client [{}] tries to resume non-existing session [ID={}], performing full handshake instead ...", (Object)peerAddress, (Object)clientHello.getSessionId());
            this.startNewHandshake(clientHello, record, connection);
        }
    }

    private boolean verifySessionForResumption(ClientHello clientHello, SessionTicket ticket) {
        boolean ok = true;
        if (ticket != null && this.config.isSniEnabled().booleanValue()) {
            ServerNames serverNames1 = ticket.getServerNames();
            ServerNames serverNames2 = null;
            ServerNameExtension extension = clientHello.getServerNameExtension();
            if (extension != null) {
                serverNames2 = extension.getServerNames();
            }
            if (serverNames1 != null) {
                ok = serverNames1.equals(serverNames2);
            } else if (serverNames2 != null) {
                ok = false;
            }
        }
        return ok;
    }

    private void sendHelloVerify(ClientHello clientHello, Record record, byte[] expectedCookie) throws GeneralSecurityException {
        ProtocolVersion version;
        LOGGER.trace("Verifying client IP address [{}] using HELLO_VERIFY_REQUEST", (Object)record.getPeerAddress());
        if (expectedCookie == null) {
            expectedCookie = this.cookieGenerator.generateCookie(clientHello);
        }
        if ((version = this.protocolVersionForHelloVerifyRequests) == null) {
            version = clientHello.getClientVersion();
            if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_0) < 0) {
                version = ProtocolVersion.VERSION_DTLS_1_0;
            } else if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_2) > 0) {
                version = ProtocolVersion.VERSION_DTLS_1_2;
            }
        }
        HelloVerifyRequest msg = new HelloVerifyRequest(version, expectedCookie, record.getPeerAddress());
        msg.setMessageSeq(clientHello.getMessageSeq());
        Record helloVerify = new Record(ContentType.HANDSHAKE, version, record.getSequenceNumber(), msg, record.getPeerAddress());
        try {
            this.sendRecord(helloVerify);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void send(AlertMessage alert, DTLSSession session) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be NULL");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must not be NULL");
        }
        try {
            LOGGER.trace("send ALERT {} for peer {}.", (Object)alert, (Object)session.getPeer());
            boolean useCid = session.getWriteEpoch() > 0;
            Record record = useCid || alert.getProtocolVersion() == null ? new Record(ContentType.ALERT, session.getWriteEpoch(), session.getSequenceNumber(), alert, session, useCid, 0) : new Record(ContentType.ALERT, alert.getProtocolVersion(), session.getSequenceNumber(), alert, session.getPeer());
            this.sendRecord(record);
        }
        catch (IOException record) {
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.warn("Cannot create ALERT message for peer [{}]", (Object)session.getPeer(), (Object)e);
        }
    }

    public void send(final RawData message) {
        Connection connection;
        if (message == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (this.health != null) {
            this.health.sendingRecord(false);
        }
        if (message.isMulticast()) {
            DROP_LOGGER.warn("DTLSConnector drops {} outgoing bytes to multicast {}:{}", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
            message.onError((Throwable)new MulticastNotSupportedException("DTLS doesn't support multicast!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        if (message.getInetSocketAddress().getPort() == 0) {
            String destination = StringUtil.toString((InetSocketAddress)message.getInetSocketAddress());
            DROP_LOGGER.warn("DTLSConnector drops {} outgoing bytes to [{}] without destination-port", (Object)message.getSize(), (Object)destination);
            message.onError((Throwable)new IOException("CoAPs message to " + destination + " dropped, destination port 0!"));
            return;
        }
        RuntimeException error = null;
        if (!this.running.get()) {
            connection = null;
            error = new IllegalStateException("connector must be started before sending messages is possible");
        } else if (message.getSize() > 16384) {
            connection = null;
            error = new IllegalArgumentException("Message data must not exceed 16384 bytes");
        } else {
            boolean create;
            boolean bl = create = !this.serverOnly;
            if (create) {
                boolean bl2 = create = !this.getEffectiveHandshakeMode(message).equals("none");
            }
            if ((connection = this.getConnection(message.getInetSocketAddress(), null, create)) == null) {
                if (create) {
                    error = new IllegalStateException("connection store is exhausted!");
                } else {
                    if (this.serverOnly) {
                        message.onError((Throwable)new EndpointUnconnectedException("server only, connection missing!"));
                    } else {
                        message.onError((Throwable)new EndpointUnconnectedException("connection missing!"));
                    }
                    DROP_LOGGER.debug("DTLSConnector drops {} outgoing bytes to {}:{}, connection missing!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
            }
        }
        if (error != null) {
            DROP_LOGGER.debug("DTLSConnector drops {} outgoing bytes to {}:{}, {}!", new Object[]{message.getSize(), message.getAddress(), message.getPort(), error.getMessage()});
            message.onError((Throwable)error);
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            throw error;
        }
        final long now = ClockUtil.nanoRealtime();
        if (this.pendingOutboundMessagesCountdown.decrementAndGet() >= 0) {
            try {
                SerialExecutor executor = connection.getExecutor();
                if (executor == null) {
                    throw new NullPointerException("missing executor for connection! " + connection.getPeerAddress());
                }
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (DTLSConnector.this.running.get()) {
                                DTLSConnector.this.sendMessage(now, message, connection);
                            } else {
                                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, connector not running!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                                message.onError((Throwable)new InterruptedIOException("Connector is not running."));
                                if (DTLSConnector.this.health != null) {
                                    DTLSConnector.this.health.sendingRecord(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DTLSConnector.this.running.get()) {
                                LOGGER.warn("Exception thrown by executor thread [{}]", (Object)Thread.currentThread().getName(), (Object)e);
                            }
                            DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, {}", new Object[]{message.getSize(), message.getAddress(), message.getPort(), e.getMessage()});
                            if (DTLSConnector.this.health != null) {
                                DTLSConnector.this.health.sendingRecord(true);
                            }
                            message.onError((Throwable)e);
                        }
                        finally {
                            DTLSConnector.this.pendingOutboundMessagesCountdown.incrementAndGet();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while sending application record [peer: {}]", (Object)message.getInetSocketAddress(), (Object)e);
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, {}", new Object[]{message.getSize(), message.getAddress(), message.getPort(), e.getMessage()});
                message.onError((Throwable)new InterruptedIOException("Connector is not running."));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
            }
        } else {
            this.pendingOutboundMessagesCountdown.incrementAndGet();
            DROP_LOGGER.warn("Outbound message overflow! Dropping outbound message to peer [{}]", (Object)message.getInetSocketAddress());
            message.onError((Throwable)new IllegalStateException("Outbound message overflow!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
        }
    }

    private void sendMessage(long nanos, RawData message, Connection connection) throws HandshakeException {
        if (connection.getPeerAddress() == null) {
            long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - nanos);
            DROP_LOGGER.info("Drop outgoing record with {} bytes, connection lost address {}! (shift {}ms)", new Object[]{message.getSize(), message.getInetSocketAddress(), delay});
            message.onError((Throwable)new EndpointUnconnectedException("connection not longer assigned to address!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        LOGGER.trace("Sending application layer message to [{}]", (Object)message.getEndpointContext());
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null && !handshaker.hasSessionEstablished()) {
            if (handshaker.isExpired()) {
                handshaker.handshakeAborted(new Exception("handshake already expired!"));
            } else if (handshaker.isProbing()) {
                if (this.checkOutboundEndpointContext(message, null)) {
                    message.onConnecting();
                    handshaker.addApplicationDataForDeferredProcessing(message);
                }
                return;
            }
        }
        if (connection.isActive() && !connection.isClosed()) {
            this.sendMessageWithSession(message, connection);
        } else {
            this.sendMessageWithoutSession(message, connection);
        }
    }

    private void sendMessageWithoutSession(RawData message, Connection connection) throws HandshakeException {
        if (!this.checkOutboundEndpointContext(message, null)) {
            return;
        }
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker == null) {
            if (this.serverOnly) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, server only, connection missing!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                message.onError((Throwable)new EndpointUnconnectedException("server only, connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            boolean none = this.getEffectiveHandshakeMode(message).contentEquals("none");
            if (none) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, connection missing!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                message.onError((Throwable)new EndpointUnconnectedException("connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            DTLSSession session = new DTLSSession(message.getInetSocketAddress());
            session.setHostName(message.getEndpointContext().getVirtualHost());
            handshaker = new ClientHandshaker(session, this, this.timer, connection, this.config, false);
            this.initializeHandshaker(handshaker);
            message.onConnecting();
            handshaker.addApplicationDataForDeferredProcessing(message);
            handshaker.startHandshake();
        } else {
            message.onConnecting();
            handshaker.addApplicationDataForDeferredProcessing(message);
        }
    }

    private void sendMessageWithSession(RawData message, Connection connection) throws HandshakeException {
        DTLSSession session = connection.getEstablishedSession();
        boolean markedAsClosed = session != null && session.isMarkedAsClosed();
        String handshakeMode = this.getEffectiveHandshakeMode(message);
        boolean none = "none".equals(handshakeMode);
        if (none) {
            if (markedAsClosed || connection.isResumptionRequired()) {
                DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, resumption required!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                message.onError((Throwable)new EndpointUnconnectedException("resumption required!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
        } else {
            boolean force;
            boolean probing = "probe".equals(handshakeMode);
            boolean full = "full".equals(handshakeMode);
            boolean bl = force = probing || full || "force".equals(handshakeMode);
            if (force || markedAsClosed || connection.isAutoResumptionRequired(this.getAutResumptionTimeout(message))) {
                ClientHandshaker newHandshaker;
                if (this.serverOnly) {
                    DROP_LOGGER.trace("DTLSConnector drops {} outgoing bytes to {}:{}, server only, resumption requested failed!", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
                    message.onError((Throwable)new EndpointUnconnectedException("server only, resumption requested failed!"));
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
                message.onConnecting();
                Handshaker previousHandshaker = connection.getOngoingHandshake();
                SessionTicket ticket = null;
                SessionId sessionId = null;
                if (!full && !(full = (sessionId = session != null ? session.getSessionIdentifier() : connection.getSessionIdentity()).isEmpty())) {
                    if (session != null) {
                        try {
                            ticket = session.getSessionTicket();
                        }
                        catch (IllegalStateException ex) {
                            LOGGER.debug("Not possible to resume incomplete session!");
                        }
                    } else {
                        ticket = connection.getSessionTicket();
                    }
                }
                if (session != null) {
                    if (!probing) {
                        this.connectionStore.removeFromEstablishedSessions(session, connection);
                    }
                } else {
                    probing = false;
                }
                if (probing) {
                    connection.setResumptionRequired(false);
                } else {
                    connection.resetSession();
                }
                if (ticket == null) {
                    DTLSSession newSession = new DTLSSession(message.getInetSocketAddress());
                    newSession.setHostName(message.getEndpointContext().getVirtualHost());
                    newHandshaker = new ClientHandshaker(newSession, this, this.timer, connection, this.config, probing);
                } else {
                    DTLSSession resumableSession = new DTLSSession(sessionId, message.getInetSocketAddress(), ticket, 0L);
                    SecretUtil.destroy(ticket);
                    resumableSession.setHostName(message.getEndpointContext().getVirtualHost());
                    newHandshaker = new ResumingClientHandshaker(resumableSession, this, this.timer, connection, this.config, probing);
                }
                this.initializeHandshaker(newHandshaker);
                if (previousHandshaker != null) {
                    newHandshaker.takeDeferredApplicationData(previousHandshaker);
                    previousHandshaker.handshakeAborted(new Exception("handshake replaced!"));
                }
                newHandshaker.addApplicationDataForDeferredProcessing(message);
                ((Handshaker)newHandshaker).startHandshake();
                return;
            }
        }
        this.sendMessage(message, connection, session);
    }

    private void sendMessage(RawData message, Connection connection, DTLSSession session) {
        try {
            LOGGER.trace("send {}-{} using {}-{}", new Object[]{connection.getConnectionId(), connection.getPeerAddress(), session.getSessionIdentifier(), session.getPeer()});
            DtlsEndpointContext ctx = session.getConnectionWriteContext();
            if (!this.checkOutboundEndpointContext(message, (EndpointContext)ctx)) {
                return;
            }
            message.onContextEstablished((EndpointContext)ctx);
            Record record = new Record(ContentType.APPLICATION_DATA, session.getWriteEpoch(), session.getSequenceNumber(), new ApplicationMessage(message.getBytes(), message.getInetSocketAddress()), session, true, 0);
            this.sendRecord(record);
            message.onSent();
            connection.refreshAutoResumptionTime();
        }
        catch (IOException e) {
            message.onError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            DROP_LOGGER.warn("Cannot send APPLICATION record to peer [{}]", (Object)message.getInetSocketAddress(), (Object)e);
            message.onError((Throwable)e);
        }
    }

    private boolean checkOutboundEndpointContext(RawData message, EndpointContext connectionContext) {
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(message.getEndpointContext(), connectionContext)) {
            if (DROP_LOGGER.isInfoEnabled()) {
                DROP_LOGGER.info("DTLSConnector ({}) drops {} bytes outgoing, {} != {}", new Object[]{this, message.getSize(), endpointMatcher.toRelevantState(message.getEndpointContext()), endpointMatcher.toRelevantState(connectionContext)});
            }
            message.onError((Throwable)new EndpointMismatchException());
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return false;
        }
        return true;
    }

    public final DTLSSession getSessionByAddress(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        Connection connection = this.connectionStore.get(address);
        if (connection != null) {
            return connection.getEstablishedSession();
        }
        return null;
    }

    @Override
    public void dropReceivedRecord(Record record) {
        DROP_LOGGER.debug("Discarding {} record [epoch {}, rseqn {}] dropped by handshaker for peer [{}]", new Object[]{record.getType(), record.getEpoch(), record.getSequenceNumber(), record.getPeerAddress()});
        if (this.health != null) {
            this.health.receivingRecord(true);
        }
    }

    @Override
    public int getMaxDatagramSize(boolean ipv6) {
        int headerSize;
        int n = headerSize = ipv6 ? 128 : 64;
        int mtu = this.maximumTransmissionUnit != null ? this.maximumTransmissionUnit : (ipv6 ? this.ipv6Mtu : this.ipv4Mtu);
        int size = mtu - headerSize;
        if (size < 64) {
            throw new IllegalStateException(String.format("%s, datagram size %d, mtu %d", ipv6 ? "IPV6" : "IPv4", size, mtu));
        }
        return mtu - headerSize;
    }

    @Override
    @NoPublicAPI
    public void sendFlight(List<DatagramPacket> datagrams) throws IOException {
        for (DatagramPacket datagramPacket : datagrams) {
            if (this.health != null) {
                this.health.sendingRecord(false);
            }
            this.sendNextDatagramOverNetwork(datagramPacket);
        }
    }

    protected void sendRecord(Record record) throws IOException {
        if (this.health != null && record.getType() != ContentType.APPLICATION_DATA) {
            this.health.sendingRecord(false);
        }
        byte[] recordBytes = record.toByteArray();
        DatagramPacket datagram = new DatagramPacket(recordBytes, recordBytes.length, record.getPeerAddress());
        this.sendNextDatagramOverNetwork(datagram);
    }

    protected void sendNextDatagramOverNetwork(DatagramPacket datagramPacket) throws IOException {
        InetSocketAddress address;
        block8: {
            DatagramSocket socket = this.getSocket();
            if (socket != null && !socket.isClosed()) {
                if (datagramPacket.getPort() == 0) {
                    String destination = StringUtil.toString((InetSocketAddress)((InetSocketAddress)datagramPacket.getSocketAddress()));
                    DROP_LOGGER.trace("Discarding record with {} bytes to [{}] without destination-port", (Object)datagramPacket.getLength(), (Object)destination);
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    throw new IOException("DTLS Record to " + destination + " dropped, destination port 0!");
                }
                try {
                    socket.send(datagramPacket);
                    return;
                }
                catch (PortUnreachableException e) {
                    if (!socket.isClosed()) {
                        LOGGER.warn("Could not send record, destination {} unreachable!", (Object)StringUtil.toString((InetSocketAddress)((InetSocketAddress)datagramPacket.getSocketAddress())));
                    }
                }
                catch (IOException e) {
                    if (socket.isClosed()) break block8;
                    LOGGER.warn("Could not send record", (Throwable)e);
                    throw e;
                }
            }
        }
        if ((address = this.lastBindAddress) == null) {
            address = this.config.getAddress();
        }
        DROP_LOGGER.debug("Socket [{}] is closed, discarding packet ...", (Object)address);
        throw new IOException("Socket closed.");
    }

    private void processAsynchronousHandshakeResult(final HandshakeResult handshakeResult) {
        final Connection connection = this.connectionStore.get(handshakeResult.getConnectionId());
        if (connection != null && connection.hasOngoingHandshake()) {
            SerialExecutor serialExecutor = connection.getExecutor();
            try {
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (DTLSConnector.this.running.get()) {
                            Handshaker handshaker = connection.getOngoingHandshake();
                            if (handshaker != null) {
                                try {
                                    handshaker.processAsyncHandshakeResult(handshakeResult);
                                }
                                catch (HandshakeException e) {
                                    DTLSConnector.this.handleExceptionDuringHandshake(e, connection, null);
                                }
                                catch (IllegalStateException e) {
                                    LOGGER.warn("Exception while processing handshake result [{}]", (Object)connection, (Object)e);
                                }
                            } else {
                                LOGGER.debug("No ongoing handshake for result [{}]", (Object)connection);
                            }
                        } else {
                            LOGGER.debug("Execution stopped while processing handshake result [{}]", (Object)connection);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while processing handshake result [{}]", (Object)connection, (Object)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unexpected error occurred while processing handshake result [{}]", (Object)connection, (Object)e);
            }
        } else {
            LOGGER.debug("No connection or ongoing handshake for handshake result [{}]", (Object)connection);
        }
    }

    private Long getAutResumptionTimeout(RawData message) {
        Long timeout = this.autoResumptionTimeoutMillis;
        String contextTimeout = message.getEndpointContext().get("*DTLS_RESUMPTION_TIMEOUT");
        if (contextTimeout != null) {
            if (contextTimeout.isEmpty()) {
                timeout = null;
            } else {
                try {
                    timeout = Long.valueOf(contextTimeout);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }

    @Deprecated
    public final int getMaximumTransmissionUnit() {
        return this.maximumTransmissionUnit;
    }

    public final int getMaximumFragmentLength(InetSocketAddress peer) {
        Connection con = this.connectionStore.get(peer);
        if (con != null && con.hasEstablishedSession()) {
            return con.getEstablishedSession().getMaxFragmentLength();
        }
        return this.getMaxDatagramSize(peer.getAddress() instanceof Inet6Address) - 25;
    }

    public final InetSocketAddress getAddress() {
        int localPort;
        DatagramSocket socket = this.getSocket();
        int n = localPort = socket == null ? -1 : socket.getLocalPort();
        if (localPort < 0) {
            return this.config.getAddress();
        }
        return new InetSocketAddress(socket.getLocalAddress(), localPort);
    }

    @Override
    public final boolean isRunning() {
        return this.running.get();
    }

    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.isRunning()) {
            throw new IllegalStateException("message handler cannot be set on running connector");
        }
        this.messageHandler = messageHandler;
    }

    public void setEndpointContextMatcher(EndpointContextMatcher endpointContextMatcher) {
        this.endpointContextMatcher = endpointContextMatcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    private String getEffectiveHandshakeMode(RawData message) {
        String mode = message.getEndpointContext().get("*DTLS_HANDSHAKE_MODE");
        if (mode == null) {
            mode = this.defaultHandshakeMode;
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlertHandler(AlertHandler handler) {
        Object object = this.alertHandlerLock;
        synchronized (object) {
            this.alertHandler = handler;
        }
    }

    private void handleExceptionDuringHandshake(HandshakeException cause, Connection connection, Record record) {
        AlertMessage alert = cause.getAlert();
        if (!AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
            if (record != null) {
                this.discardRecord(record, cause);
            }
            this.handleAlertInternal(alert.getPeer(), alert, connection);
            return;
        }
        if (AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY.equals((Object)alert.getDescription())) {
            if (record != null) {
                this.discardRecord(record, cause);
            }
            this.handleAlertInternal(alert.getPeer(), alert, connection);
            return;
        }
        this.terminateOngoingHandshake(connection, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAlertInternal(InetSocketAddress peer, AlertMessage alert, Connection connection) {
        if (connection.getRootCauseAlert() == null) {
            AlertHandler handler;
            connection.setRootCause(alert);
            Object object = this.alertHandlerLock;
            synchronized (object) {
                handler = this.alertHandler;
            }
            if (handler != null) {
                handler.onAlert(peer, alert);
            }
        }
    }

    private void discardRecord(Record record, Throwable cause) {
        if (this.health != null) {
            this.health.receivingRecord(true);
        }
        byte[] bytes = record.getFragmentBytes();
        if (DROP_LOGGER.isTraceEnabled()) {
            String hexString = StringUtil.byteArray2HexString((byte[])bytes, (char)'\u0000', (int)64);
            DROP_LOGGER.trace("Discarding received {} record (epoch {}, payload: {}) from peer [{}]: ", new Object[]{record.getType(), record.getEpoch(), hexString, record.getPeerAddress(), cause});
        } else if (DROP_LOGGER.isDebugEnabled()) {
            String hexString = StringUtil.byteArray2HexString((byte[])bytes, (char)'\u0000', (int)16);
            DROP_LOGGER.debug("Discarding received {} record (epoch {}, payload: {}) from peer [{}]: {}", new Object[]{record.getType(), record.getEpoch(), hexString, record.getPeerAddress(), cause.getMessage()});
        }
    }

    public String getProtocol() {
        return "DTLS";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString((InetSocketAddress)this.getAddress());
    }

    static {
        boolean mdc = false;
        try {
            MDC.clear();
            mdc = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MDC_SUPPORT = mdc;
    }

    private static class ForEachFuture
    implements Future<Void> {
        private final Lock lock = new ReentrantLock();
        private final Condition waitDone = this.lock.newCondition();
        private volatile boolean cancel;
        private volatile boolean done;
        private volatile Exception exception;

        private ForEachFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            this.lock.lock();
            try {
                if (!this.done && !this.cancel) {
                    cancelled = true;
                    this.cancel = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await(timeout, unit);
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.lock.lock();
            try {
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception exception) {
            this.lock.lock();
            try {
                this.exception = exception;
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isStopped() {
            return this.done || this.cancel;
        }
    }

    protected abstract class Worker
    extends Thread {
        protected Worker(String name) {
            super(NamedThreadFactory.SCANDIUM_THREAD_GROUP, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Starting worker thread [{}]", (Object)this.getName());
                while (DTLSConnector.this.running.get()) {
                    try {
                        this.doWork();
                    }
                    catch (InterruptedIOException e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.info("Worker thread [{}] IO has been interrupted", (Object)this.getName());
                            continue;
                        }
                        LOGGER.debug("Worker thread [{}] IO has been interrupted", (Object)this.getName());
                    }
                    catch (InterruptedException e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.info("Worker thread [{}] has been interrupted", (Object)this.getName());
                            continue;
                        }
                        LOGGER.debug("Worker thread [{}] has been interrupted", (Object)this.getName());
                    }
                    catch (Exception e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.debug("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                            continue;
                        }
                        LOGGER.trace("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                    }
                }
            }
            finally {
                LOGGER.info("Worker thread [{}] has terminated", (Object)this.getName());
            }
        }

        protected abstract void doWork() throws Exception;
    }
}

