/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.scandium.util.SecretUtil;

public final class PseudoRandomFunction {
    private PseudoRandomFunction() {
    }

    static byte[] doPRF(Mac hmac, SecretKey secret, byte[] label, byte[] seed, int length) {
        try {
            hmac.init(secret);
            byte[] prf = PseudoRandomFunction.doExpansion(hmac, label, seed, length);
            hmac.reset();
            return prf;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Cannot run Pseudo Random Function with invalid key", e);
        }
    }

    public static final byte[] doPRF(Mac hmac, SecretKey secret, Label label, byte[] seed) {
        return PseudoRandomFunction.doPRF(hmac, secret, label.getBytes(), seed, label.length());
    }

    public static final byte[] doPRF(Mac hmac, SecretKey secret, Label label, byte[] seed, int length) {
        return PseudoRandomFunction.doPRF(hmac, secret, label.getBytes(), seed, length);
    }

    static final byte[] doExpansion(Mac hmac, byte[] label, byte[] seed, int length) {
        int offset = 0;
        int macLength = hmac.getMacLength();
        byte[] aAndSeed = new byte[macLength + label.length + seed.length];
        byte[] expansion = new byte[length];
        try {
            System.arraycopy(label, 0, aAndSeed, macLength, label.length);
            System.arraycopy(seed, 0, aAndSeed, macLength + label.length, seed.length);
            hmac.update(label);
            hmac.update(seed);
            while (true) {
                hmac.doFinal(aAndSeed, 0);
                hmac.update(aAndSeed);
                int nextOffset = offset + macLength;
                if (nextOffset > length) {
                    hmac.doFinal(aAndSeed, 0);
                    System.arraycopy(aAndSeed, 0, expansion, offset, length - offset);
                } else {
                    hmac.doFinal(expansion, offset);
                    if (nextOffset != length) {
                        offset = nextOffset;
                        hmac.update(aAndSeed, 0, macLength);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        return expansion;
    }

    public static SecretKey generateMasterSecret(Mac hmac, SecretKey premasterSecret, byte[] seed, boolean extended) {
        byte[] secret = PseudoRandomFunction.doPRF(hmac, premasterSecret, extended ? Label.EXTENDED_MASTER_SECRET_LABEL : Label.MASTER_SECRET_LABEL, seed);
        SecretKey masterSecret = SecretUtil.create(secret, "MAC");
        Bytes.clear((byte[])secret);
        return masterSecret;
    }

    public static SecretKey generatePremasterSecretFromPSK(SecretKey otherSecret, SecretKey pskSecret) {
        byte[] pskBytes = pskSecret.getEncoded();
        int pskLength = pskBytes.length;
        byte[] otherBytes = otherSecret != null ? otherSecret.getEncoded() : new byte[pskLength];
        DatagramWriter writer = new DatagramWriter(otherBytes.length + pskLength + 4, true);
        writer.writeVarBytes(otherBytes, 16);
        writer.writeVarBytes(pskBytes, 16);
        byte[] secret = writer.toByteArray();
        writer.close();
        SecretKey premaster = SecretUtil.create(secret, "MAC");
        Bytes.clear((byte[])pskBytes);
        Bytes.clear((byte[])otherBytes);
        Bytes.clear((byte[])secret);
        return premaster;
    }

    public static enum Label {
        MASTER_SECRET_LABEL("master secret", 48),
        KEY_EXPANSION_LABEL("key expansion", 128),
        CLIENT_FINISHED_LABEL("client finished", 12),
        SERVER_FINISHED_LABEL("server finished", 12),
        EXTENDED_MASTER_SECRET_LABEL("extended master secret", 48);

        private final String value;
        private final byte[] bytesValue;
        private final int length;

        private Label(String value, int length) {
            this.value = value;
            this.bytesValue = value.getBytes(StandardCharsets.UTF_8);
            this.length = length;
        }

        public String value() {
            return this.value;
        }

        private byte[] getBytes() {
            return this.bytesValue;
        }

        public int length() {
            return this.length;
        }
    }
}

