/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.RenegotiationInfoExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HelloExtension {
    @Deprecated
    protected static final Logger LOGGER = LoggerFactory.getLogger(HelloExtension.class);
    public static final int TYPE_BITS = 16;
    public static final int LENGTH_BITS = 16;
    private final ExtensionType type;

    protected HelloExtension(ExtensionType type) {
        if (type == null) {
            throw new NullPointerException("extension type must not be null!");
        }
        this.type = type;
    }

    protected abstract int getExtensionLength();

    protected abstract void writeExtensionTo(DatagramWriter var1);

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        String indentation = StringUtil.indentation((int)indent);
        sb.append(indentation).append("Extension: ").append((Object)this.type).append(" (").append(this.type.getId()).append("), ").append(this.getExtensionLength()).append(" bytes").append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    final ExtensionType getType() {
        return this.type;
    }

    public int getLength() {
        return 4 + this.getExtensionLength();
    }

    public void writeTo(DatagramWriter writer) {
        writer.write(this.getType().getId(), 16);
        writer.write(this.getExtensionLength(), 16);
        this.writeExtensionTo(writer);
    }

    public static HelloExtension readFrom(DatagramReader reader) throws HandshakeException {
        int typeId = reader.read(16);
        int extensionLength = reader.read(16);
        DatagramReader extensionDataReader = reader.createRangeReader(extensionLength);
        ExtensionType type = ExtensionType.getExtensionTypeById(typeId);
        HelloExtension extension = null;
        if (type != null) {
            switch (type) {
                case ELLIPTIC_CURVES: {
                    extension = SupportedEllipticCurvesExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case EC_POINT_FORMATS: {
                    extension = SupportedPointFormatsExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case SIGNATURE_ALGORITHMS: {
                    extension = SignatureAlgorithmsExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case CLIENT_CERT_TYPE: {
                    extension = ClientCertificateTypeExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case SERVER_CERT_TYPE: {
                    extension = ServerCertificateTypeExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case MAX_FRAGMENT_LENGTH: {
                    extension = MaxFragmentLengthExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case SERVER_NAME: {
                    extension = ServerNameExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case RECORD_SIZE_LIMIT: {
                    extension = RecordSizeLimitExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case EXTENDED_MASTER_SECRET: {
                    extension = ExtendedMasterSecretExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                case CONNECTION_ID: {
                    extension = ConnectionIdExtension.fromExtensionDataReader(extensionDataReader, type);
                    break;
                }
                case RENEGOTIATION_INFO: {
                    extension = RenegotiationInfoExtension.fromExtensionDataReader(extensionDataReader);
                    break;
                }
                default: {
                    if (type.replacement != ExtensionType.CONNECTION_ID) break;
                    extension = ConnectionIdExtension.fromExtensionDataReader(extensionDataReader, type);
                }
            }
        }
        if (extension != null) {
            if (extensionDataReader.bytesAvailable()) {
                byte[] bytesLeft = extensionDataReader.readBytesLeft();
                throw new HandshakeException(String.format("Too many bytes, %d left, hello extension not completely parsed! hello extension type %d", bytesLeft.length, typeId), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
            }
        } else {
            extensionDataReader.close();
        }
        return extension;
    }

    public static enum ExtensionType {
        SERVER_NAME(0, "server_name"),
        MAX_FRAGMENT_LENGTH(1, "max_fragment_length"),
        CLIENT_CERTIFICATE_URL(2, "client_certificate_url"),
        TRUSTED_CA_KEYS(3, "trusted_ca_keys"),
        TRUNCATED_HMAC(4, "truncated_hmac"),
        STATUS_REQUEST(5, "status_request"),
        USER_MAPPING(6, "user_mapping"),
        CLIENT_AUTHZ(7, "client_authz"),
        SERVER_AUTHZ(8, "server_authz"),
        CERT_TYPE(9, "cert_type"),
        ELLIPTIC_CURVES(10, "elliptic_curves"),
        EC_POINT_FORMATS(11, "ec_point_formats"),
        SRP(12, "srp"),
        SIGNATURE_ALGORITHMS(13, "signature_algorithms"),
        USE_SRTP(14, "use_srtp"),
        HEARTBEAT(15, "heartbeat"),
        APPLICATION_LAYER_PROTOCOL_NEGOTIATION(16, "application_layer_protocol_negotiation"),
        STATUS_REQUEST_V2(17, "status_request_v2"),
        SIGNED_CERTIFICATE_TIMESTAMP(18, "signed_certificate_timestamp"),
        CLIENT_CERT_TYPE(19, "client_certificate_type"),
        SERVER_CERT_TYPE(20, "server_certificate_type"),
        ENCRYPT_THEN_MAC(22, "encrypt_then_mac"),
        EXTENDED_MASTER_SECRET(23, "extended_master_secret"),
        RECORD_SIZE_LIMIT(28, "record_size_limit"),
        SESSION_TICKET_TLS(35, "SessionTicket TLS"),
        CONNECTION_ID(54, "Connection ID"),
        CONNECTION_ID_DEPRECATED(53, "Connection ID (deprecated)", CONNECTION_ID),
        RENEGOTIATION_INFO(65281, "renegotiation_info");

        private int id;
        private String name;
        private ExtensionType replacement;

        private ExtensionType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        private ExtensionType(int id, String name, ExtensionType replacement) {
            this.id = id;
            this.name = name;
            this.replacement = replacement;
        }

        public static ExtensionType getExtensionTypeById(int id) {
            for (ExtensionType type : ExtensionType.values()) {
                if (type.getId() != id) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public ExtensionType getReplacementType() {
            return this.replacement;
        }
    }
}

