/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.BooleanDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.elements.config.EnumDefinition;
import org.eclipse.californium.elements.config.EnumListDefinition;
import org.eclipse.californium.elements.config.FloatDefinition;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.StringSetDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.config.ValueException;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

public final class DtlsConfig {
    public static final String MODULE = "DTLS.";
    public static final int DEFAULT_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 2000;
    public static final int RFC6347_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 1000;
    public static final int RFC7925_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 9000;
    public static final int DEFAULT_MAX_RETRANSMISSION_TIMEOUT_IN_MILLISECONDS = 60000;
    public static final int DEFAULT_ADDITIONAL_TIMEOUT_FOR_ECC_IN_MILLISECONDS = 0;
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 4;
    public static final int DEFAULT_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = 8192;
    public static final int DEFAULT_MAX_TRANSMISSION_UNIT_LIMIT = 1500;
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD_SECONDS = 1800L;
    @Deprecated
    public static final int DEFAULT_MAX_PENDING_OUTBOUND_MESSAGES = 100000;
    public static final int DEFAULT_MAX_PENDING_OUTBOUND_JOBS = 50000;
    public static final int DEFAULT_MAX_PENDING_INBOUND_JOBS = 50000;
    public static final int DEFAULT_MAX_PENDING_HANDSHAKE_RESULT_JOBS = 5000;
    public static final int DEFAULT_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES = 10;
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_INCOMING_RECORDS_SIZE = 8192;
    public static final int DEFAULT_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD_IN_PERCENT = 30;
    public static final DtlsSecureRenegotiation DEFAULT_SECURE_RENEGOTIATION = DtlsSecureRenegotiation.WANTED;
    public static final TimeDefinition DTLS_SESSION_TIMEOUT = new TimeDefinition("DTLS.SESSION_TIMEOUT", "DTLS session timeout. Currently not supported.", 1L, TimeUnit.HOURS);
    public static final TimeDefinition DTLS_AUTO_HANDSHAKE_TIMEOUT = new TimeDefinition("DTLS.AUTO_HANDSHAKE_TIMEOUT", "DTLS auto-handshake timeout. After that period without exchanging messages, a new message will initiate a handshake. Must not be used with SERVER_ONLY! Common value will be \"30[s]\" in order to compensate assumed NAT timeouts. <blank>, disabled.");
    public static final IntegerDefinition DTLS_CONNECTION_ID_LENGTH = new IntegerDefinition("DTLS.CONNECTION_ID_LENGTH", "DTLS connection ID length. <blank> disabled, 0 enables support without active use of CID.", null, Integer.valueOf(0));
    public static final IntegerDefinition DTLS_CONNECTION_ID_NODE_ID = new IntegerDefinition("DTLS.CONNECTION_ID_NODE_ID", "DTLS cluster-node ID used for connection ID. <blank> not used.", null, Integer.valueOf(0));
    public static final TimeDefinition DTLS_RETRANSMISSION_TIMEOUT = new TimeDefinition("DTLS.RETRANSMISSION_TIMEOUT", "DTLS initial retransmission timeout.", 2000L, TimeUnit.MILLISECONDS);
    public static final TimeDefinition DTLS_MAX_RETRANSMISSION_TIMEOUT = new TimeDefinition("DTLS.MAX_RETRANSMISSION_TIMEOUT", "DTLS maximum retransmission timeout.", 60000L, TimeUnit.MILLISECONDS);
    public static final FloatDefinition DTLS_RETRANSMISSION_INIT_RANDOM = new FloatDefinition("DTLS.RETRANSMISSION_INIT_RANDOM", "DTLS random factor for initial retransmission timeout.", Float.valueOf(1.0f), Float.valueOf(1.0f));
    public static final FloatDefinition DTLS_RETRANSMISSION_TIMEOUT_SCALE = new FloatDefinition("DTLS.RETRANSMISSION_TIMEOUT_SCALE", "DTLS scale factor for retransmission backoff-timeout.", Float.valueOf(2.0f), Float.valueOf(1.0f));
    public static final TimeDefinition DTLS_ADDITIONAL_ECC_TIMEOUT = new TimeDefinition("DTLS.ADDITIONAL_ECC_TIMEOUT", "DTLS additional initial timeout for ECC related flights.", 0L, TimeUnit.MILLISECONDS);
    public static final IntegerDefinition DTLS_MAX_RETRANSMISSIONS = new IntegerDefinition("DTLS.MAX_RETRANSMISSIONS", "DTLS maximum number of flight retransmissions.", Integer.valueOf(4), Integer.valueOf(0));
    public static final IntegerDefinition DTLS_RETRANSMISSION_BACKOFF = new IntegerDefinition("DTLS.RETRANSMISSION_BACKOFF", "Number of flight-retransmissions before switching to backoff mode using single handshake messages in single record datagrams.", null, Integer.valueOf(0));
    public static final BooleanDefinition DTLS_SERVER_USE_SESSION_ID = new BooleanDefinition("DTLS.SERVER_USE_SESSION_ID", "Enable server to use a session ID in order to support session resumption.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_USE_EARLY_STOP_RETRANSMISSION = new BooleanDefinition("DTLS.USE_EARLY_STOP_RETRANSMISSION", "Stop retransmission on receiving the first message of the next flight, not waiting for the last message.", Boolean.valueOf(true));
    public static final IntegerDefinition DTLS_RECORD_SIZE_LIMIT = new IntegerDefinition("DTLS.RECORD_SIZE_LIMIT", "DTLS record size limit (RFC 8449). Between 64 and 16K.", null, Integer.valueOf(64));
    public static final EnumDefinition<MaxFragmentLengthExtension.Length> DTLS_MAX_FRAGMENT_LENGTH = new EnumDefinition("DTLS.MAX_FRAGMENT_SIZE", "DTLS maximum fragment length (RFC 6066).", (Enum[])MaxFragmentLengthExtension.Length.values());
    public static final IntegerDefinition DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = new IntegerDefinition("DTLS.MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH", "DTLS maximum length of reassembled fragmented handshake message.\nMust be large enough for used certificates.", Integer.valueOf(8192), Integer.valueOf(64));
    public static final BooleanDefinition DTLS_USE_MULTI_RECORD_MESSAGES = new BooleanDefinition("DTLS.USE_MULTI_RECORD_MESSAGES", "Use multiple DTLS records in UDP messages.");
    public static final BooleanDefinition DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS = new BooleanDefinition("DTLS.USE_MULTI_HANDSHAKE_MESSAGE_RECORDS", "Use multiple handshake messages in DTLS records.\nNot all libraries may have implemented this!");
    public static final EnumDefinition<CertificateAuthenticationMode> DTLS_CLIENT_AUTHENTICATION_MODE = new EnumDefinition("DTLS.CLIENT_AUTHENTICATION_MODE", "DTLS client authentication mode for certificate based cipher suites.", (Enum)CertificateAuthenticationMode.NEEDED, (Enum[])CertificateAuthenticationMode.values());
    public static final BooleanDefinition DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT = new BooleanDefinition("DTLS.VERIFY_SERVER_CERTIFICATES_SUBJECT", "DTLS verifies the server certificate's subjects.", Boolean.valueOf(true));
    public static final EnumListDefinition<CertificateType> DTLS_CERTIFICATE_TYPES = new EnumListDefinition("DTLS.CERTIFICATE_TYPES", "DTLS supported certificate types ordered by preference.", Arrays.asList(CertificateType.RAW_PUBLIC_KEY, CertificateType.X_509), (Enum[])new CertificateType[]{CertificateType.RAW_PUBLIC_KEY, CertificateType.X_509});
    public static final EnumDefinition<DtlsRole> DTLS_ROLE = new EnumDefinition("DTLS.ROLE", "DTLS role.", (Enum)DtlsRole.BOTH, (Enum[])DtlsRole.values());
    public static final IntegerDefinition DTLS_MAX_TRANSMISSION_UNIT = new IntegerDefinition("DTLS.MAX_TRANSMISSION_UNIT", "DTLS MTU (Maximum Transmission Unit).\nMust be used, if the MTU of the local network doesn't apply, e.g. if ip-tunnels are used.", null, Integer.valueOf(64));
    public static final IntegerDefinition DTLS_MAX_TRANSMISSION_UNIT_LIMIT = new IntegerDefinition("DTLS.MAX_TRANSMISSION_UNIT_LIMIT", "DTLS MTU (Maximum Transmission Unit) limit for local auto detection.", null, Integer.valueOf(64));
    public static final StringSetDefinition DTLS_DEFAULT_HANDSHAKE_MODE = new StringSetDefinition("DTLS.DEFAULT_HANDSHAKE_MODE", "DTLS default handshake mode.", new String[]{"auto", "none", "auto"});
    public static final IntegerDefinition DTLS_MAX_CONNECTIONS = new IntegerDefinition("DTLS.MAX_CONNECTIONS", "DTLS maximum connections.", Integer.valueOf(150000), Integer.valueOf(1));
    public static final TimeDefinition DTLS_STALE_CONNECTION_THRESHOLD = new TimeDefinition("DTLS.STALE_CONNECTION_THRESHOLD", "DTLS threshold for stale connections. Connections will only get removed for new ones, if at least for that threshold no messages are exchanged using that connection.", 1800L, TimeUnit.SECONDS);
    @Deprecated
    public static final IntegerDefinition DTLS_OUTBOUND_MESSAGE_BUFFER_SIZE = new IntegerDefinition("DTLS.OUTBOUND_MESSAGE_BUFFER_SIZE", "DTLS buffer size for outbound messages");
    public static final IntegerDefinition DTLS_MAX_PENDING_OUTBOUND_JOBS = new IntegerDefinition("DTLS.MAX_PENDING_OUTBOUND_JOBS", "Maximum number of jobs for outbound DTLS messages.", Integer.valueOf(50000), Integer.valueOf(64));
    public static final IntegerDefinition DTLS_MAX_PENDING_INBOUND_JOBS = new IntegerDefinition("DTLS.MAX_PENDING_INBOUND_JOBS", "Maximum number of jobs for inbound DTLS messages.", Integer.valueOf(50000), Integer.valueOf(64));
    public static final IntegerDefinition DTLS_MAX_PENDING_HANDSHAKE_RESULT_JOBS = new IntegerDefinition("DTLS.MAX_PENDING_HANDSHAKE_RESULT_JOBS", "Maximum number of jobs for DTLS handshake results.", Integer.valueOf(5000), Integer.valueOf(64));
    public static final IntegerDefinition DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES = new IntegerDefinition("DTLS.MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES", "DTLS maximum deferred outbound application messages.", Integer.valueOf(10), Integer.valueOf(0));
    public static final IntegerDefinition DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE = new IntegerDefinition("DTLS.MAX_DEFERRED_INBOUND_RECORDS", "DTLS maximum size of all deferred inbound messages.", Integer.valueOf(8192), Integer.valueOf(0));
    public static final IntegerDefinition DTLS_RECEIVER_THREAD_COUNT = new IntegerDefinition("DTLS.RECEIVER_THREAD_COUNT", "Number of DTLS receiver threads.", Integer.valueOf(1), Integer.valueOf(0));
    public static final IntegerDefinition DTLS_CONNECTOR_THREAD_COUNT = new IntegerDefinition("DTLS.CONNECTOR_THREAD_COUNT", "Number of DTLS connector threads.", Integer.valueOf(1), Integer.valueOf(0));
    public static final IntegerDefinition DTLS_RECEIVE_BUFFER_SIZE = new IntegerDefinition("DTLS.RECEIVE_BUFFER_SIZE", "DTLS receive-buffer size. Empty or 0 to use the OS default.", null, Integer.valueOf(64));
    public static final IntegerDefinition DTLS_SEND_BUFFER_SIZE = new IntegerDefinition("DTLS.SEND_BUFFER_SIZE", "DTLS send-buffer size. Empty or 0 to use the OS default.", null, Integer.valueOf(64));
    public static final BooleanDefinition DTLS_USE_SERVER_NAME_INDICATION = new BooleanDefinition("DTLS.USE_SERVER_NAME_INDICATION", "DTLS use server name indication.", Boolean.valueOf(false));
    public static final EnumDefinition<ExtendedMasterSecretMode> DTLS_EXTENDED_MASTER_SECRET_MODE = new EnumDefinition("DTLS.EXTENDED_MASTER_SECRET_MODE", "DTLS extended master secret mode.", (Enum)ExtendedMasterSecretMode.ENABLED, (Enum[])ExtendedMasterSecretMode.values());
    public static final IntegerDefinition DTLS_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD = new IntegerDefinition("DTLS.VERIFY_PEERS_ON_RESUMPTION_THRESHOLD", "DTLS verify peers on resumption threshold in percent.", Integer.valueOf(30), Integer.valueOf(0));
    public static final BooleanDefinition DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK = new BooleanDefinition("DTLS.USE_HELLO_VERIFY_REQUEST_FOR_PSK", "DTLS use a HELLO_VERIFY_REQUEST for PSK cipher suites to protect against spoofing.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_USE_HELLO_VERIFY_REQUEST = new BooleanDefinition("DTLS.USE_HELLO_VERIFY_REQUEST", "DTLS use a HELLO_VERIFY_REQUEST to protect against spoofing.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_USE_ANTI_REPLAY_FILTER = new BooleanDefinition("DTLS.USE_USE_ANTI_REPLAY_FILTER", "DTLS use the anti-replay-filter.", Boolean.valueOf(true));
    public static final IntegerDefinition DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER = new IntegerDefinition("DTLS.USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER", "DTLS use a disabled window for the anti-replay-filter. -1 := extend the disabled window to start of session, 0 := normal window, <n> := disabled window of size <n>.", Integer.valueOf(0), Integer.valueOf(-1));
    public static final BooleanDefinition DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS = new BooleanDefinition("DTLS.UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS", "DTLS update address using CID on newer records.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_USE_NEWER_RECORD_FILTER = new BooleanDefinition("DTLS.USE_NEWER_FILTER", "DTLS use newer record filter.\nDrop reordered records in order to protect from delay attacks,\nif no other means, maybe on application level, are available.", Boolean.valueOf(false));
    public static final BooleanDefinition DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH = new BooleanDefinition("DTLS.TRUNCATE_CLIENT_CERTIFICATE_PATH", "DTLS truncate client certificate path.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION = new BooleanDefinition("DTLS.TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION", "DTLS certificate path for validation.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_RECOMMENDED_CIPHER_SUITES_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_CIPHER_SUITES_ONLY", "DTLS recommended cipher-suites only.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_RECOMMENDED_CURVES_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_CURVES_ONLY", "DTLS recommended ECC curves/groups only.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY = new BooleanDefinition("DTLS.RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY", "DTLS recommended signature- and hash-algorithms only.", Boolean.valueOf(true));
    public static final EnumListDefinition<CipherSuite> DTLS_PRESELECTED_CIPHER_SUITES = new EnumListDefinition("DTLS.PRESELECTED_CIPHER_SUITES", "List of preselected DTLS cipher-suites.\nIf not recommended cipher suites are intended to be used, switch off DTLS_RECOMMENDED_CIPHER_SUITES_ONLY.\nThe supported cipher suites are evaluated at runtime and may differ from the ones when creating this properties file.", (Enum[])CipherSuite.getCipherSuites(false, false));
    public static final EnumListDefinition<CipherSuite> DTLS_CIPHER_SUITES = new EnumListDefinition("DTLS.CIPHER_SUITES", "List of DTLS cipher-suites.\nIf not recommended cipher suites are intended to be used, switch off DTLS_RECOMMENDED_CIPHER_SUITES_ONLY.\nThe supported cipher suites are evaluated at runtime and may differ from the ones when creating this properties file.", null, 1, (Enum[])CipherSuite.getCipherSuites(false, true));
    public static final EnumListDefinition<XECDHECryptography.SupportedGroup> DTLS_CURVES = new EnumListDefinition("DTLS.CURVES", "List of DTLS curves (supported groups).\nDefaults to all supported curves of the JCE at runtime.", (Enum[])XECDHECryptography.SupportedGroup.getUsableGroupsArray());
    public static final SignatureAndHashAlgorithmsDefinition DTLS_SIGNATURE_AND_HASH_ALGORITHMS = new SignatureAndHashAlgorithmsDefinition("DTLS.SIGNATURE_AND_HASH_ALGORITHMS", "List of DTLS signature- and hash-algorithms.\nValues e.g SHA256withECDSA or ED25519.");
    public static final EnumListDefinition<CipherSuite.CertificateKeyAlgorithm> DTLS_CERTIFICATE_KEY_ALGORITHMS = new EnumListDefinition("DTLS.CERTIFICATE_KEY_ALGORITHMS", "List of DTLS certificate key algorithms.\nOn the client side used to select the default cipher-suites, on the server side to negotiate the client's certificate.", (Enum[])new CipherSuite.CertificateKeyAlgorithm[]{CipherSuite.CertificateKeyAlgorithm.EC, CipherSuite.CertificateKeyAlgorithm.RSA});
    public static final IntegerDefinition DTLS_USE_DEPRECATED_CID = new IntegerDefinition("DTLS.USE_DEPRECATED_CID", "DTLS use deprecated CID extension code point for client (before version 09 of RFC-CID).", null, Integer.valueOf(53));
    public static final BooleanDefinition DTLS_SUPPORT_DEPRECATED_CID = new BooleanDefinition("DTLS.SUPPORT_DEPRECATED_CID", "DTLS support deprecated CID for server (before version 9).", Boolean.valueOf(false));
    public static final BooleanDefinition DTLS_USE_DEFAULT_RECORD_FILTER = new BooleanDefinition("DTLS.USE_DEFAULT_RECORD_FILTER", "Use default DTLS record filter.", Boolean.valueOf(true));
    public static final BooleanDefinition DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS = new BooleanDefinition("DTLS.REMOVE_STALE_DOUBLE_PRINCIPALS", "Remove stale double principals.\nRequires unique principals and a read-write-lock connection store.", Boolean.valueOf(false));
    public static final BooleanDefinition DTLS_READ_WRITE_LOCK_CONNECTION_STORE = new BooleanDefinition("DTLS.READ_WRITE_LOCK_CONNECTION_STORE", "Use read-write-lock connection store.", Boolean.valueOf(false));
    public static final TimeDefinition DTLS_MAC_ERROR_FILTER_QUIET_TIME = new TimeDefinition("DTLS.MAC_ERROR_FILTER_QUIET_TIME", "Quiet time to reset MAC error filter.\nThe MAC error filter blocks all traffic for an endpoint, if since the last quiet period the number of new MAC errors exceeds a threshold.\n0 to disable the MAC error filter.", 0L, TimeUnit.SECONDS);
    public static final IntegerDefinition DTLS_MAC_ERROR_FILTER_THRESHOLD = new IntegerDefinition("DTLS.MAC_ERROR_FILTER_THRESHOLD", "Threshold of current MAC errors to block all traffic for an endpoint. 0 to disable the MAC error filter.", Integer.valueOf(0), Integer.valueOf(0));
    public static final EnumDefinition<DtlsSecureRenegotiation> DTLS_SECURE_RENEGOTIATION = new EnumDefinition("DTLS.SECURE_RENEGOTIATION_MODE", "Use minimal version of RFC5746 to indicate secure renegotiation on initial handshake.\nRenegotation handshakes are always rejected by Californium.", (Enum)DEFAULT_SECURE_RENEGOTIATION, (Enum[])DtlsSecureRenegotiation.values());
    public static final Configuration.ModuleDefinitionsProvider DEFINITIONS = new Configuration.ModuleDefinitionsProvider(){

        public String getModule() {
            return DtlsConfig.MODULE;
        }

        public void applyDefinitions(Configuration config) {
            int CORES = Runtime.getRuntime().availableProcessors();
            config.set(DTLS_SESSION_TIMEOUT, 24, TimeUnit.HOURS);
            config.set(DTLS_AUTO_HANDSHAKE_TIMEOUT, null, TimeUnit.SECONDS);
            config.set(DTLS_RETRANSMISSION_TIMEOUT, 2000, TimeUnit.MILLISECONDS);
            config.set(DTLS_MAX_RETRANSMISSION_TIMEOUT, 60000, TimeUnit.MILLISECONDS);
            config.set(DTLS_ADDITIONAL_ECC_TIMEOUT, 0, TimeUnit.MILLISECONDS);
            config.set((BasicDefinition)DTLS_MAX_RETRANSMISSIONS, (Object)4);
            config.set((BasicDefinition)DTLS_RETRANSMISSION_INIT_RANDOM, (Object)Float.valueOf(1.0f));
            config.set((BasicDefinition)DTLS_RETRANSMISSION_TIMEOUT_SCALE, (Object)Float.valueOf(2.0f));
            config.set((BasicDefinition)DTLS_RETRANSMISSION_BACKOFF, null);
            config.set((BasicDefinition)DTLS_CONNECTION_ID_LENGTH, null);
            config.set((BasicDefinition)DTLS_CONNECTION_ID_NODE_ID, null);
            config.set((BasicDefinition)DTLS_SERVER_USE_SESSION_ID, (Object)true);
            config.set((BasicDefinition)DTLS_USE_EARLY_STOP_RETRANSMISSION, (Object)true);
            config.set((BasicDefinition)DTLS_RECORD_SIZE_LIMIT, null);
            config.set(DTLS_MAX_FRAGMENT_LENGTH, null);
            config.set((BasicDefinition)DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH, (Object)8192);
            config.set((BasicDefinition)DTLS_USE_MULTI_RECORD_MESSAGES, null);
            config.set((BasicDefinition)DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS, null);
            config.set(DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NEEDED);
            config.set((BasicDefinition)DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT, (Object)true);
            config.set(DTLS_CERTIFICATE_TYPES, Arrays.asList(CertificateType.RAW_PUBLIC_KEY, CertificateType.X_509));
            config.set(DTLS_ROLE, (Object)DtlsRole.BOTH);
            config.set((BasicDefinition)DTLS_MAX_TRANSMISSION_UNIT, null);
            config.set((BasicDefinition)DTLS_MAX_TRANSMISSION_UNIT_LIMIT, (Object)1500);
            config.set((BasicDefinition)DTLS_DEFAULT_HANDSHAKE_MODE, null);
            config.set((BasicDefinition)DTLS_MAX_CONNECTIONS, (Object)150000);
            config.set(DTLS_STALE_CONNECTION_THRESHOLD, Long.valueOf(1800L), TimeUnit.SECONDS);
            config.setDeprecated((DocumentedDefinition)DTLS_OUTBOUND_MESSAGE_BUFFER_SIZE, (DocumentedDefinition)DTLS_MAX_PENDING_OUTBOUND_JOBS);
            config.set((BasicDefinition)DTLS_MAX_PENDING_OUTBOUND_JOBS, (Object)50000);
            config.set((BasicDefinition)DTLS_MAX_PENDING_INBOUND_JOBS, (Object)50000);
            config.set((BasicDefinition)DTLS_MAX_PENDING_HANDSHAKE_RESULT_JOBS, (Object)5000);
            config.set((BasicDefinition)DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES, (Object)10);
            config.set((BasicDefinition)DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE, (Object)8192);
            config.set((BasicDefinition)DTLS_RECEIVER_THREAD_COUNT, (Object)(CORES > 3 ? 2 : 1));
            config.set((BasicDefinition)DTLS_CONNECTOR_THREAD_COUNT, (Object)CORES);
            config.set((BasicDefinition)DTLS_RECEIVE_BUFFER_SIZE, null);
            config.set((BasicDefinition)DTLS_SEND_BUFFER_SIZE, null);
            config.set((BasicDefinition)DTLS_USE_SERVER_NAME_INDICATION, (Object)false);
            config.set(DTLS_EXTENDED_MASTER_SECRET_MODE, (Object)ExtendedMasterSecretMode.ENABLED);
            config.set((BasicDefinition)DTLS_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD, (Object)30);
            config.set((BasicDefinition)DTLS_USE_HELLO_VERIFY_REQUEST, (Object)true);
            config.set((BasicDefinition)DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK, (Object)true);
            config.set((BasicDefinition)DTLS_USE_ANTI_REPLAY_FILTER, (Object)true);
            config.set((BasicDefinition)DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)0);
            config.set((BasicDefinition)DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS, (Object)true);
            config.set((BasicDefinition)DTLS_USE_NEWER_RECORD_FILTER, (Object)false);
            config.set((BasicDefinition)DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH, (Object)true);
            config.set((BasicDefinition)DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION, (Object)true);
            config.set((BasicDefinition)DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)true);
            config.set((BasicDefinition)DTLS_RECOMMENDED_CURVES_ONLY, (Object)true);
            config.set((BasicDefinition)DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY, (Object)true);
            config.set(DTLS_PRESELECTED_CIPHER_SUITES, null);
            config.set(DTLS_CIPHER_SUITES, null);
            config.set(DTLS_CURVES, null);
            config.set((BasicDefinition)DTLS_SIGNATURE_AND_HASH_ALGORITHMS, null);
            config.set(DTLS_CERTIFICATE_KEY_ALGORITHMS, null);
            config.set((BasicDefinition)DTLS_USE_DEPRECATED_CID, null);
            config.set((BasicDefinition)DTLS_SUPPORT_DEPRECATED_CID, (Object)false);
            config.set((BasicDefinition)DTLS_USE_DEFAULT_RECORD_FILTER, (Object)true);
            config.set((BasicDefinition)DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS, (Object)false);
            config.set((BasicDefinition)DTLS_READ_WRITE_LOCK_CONNECTION_STORE, (Object)false);
            config.set(DTLS_MAC_ERROR_FILTER_QUIET_TIME, 0, TimeUnit.SECONDS);
            config.set((BasicDefinition)DTLS_MAC_ERROR_FILTER_THRESHOLD, (Object)0);
        }
    };

    public static void register() {
        SystemConfig.register();
    }

    static {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)DEFINITIONS);
    }

    public static class SignatureAndHashAlgorithmsDefinition
    extends BasicListDefinition<SignatureAndHashAlgorithm> {
        public SignatureAndHashAlgorithmsDefinition(String key, String documentation) {
            super(key, documentation, null);
        }

        public String getTypeName() {
            return "List<SignatureAndHashAlgorithm>";
        }

        public String writeValue(List<SignatureAndHashAlgorithm> value) {
            StringBuilder message = new StringBuilder();
            for (SignatureAndHashAlgorithm in : value) {
                message.append(in.getJcaName()).append(", ");
            }
            message.setLength(message.length() - 2);
            return message.toString();
        }

        public List<SignatureAndHashAlgorithm> checkValue(List<SignatureAndHashAlgorithm> value) throws ValueException {
            if (value != null) {
                for (SignatureAndHashAlgorithm algorithm : value) {
                    if (algorithm.isSupported()) continue;
                    throw new IllegalArgumentException(algorithm + " is not supported by the JCE!");
                }
            }
            return super.checkValue(value);
        }

        protected boolean isAssignableFrom(Object value) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    if (item instanceof SignatureAndHashAlgorithm) continue;
                    throw new IllegalArgumentException(item + " is no SignatureAndHashAlgorithm");
                }
                return true;
            }
            return false;
        }

        protected List<SignatureAndHashAlgorithm> parseValue(String value) {
            String[] list = value.split(",");
            ArrayList<SignatureAndHashAlgorithm> result = new ArrayList<SignatureAndHashAlgorithm>(list.length);
            for (String in : list) {
                in = in.trim();
                SignatureAndHashAlgorithm item = SignatureAndHashAlgorithm.valueOf(in);
                result.add(item);
            }
            return result;
        }
    }

    public static enum DtlsSecureRenegotiation {
        NONE,
        WANTED,
        NEEDED;

    }

    public static enum DtlsRole {
        CLIENT_ONLY,
        SERVER_ONLY,
        BOTH;

    }
}

