/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhSignedServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.RenegotiationInfoExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteParameters;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public class ServerHandshaker
extends Handshaker {
    private static final HandshakeState[] CLIENT_HELLO = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_HELLO)};
    private static final HandshakeState[] CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_VERIFY), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static final HandshakeState[] EMPTY_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    protected static final HandshakeState[] NO_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private final Logger LOGGER_NEGOTIATION;
    private final boolean useSessionId;
    private final CertificateAuthenticationMode clientAuthenticationMode;
    private final boolean useHelloVerifyRequest;
    private final boolean useHelloVerifyRequestForPsk;
    private final CipherSuiteSelector cipherSuiteSelector;
    private final List<CipherSuite> supportedCipherSuites;
    private final DtlsConfig.DtlsSecureRenegotiation secureRenegotiation;
    private final List<XECDHECryptography.SupportedGroup> supportedGroups;
    private final List<CertificateType> supportedClientCertificateTypes;
    private final List<CertificateType> supportedServerCertificateTypes;
    private final List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms;
    private final List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms;
    private final boolean supportDeprecatedCid;
    private CipherSuiteParameters cipherSuiteParameters;
    private ClientHello pendingClientHello;
    private CertificateVerify certificateVerifyMessage;
    private PskPublicInformation preSharedKeyIdentity;
    private XECDHECryptography ecdhe;

    public ServerHandshaker(long initialRecordSequenceNo, int initialMessageSequenceNo, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(initialRecordSequenceNo, initialMessageSequenceNo, recordLayer, timer, connection, config);
        this.LOGGER_NEGOTIATION = LoggerFactory.getLogger((String)(this.LOGGER.getName() + ".negotiation"));
        this.cipherSuiteSelector = config.getCipherSuiteSelector();
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.secureRenegotiation = config.get(DtlsConfig.DTLS_SECURE_RENEGOTIATION);
        this.clientAuthenticationMode = config.get(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE);
        this.useSessionId = (Boolean)config.get(DtlsConfig.DTLS_SERVER_USE_SESSION_ID);
        this.useHelloVerifyRequest = (Boolean)config.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST);
        this.useHelloVerifyRequestForPsk = this.useHelloVerifyRequest && (Boolean)config.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK) != false;
        this.supportedClientCertificateTypes = config.getTrustCertificateTypes();
        this.supportedServerCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAndHashAlgorithms = config.getSupportedSignatureAlgorithms();
        this.supportedCertificateKeyAlgorithms = config.getSupportedCertificateKeyAlgorithm();
        this.supportDeprecatedCid = (Boolean)config.get(DtlsConfig.DTLS_SUPPORT_DEPRECATED_CID);
        this.setExpectedStates(CLIENT_HELLO);
    }

    @Override
    protected boolean isClient() {
        return false;
    }

    public PskPublicInformation getPreSharedKeyIdentity() {
        return this.preSharedKeyIdentity;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        block0 : switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.handshakeStarted();
                this.receivedClientHello((ClientHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedClientCertificate((CertificateMessage)message);
                break;
            }
            case CLIENT_KEY_EXCHANGE: {
                switch (this.getSession().getKeyExchange()) {
                    case PSK: {
                        this.receivedClientKeyExchange((PSKClientKeyExchange)message);
                        break block0;
                    }
                    case ECDHE_PSK: {
                        this.receivedClientKeyExchange((EcdhPskClientKeyExchange)message);
                        break block0;
                    }
                    case EC_DIFFIE_HELLMAN: {
                        SecretKey masterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)message);
                        this.applyMasterSecret(masterSecret);
                        SecretUtil.destroy(masterSecret);
                        this.processMasterSecret();
                        break block0;
                    }
                }
                break;
            }
            case CERTIFICATE_VERIFY: {
                this.receivedCertificateVerify((CertificateVerify)message);
                if (!this.hasMasterSecret() || !this.otherPeersCertificateVerified) break;
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    protected void startInitialTimeout() {
        DTLSFlight flight = this.createFlight();
        flight.setResponseStarted();
        this.sendFlight(flight);
    }

    @Override
    protected void processMasterSecret() {
        if (this.isExpectedStates(NO_CLIENT_CERTIFICATE) || this.isExpectedStates(EMPTY_CLIENT_CERTIFICATE) || this.isExpectedStates(CLIENT_CERTIFICATE) && this.otherPeersCertificateVerified && this.certificateVerifyMessage != null) {
            this.expectChangeCipherSpecMessage();
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (message.isEmpty()) {
            if (this.clientAuthenticationMode == CertificateAuthenticationMode.NEEDED) {
                this.LOGGER.debug("Client authentication failed: missing certificate!");
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                throw new HandshakeException("Client Certificate required!", alert);
            }
            this.setExpectedStates(EMPTY_CLIENT_CERTIFICATE);
        } else {
            this.verifyCertificate(message, false);
        }
    }

    @Override
    protected void processCertificateVerified() {
        if (this.hasMasterSecret() && this.certificateVerifyMessage != null) {
            this.expectChangeCipherSpecMessage();
        }
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerifyMessage = message;
        this.handshakeMessages.remove(this.handshakeMessages.size() - 1);
        message.verifySignature(this.otherPeersPublicKey, this.handshakeMessages);
        this.handshakeMessages.add(message);
        if (this.setOtherPeersSignatureVerified() && this.hasMasterSecret()) {
            this.expectChangeCipherSpecMessage();
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        if (this.clientAuthenticationMode == CertificateAuthenticationMode.NEEDED && this.isExpectedStates(EMPTY_CLIENT_CERTIFICATE)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        this.flightNumber += 2;
        DTLSFlight flight = this.createFlight();
        MessageDigest md = this.getHandshakeMessageDigest();
        MessageDigest mdWithClientFinished = this.cloneMessageDigest(md);
        this.verifyFinished(message, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithClientFinished.update(message.toByteArray());
        Finished finished = this.createFinishedMessage(mdWithClientFinished.digest());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.contextEstablished();
    }

    protected void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        SessionId sessionId;
        this.negotiateProtocolVersion(clientHello.getProtocolVersion());
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        List<CipherSuite> commonCipherSuites = this.getCommonCipherSuites(clientHello);
        if (commonCipherSuites.isEmpty()) {
            this.LOGGER.trace("Server cipher suites: {}", this.supportedCipherSuites);
            throw new HandshakeException("Client does not propose a common cipher suite", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (!(!this.useHelloVerifyRequest || this.useHelloVerifyRequestForPsk || clientHello.hasCookie() || !(sessionId = this.getSession().getSessionIdentifier()).isEmpty() && sessionId.equals((Object)clientHello.getSessionId()))) {
            ArrayList<CipherSuite> common = new ArrayList<CipherSuite>();
            for (CipherSuite cipherSuite : commonCipherSuites) {
                if (!cipherSuite.isPskBased()) continue;
                common.add(cipherSuite);
            }
            commonCipherSuites = common;
        }
        List<CertificateType> commonServerCertTypes = this.getCommonServerCertificateTypes(clientHello.getServerCertificateTypeExtension());
        List<CertificateType> commonClientCertTypes = this.getCommonClientCertificateTypes(clientHello.getClientCertificateTypeExtension());
        List<XECDHECryptography.SupportedGroup> commonGroups = this.getCommonSupportedGroups(clientHello.getSupportedEllipticCurvesExtension());
        List<SignatureAndHashAlgorithm> commonSignatures = this.getCommonSignatureAndHashAlgorithms(clientHello.getSupportedSignatureAlgorithmsExtension());
        SupportedPointFormatsExtension.ECPointFormat format = this.negotiateECPointFormat(clientHello.getSupportedPointFormatsExtension());
        ServerNameExtension serverNameExt = clientHello.getServerNameExtension();
        if (serverNameExt != null) {
            if (this.sniEnabled) {
                DTLSSession session = this.getSession();
                session.setServerNames(serverNameExt.getServerNames());
                session.setSniSupported(true);
                this.LOGGER.debug("using server name indication received from peer [{}]", this.peerToLog);
            } else {
                this.LOGGER.debug("client [{}] included SNI in HELLO but SNI support is disabled", this.peerToLog);
            }
        }
        this.cipherSuiteParameters = new CipherSuiteParameters(null, null, this.clientAuthenticationMode, commonCipherSuites, commonServerCertTypes, commonClientCertTypes, commonGroups, commonSignatures, format);
        if (CipherSuite.containsCipherSuiteRequiringCertExchange(commonCipherSuites)) {
            List<CipherSuite.CertificateKeyAlgorithm> keyAlgorithms;
            this.pendingClientHello = clientHello;
            ServerNames serverNames = this.getServerNames();
            if (this.requestCertificateIdentity(null, serverNames, keyAlgorithms = CipherSuite.getCertificateKeyAlgorithms(commonCipherSuites), commonSignatures, commonGroups)) {
                this.startInitialTimeout();
            }
        } else {
            this.processClientHello(clientHello);
        }
    }

    @Override
    protected void processCertificateIdentityAvailable() throws HandshakeException {
        this.cipherSuiteParameters = new CipherSuiteParameters(this.publicKey, this.certificateChain, this.cipherSuiteParameters);
        ClientHello clientHello = this.pendingClientHello;
        this.pendingClientHello = null;
        this.processClientHello(clientHello);
    }

    protected void processClientHello(ClientHello clientHello) throws HandshakeException {
        this.negotiateCipherSuite(clientHello);
        this.flightNumber = clientHello.hasCookie() ? 4 : 2;
        DTLSFlight flight = this.createFlight();
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(flight);
        this.createServerKeyExchange(flight);
        boolean clientCertificate = this.createCertificateRequest(flight);
        this.setExpectedStates(clientCertificate ? CLIENT_CERTIFICATE : NO_CLIENT_CERTIFICATE);
        ServerHelloDone serverHelloDone = new ServerHelloDone();
        this.wrapMessage(flight, serverHelloDone);
        this.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getProtocolVersion());
        this.clientRandom = clientHello.getRandom();
        DTLSSession session = this.getSession();
        boolean useSessionId = this.useSessionId;
        if (this.extendedMasterSecretMode.is(ExtendedMasterSecretMode.ENABLED) && !clientHello.hasExtendedMasterSecretExtension()) {
            useSessionId = false;
        }
        SessionId sessionId = useSessionId ? new SessionId() : SessionId.emptySessionId();
        session.setSessionIdentifier(sessionId);
        session.setProtocolVersion(serverVersion);
        session.setCompressionMethod(CompressionMethod.NULL);
        ServerHello serverHello = new ServerHello(serverVersion, sessionId, session.getCipherSuite(), session.getCompressionMethod());
        this.addHelloExtensions(clientHello, serverHello);
        if (serverHello.getCipherSuite().isEccBased()) {
            this.expectEcc();
        }
        this.wrapMessage(flight, serverHello);
        this.serverRandom = serverHello.getRandom();
    }

    private void createCertificateMessage(DTLSFlight flight) {
        DTLSSession session = this.getSession();
        CertificateMessage certificateMessage = null;
        if (session.getCipherSuite().requiresServerCertificateMessage()) {
            CertificateType certificateType = session.sendCertificateType();
            if (CertificateType.RAW_PUBLIC_KEY == certificateType) {
                certificateMessage = new CertificateMessage(this.cipherSuiteParameters.getPublicKey());
            } else if (CertificateType.X_509 == certificateType) {
                certificateMessage = new CertificateMessage(this.cipherSuiteParameters.getCertificateChain());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " not supported!");
            }
            this.wrapMessage(flight, certificateMessage);
        }
    }

    private void createServerKeyExchange(DTLSFlight flight) throws HandshakeException {
        DTLSSession session = this.getSession();
        CipherSuite.KeyExchangeAlgorithm keyExchangeAlgorithm = session.getKeyExchange();
        if (CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK == keyExchangeAlgorithm || CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN == keyExchangeAlgorithm) {
            try {
                XECDHECryptography.SupportedGroup ecGroup = this.cipherSuiteParameters.getSelectedSupportedGroup();
                this.ecdhe = new XECDHECryptography(ecGroup);
                session.setEcGroup(ecGroup);
            }
            catch (GeneralSecurityException ex) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
            }
        }
        ECDHServerKeyExchange serverKeyExchange = null;
        switch (keyExchangeAlgorithm) {
            case EC_DIFFIE_HELLMAN: {
                serverKeyExchange = new EcdhSignedServerKeyExchange(session.getSignatureAndHashAlgorithm(), this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom);
                break;
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                serverKeyExchange = new EcdhPskServerKeyExchange(PskPublicInformation.EMPTY, this.ecdhe);
                break;
            }
        }
        if (serverKeyExchange != null) {
            this.wrapMessage(flight, serverKeyExchange);
        }
    }

    private boolean createCertificateRequest(DTLSFlight flight) {
        DTLSSession session = this.getSession();
        CertificateType certificateType = session.receiveCertificateType();
        if (this.clientAuthenticationMode.useCertificateRequest() && session.getCipherSuite().requiresServerCertificateMessage() && certificateType != null) {
            CertificateRequest certificateRequest = new CertificateRequest();
            List<SignatureAndHashAlgorithm> signatures = this.supportedSignatureAndHashAlgorithms;
            List<CipherSuite.CertificateKeyAlgorithm> keys = this.supportedCertificateKeyAlgorithms;
            if (CertificateType.X_509 == certificateType) {
                certificateRequest.addSignatureAlgorithms(signatures);
                if (this.certificateVerifier != null) {
                    certificateRequest.addCerticiateAuthorities(this.certificateVerifier.getAcceptedIssuers());
                }
            } else if (CertificateType.RAW_PUBLIC_KEY == certificateType) {
                CipherSuite.CertificateKeyAlgorithm algorithm = CipherSuite.CertificateKeyAlgorithm.getAlgorithm(this.publicKey);
                if (keys.get(0) != algorithm && keys.contains((Object)algorithm)) {
                    keys = new ArrayList<CipherSuite.CertificateKeyAlgorithm>(keys);
                    keys.remove((Object)algorithm);
                    keys.add(0, algorithm);
                }
                signatures = SignatureAndHashAlgorithm.getCompatibleSignatureAlgorithms(signatures, keys);
                certificateRequest.addSignatureAlgorithms(signatures);
            }
            this.LOGGER.trace("Certificate Type: {}", (Object)certificateType);
            this.LOGGER.trace("Signature and hash algorithms {}/{}", signatures, this.supportedSignatureAndHashAlgorithms);
            this.LOGGER.trace("Certificate key algorithms {}/{}", keys, this.supportedCertificateKeyAlgorithms);
            for (CipherSuite.CertificateKeyAlgorithm certificateKeyAlgorithm : keys) {
                if (!SignatureAndHashAlgorithm.isSupportedAlgorithm(signatures, certificateKeyAlgorithm)) continue;
                certificateRequest.addCertificateType(certificateKeyAlgorithm);
            }
            this.wrapMessage(flight, certificateRequest);
            return true;
        }
        return false;
    }

    private SecretKey receivedClientKeyExchange(ECDHClientKeyExchange message) throws HandshakeException {
        try {
            DTLSSession session = this.getSession();
            SecretKey premasterSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
            byte[] seed = this.generateMasterSecretSeed();
            SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), premasterSecret, seed, session.useExtendedMasterSecret());
            SecretUtil.destroy(premasterSecret);
            return masterSecret;
        }
        catch (GeneralSecurityException ex) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
            throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
        }
    }

    private void receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.preSharedKeyIdentity = message.getIdentity();
        byte[] seed = this.generateMasterSecretSeed();
        this.requestPskSecretResult(this.preSharedKeyIdentity, null, seed);
    }

    private void receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException {
        SecretKey otherSecret = null;
        try {
            this.preSharedKeyIdentity = message.getIdentity();
            otherSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
            byte[] seed = this.generateMasterSecretSeed();
            this.requestPskSecretResult(this.preSharedKeyIdentity, otherSecret, seed);
        }
        catch (GeneralSecurityException ex) {
            try {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
            }
            catch (Throwable throwable) {
                SecretUtil.destroy(otherSecret);
                throw throwable;
            }
        }
        SecretUtil.destroy(otherSecret);
    }

    protected void addHelloExtensions(ClientHello clientHello, ServerHello serverHello) throws HandshakeException {
        boolean useDeprecatedCid;
        ConnectionIdExtension connectionIdExtension;
        ServerNameExtension serverNameExt;
        MaxFragmentLengthExtension maxFragmentLengthExt;
        RecordSizeLimitExtension recordSizeLimitExt;
        DTLSSession session = this.getSession();
        if (clientHello.hasExtendedMasterSecretExtension()) {
            if (this.extendedMasterSecretMode != ExtendedMasterSecretMode.NONE) {
                session.setExtendedMasterSecret(true);
                serverHello.addExtension(ExtendedMasterSecretExtension.INSTANCE);
            }
        } else if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.REQUIRED) {
            throw new HandshakeException("Extended Master Secret required!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (clientHello.hasRenegotiationInfo()) {
            if (this.secureRenegotiation != DtlsConfig.DtlsSecureRenegotiation.NONE) {
                serverHello.addExtension(RenegotiationInfoExtension.INSTANCE);
                session.setSecureRengotiation(true);
            }
        } else if (this.secureRenegotiation == DtlsConfig.DtlsSecureRenegotiation.NEEDED) {
            throw new HandshakeException("Secure renegotiation required!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (session.getCipherSuite().requiresServerCertificateMessage()) {
            CertificateTypeExtension ext;
            CertificateTypeExtension certificateTypeExtension;
            CertificateType certificateType;
            if (this.clientAuthenticationMode.useCertificateRequest() && (certificateType = session.receiveCertificateType()) != null && (certificateTypeExtension = clientHello.getClientCertificateTypeExtension()) != null && certificateTypeExtension.contains(certificateType)) {
                ext = new ClientCertificateTypeExtension(certificateType);
                serverHello.addExtension(ext);
            }
            if ((certificateType = session.sendCertificateType()) != null && (certificateTypeExtension = clientHello.getServerCertificateTypeExtension()) != null && certificateTypeExtension.contains(certificateType)) {
                ext = new ServerCertificateTypeExtension(certificateType);
                serverHello.addExtension(ext);
            }
        }
        if (session.getCipherSuite().isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            serverHello.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
        if ((recordSizeLimitExt = clientHello.getRecordSizeLimitExtension()) != null) {
            session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
            int limit = this.recordSizeLimit == null ? session.getMaxFragmentLength() : this.recordSizeLimit.intValue();
            serverHello.addExtension(new RecordSizeLimitExtension(limit));
            this.LOGGER.debug("Received record size limit [{} bytes] from peer [{}]", (Object)limit, this.peerToLog);
        }
        if (recordSizeLimitExt == null && (maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension()) != null) {
            session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHello.addExtension(maxFragmentLengthExt);
            this.LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), this.peerToLog);
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null && this.sniEnabled) {
            serverHello.addExtension(ServerNameExtension.emptyServerNameIndication());
        }
        if (this.supportsConnectionId() && (connectionIdExtension = clientHello.getConnectionIdExtension()) != null && (!(useDeprecatedCid = connectionIdExtension.useDeprecatedCid()) || this.supportDeprecatedCid)) {
            ConnectionId connectionId = this.getReadConnectionId();
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId, connectionIdExtension.getType());
            serverHello.addExtension(extension);
            DTLSContext context = this.getDtlsContext();
            context.setWriteConnectionId(connectionIdExtension.getConnectionId());
            context.setReadConnectionId(connectionId);
            context.setDeprecatedCid(useDeprecatedCid);
        }
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        if (clientVersion.compareTo(ProtocolVersion.VERSION_DTLS_1_2) >= 0) {
            return ProtocolVersion.VERSION_DTLS_1_2;
        }
        ProtocolVersion version = clientVersion;
        if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_0) < 0) {
            version = ProtocolVersion.VERSION_DTLS_1_0;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, version);
        throw new HandshakeException("The server only supports DTLS v1.2, not " + clientVersion + "!", alert);
    }

    private void negotiateCipherSuite(ClientHello clientHello) throws HandshakeException {
        CipherSuite cipherSuite;
        this.LOGGER.trace("Negotiate on: {}", (Object)this.cipherSuiteParameters);
        if (this.cipherSuiteSelector.select(this.cipherSuiteParameters)) {
            this.LOGGER.debug("Negotiated: {}", (Object)this.cipherSuiteParameters);
            DTLSSession session = this.getSession();
            cipherSuite = this.cipherSuiteParameters.getSelectedCipherSuite();
            session.setCipherSuite(cipherSuite);
            if (cipherSuite.requiresServerCertificateMessage()) {
                session.setSignatureAndHashAlgorithm(this.cipherSuiteParameters.getSelectedSignature());
                CertificateType certificateType = this.cipherSuiteParameters.getSelectedServerCertificateType();
                if (certificateType == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE);
                    throw new HandshakeException("No common server certificate type!", alert);
                }
                session.setSendCertificateType(certificateType);
                certificateType = this.cipherSuiteParameters.getSelectedClientCertificateType();
                if (this.clientAuthenticationMode == CertificateAuthenticationMode.NEEDED) {
                    if (certificateType == null) {
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE);
                        throw new HandshakeException("No common client certificate type!", alert);
                    }
                    session.setReceiveCertificateType(certificateType);
                } else if (this.clientAuthenticationMode == CertificateAuthenticationMode.WANTED && certificateType != null) {
                    session.setReceiveCertificateType(certificateType);
                }
            }
        } else {
            String summary;
            if (this.LOGGER_NEGOTIATION.isDebugEnabled()) {
                this.LOGGER_NEGOTIATION.debug("{}", (Object)clientHello);
                this.LOGGER_NEGOTIATION.debug("{}", (Object)this.cipherSuiteParameters.getMismatchDescription());
                this.LOGGER_NEGOTIATION.trace("Parameters: {}", (Object)this.cipherSuiteParameters);
            }
            if ((summary = this.cipherSuiteParameters.getMismatchSummary()) == null) {
                summary = "Client proposed unsupported cipher suites or parameters only";
            }
            this.cipherSuiteParameters = null;
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException(summary, alert);
        }
        this.LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", (Object)cipherSuite.name(), this.peerToLog);
    }

    private List<XECDHECryptography.SupportedGroup> getCommonSupportedGroups(SupportedEllipticCurvesExtension clientCurves) {
        ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>();
        if (clientCurves == null) {
            groups.addAll(this.supportedGroups);
        } else {
            for (XECDHECryptography.SupportedGroup group : clientCurves.getSupportedGroups()) {
                if (!this.supportedGroups.contains((Object)group)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    private SupportedPointFormatsExtension.ECPointFormat negotiateECPointFormat(SupportedPointFormatsExtension clientPointFormats) {
        if (clientPointFormats == null) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        if (clientPointFormats.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        return null;
    }

    private List<SignatureAndHashAlgorithm> getCommonSignatureAndHashAlgorithms(SignatureAlgorithmsExtension clientSignatureAndHashAlgorithms) {
        if (clientSignatureAndHashAlgorithms == null) {
            return new ArrayList<SignatureAndHashAlgorithm>(this.supportedSignatureAndHashAlgorithms);
        }
        return SignatureAndHashAlgorithm.getCommonSignatureAlgorithms(clientSignatureAndHashAlgorithms.getSupportedSignatureAndHashAlgorithms(), this.supportedSignatureAndHashAlgorithms);
    }

    private List<CipherSuite> getCommonCipherSuites(ClientHello clientHello) {
        List<CipherSuite> supported = this.supportedCipherSuites;
        CipherSuite sessionCipherSuite = this.getSession().getCipherSuite();
        if (sessionCipherSuite.isValidForNegotiation()) {
            supported = Arrays.asList(sessionCipherSuite);
        }
        return CipherSuite.preselectCipherSuites(supported, clientHello.getCipherSuites());
    }

    private List<CertificateType> getCommonClientCertificateTypes(ClientCertificateTypeExtension clientCertificateTypes) {
        List<CertificateType> supported = this.supportedClientCertificateTypes;
        Principal principal = this.getSession().getPeerIdentity();
        if (principal != null) {
            supported = new ArrayList<CertificateType>();
            if (principal instanceof RawPublicKeyIdentity) {
                supported.add(CertificateType.RAW_PUBLIC_KEY);
            } else if (principal instanceof X509CertPath) {
                supported.add(CertificateType.X_509);
            }
        }
        return ServerHandshaker.getCommonCertificateTypes(clientCertificateTypes, supported);
    }

    private List<CertificateType> getCommonServerCertificateTypes(ServerCertificateTypeExtension serverCertificateTypes) {
        return ServerHandshaker.getCommonCertificateTypes(serverCertificateTypes, this.supportedServerCertificateTypes);
    }

    private static List<CertificateType> getCommonCertificateTypes(CertificateTypeExtension certTypeExt, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            if (certTypeExt != null) {
                return certTypeExt.getCommonCertificateTypes(supportedCertificateTypes);
            }
            if (supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                return CertificateTypeExtension.DEFAULT_X509;
            }
        }
        return CertificateTypeExtension.EMPTY;
    }

    final CipherSuiteParameters getNegotiatedCipherSuiteParameters() {
        return this.cipherSuiteParameters;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.ecdhe);
        this.ecdhe = null;
    }
}

