/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;

public class ConnectionId
extends Bytes {
    public static final ConnectionId EMPTY = new ConnectionId(Bytes.EMPTY);

    public ConnectionId(byte[] connectionId) {
        super(connectionId);
    }

    public String toString() {
        return "CID=" + this.getAsString();
    }

    public static boolean supportsConnectionId(ConnectionIdGenerator generator) {
        return generator != null;
    }

    public static boolean useConnectionId(ConnectionIdGenerator generator) {
        return generator != null && generator.useConnectionId();
    }

    public static boolean useConnectionId(ConnectionId cid) {
        return Bytes.hasBytes((Bytes)cid);
    }

    public static ConnectionId create(Bytes bytes) {
        if (Bytes.isEmpty((Bytes)bytes)) {
            return null;
        }
        if (bytes instanceof ConnectionId) {
            return (ConnectionId)bytes;
        }
        return new ConnectionId(bytes.getBytes());
    }
}

