/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.FilteredLogger;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionEvictedException;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ConnectionStore;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryConnectionStore
implements ConnectionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryConnectionStore.class);
    private static final FilteredLogger WARN_FILTER = new FilteredLogger(LOGGER.getName(), 3L, TimeUnit.SECONDS.toNanos(10L));
    private static final int DEFAULT_SMALL_EXTRA_CID_LENGTH = 2;
    private static final int DEFAULT_LARGE_EXTRA_CID_LENGTH = 3;
    private static boolean SINGLE_SESSION_STORE = true;
    private final SessionStore sessionStore;
    protected final LeastRecentlyUpdatedCache<ConnectionId, Connection> connections;
    protected final ConcurrentMap<InetSocketAddress, Connection> connectionsByAddress;
    protected final ConcurrentMap<SessionId, Connection> connectionsByEstablishedSession;
    protected final ConcurrentMap<Principal, Connection> connectionsByPrincipal;
    private final AtomicBoolean shrinking = new AtomicBoolean();
    private volatile long shrinkTime;
    private volatile ExecutorService executor;
    private ConnectionListener connectionListener;
    private ConnectionIdGenerator connectionIdGenerator;
    protected String tag = "";

    public InMemoryConnectionStore(int capacity, long threshold, SessionStore sessionStore, boolean uniquePrincipals) {
        this.connections = new LeastRecentlyUpdatedCache(capacity, threshold, TimeUnit.SECONDS);
        this.connectionsByAddress = new ConcurrentHashMap<InetSocketAddress, Connection>();
        this.connectionsByPrincipal = uniquePrincipals ? new ConcurrentHashMap() : null;
        this.sessionStore = sessionStore;
        this.connectionsByEstablishedSession = SINGLE_SESSION_STORE && sessionStore != null ? null : new ConcurrentHashMap<SessionId, Connection>();
        this.connections.addEvictionListener((LeastRecentlyUpdatedCache.EvictionListener)new LeastRecentlyUpdatedCache.EvictionListener<Connection>(){

            public void onEviction(Connection staleConnection) {
                staleConnection.execute(() -> {
                    Handshaker handshaker = staleConnection.getOngoingHandshake();
                    if (handshaker != null) {
                        handshaker.handshakeFailed(new ConnectionEvictedException("Evicted!"));
                    }
                    InMemoryConnectionStore.this.connections.writeLock().lock();
                    try {
                        InMemoryConnectionStore.this.removeByAddressConnections(staleConnection);
                        InMemoryConnectionStore.this.removeByEstablishedSessions(staleConnection.getEstablishedSessionIdentifier(), staleConnection);
                        InMemoryConnectionStore.this.removeByPrincipal(staleConnection.getEstablishedPeerIdentity(), staleConnection);
                        ConnectionListener listener = InMemoryConnectionStore.this.connectionListener;
                        if (listener != null) {
                            listener.onConnectionRemoved(staleConnection);
                        }
                    }
                    finally {
                        InMemoryConnectionStore.this.connections.writeLock().unlock();
                    }
                });
            }
        });
        LOGGER.info("Created new InMemoryConnectionStore [capacity: {}, connection expiration threshold: {}s]", (Object)capacity, (Object)threshold);
    }

    public synchronized InMemoryConnectionStore setTag(String tag) {
        this.tag = StringUtil.normalizeLoggingTag((String)tag);
        return this;
    }

    private ConnectionId newConnectionId() {
        for (int i = 0; i < 10; ++i) {
            ConnectionId cid = this.connectionIdGenerator.createConnectionId();
            if (this.connections.get((Object)cid) != null) continue;
            return cid;
        }
        return null;
    }

    @Override
    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.connections.readLock();
    }

    @Override
    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.connections.writeLock();
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
    }

    @Override
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void attach(ConnectionIdGenerator connectionIdGenerator) {
        int bits;
        int cidLength;
        if (this.connectionIdGenerator != null) {
            throw new IllegalStateException("Connection id generator already attached!");
        }
        this.connectionIdGenerator = connectionIdGenerator == null || !connectionIdGenerator.useConnectionId() ? new SingleNodeConnectionIdGenerator(cidLength += (cidLength = ((bits = 32 - Integer.numberOfLeadingZeros(this.connections.getCapacity())) + 7) / 8) < 3 ? 2 : 3) : connectionIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Connection connection) {
        if (connection != null) {
            if (!connection.isExecuting()) {
                throw new IllegalStateException("Connection is not executing!");
            }
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                if (this.connectionIdGenerator == null) {
                    throw new IllegalStateException("Connection id generator must be attached before!");
                }
                connectionId = this.newConnectionId();
                if (connectionId == null) {
                    throw new IllegalStateException("Connection ids exhausted!");
                }
                connection.setConnectionId(connectionId);
            } else {
                if (connectionId.isEmpty()) {
                    throw new IllegalStateException("Connection must have a none empty connection id!");
                }
                if (this.connections.get((Object)connectionId) != null) {
                    throw new IllegalStateException("Connection id already used! " + (Object)((Object)connectionId));
                }
            }
            DTLSSession session = connection.getEstablishedSession();
            boolean success = false;
            this.connections.writeLock().lock();
            try {
                if (this.connections.put((Object)connectionId, (Object)connection)) {
                    connection.updateLastMessageNanos();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("{}connection: add {} (size {})", new Object[]{this.tag, connection, this.connections.size(), new Throwable("connection added!")});
                    } else {
                        LOGGER.debug("{}connection: add {} (size {})", new Object[]{this.tag, connectionId, this.connections.size()});
                    }
                    this.addToAddressConnections(connection);
                    if (session != null) {
                        this.addToPrincipalsConnections(session.getPeerIdentity(), connection, false);
                        this.addToEstablishedConnections(session.getSessionIdentifier(), connection);
                    }
                    success = true;
                } else {
                    WARN_FILTER.debug("{}connection store is full! {} max. entries.", new Object[]{this.tag, this.connections.getCapacity()});
                }
            }
            finally {
                this.connections.writeLock().unlock();
            }
            if (success && this.sessionStore != null && session != null) {
                this.sessionStore.put(session);
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Connection connection, InetSocketAddress newPeerAddress) {
        if (connection == null) {
            return false;
        }
        this.connections.writeLock().lock();
        try {
            if (this.connections.update((Object)connection.getConnectionId()) != null) {
                connection.updateLastMessageNanos();
                if (newPeerAddress == null) {
                    LOGGER.debug("{}connection: {} updated usage!", (Object)this.tag, (Object)connection.getConnectionId());
                } else if (!connection.equalsPeerAddress(newPeerAddress)) {
                    InetSocketAddress oldPeerAddress = connection.getPeerAddress();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("{}connection: {} updated, address changed from {} to {}!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)oldPeerAddress), StringUtil.toLog((SocketAddress)newPeerAddress), new Throwable("connection updated!")});
                    } else {
                        LOGGER.debug("{}connection: {} updated, address changed from {} to {}!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)oldPeerAddress), StringUtil.toLog((SocketAddress)newPeerAddress)});
                    }
                    if (oldPeerAddress != null) {
                        this.connectionsByAddress.remove(oldPeerAddress, connection);
                        connection.updatePeerAddress(null);
                    }
                    connection.updatePeerAddress(newPeerAddress);
                    this.addToAddressConnections(connection);
                }
                boolean bl = true;
                return bl;
            }
            LOGGER.debug("{}connection: {} - {} update failed!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)newPeerAddress)});
            boolean bl = false;
            return bl;
        }
        finally {
            this.connections.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEstablishedSession(Connection connection) {
        boolean hasSessionId;
        DTLSSession session = connection.getEstablishedSession();
        if (session == null) {
            throw new IllegalArgumentException("connection has no established session!");
        }
        ConnectionListener listener = this.connectionListener;
        if (listener != null) {
            listener.onConnectionEstablished(connection);
        }
        Principal principal = session.getPeerIdentity();
        SessionId sessionId = session.getSessionIdentifier();
        boolean bl = hasSessionId = !sessionId.isEmpty();
        if (principal != null || hasSessionId) {
            this.connections.writeLock().lock();
            try {
                this.addToPrincipalsConnections(principal, connection, false);
                this.addToEstablishedConnections(sessionId, connection);
            }
            finally {
                this.connections.writeLock().unlock();
            }
            if (hasSessionId && this.sessionStore != null) {
                this.sessionStore.put(session);
            }
        }
    }

    @Override
    public void removeFromEstablishedSessions(Connection connection) {
        SessionId sessionId = connection.getEstablishedSessionIdentifier();
        if (sessionId == null) {
            throw new IllegalArgumentException("connection has no established session!");
        }
        this.connections.writeLock().lock();
        try {
            this.removeByEstablishedSessions(sessionId, connection);
        }
        finally {
            this.connections.writeLock().unlock();
        }
    }

    @Override
    public DTLSSession find(SessionId id) {
        Connection connection;
        if (Bytes.isEmpty((Bytes)id)) {
            return null;
        }
        DTLSSession session = null;
        if (this.sessionStore != null) {
            session = this.sessionStore.get(id);
        }
        if ((connection = this.findLocally(id)) != null) {
            if (this.sessionStore == null) {
                DTLSSession establishedSession = connection.getEstablishedSession();
                if (establishedSession != null) {
                    session = new DTLSSession(establishedSession);
                }
            } else if (session == null) {
                this.remove(connection, false);
                return null;
            }
        }
        return session;
    }

    private Connection findLocally(SessionId id) {
        if (id == null) {
            throw new NullPointerException("DTLS Session ID must not be null!");
        }
        if (this.connectionsByEstablishedSession == null) {
            return null;
        }
        Connection connection = (Connection)this.connectionsByEstablishedSession.get((Object)id);
        if (connection != null) {
            SessionId establishedId = connection.getEstablishedSessionIdentifier();
            if (establishedId != null) {
                if (!id.equals((Object)establishedId)) {
                    LOGGER.warn("{}connection {} changed session {}!={}!", new Object[]{this.tag, connection.getConnectionId(), id, establishedId});
                }
            } else {
                LOGGER.warn("{}connection {} lost session {}!", new Object[]{this.tag, connection.getConnectionId(), id});
            }
            if (this.connections.update((Object)connection.getConnectionId()) != null) {
                connection.updateLastMessageNanos();
            }
        }
        return connection;
    }

    @Override
    public void markAllAsResumptionRequired() {
        for (Connection connection : this.connections.values()) {
            if (connection.getPeerAddress() == null || connection.isResumptionRequired()) continue;
            connection.setResumptionRequired(true);
            LOGGER.trace("{}connection: mark for resumption {}!", (Object)this.tag, (Object)connection);
        }
    }

    @Override
    public int remainingCapacity() {
        int remaining = this.connections.remainingCapacity();
        LOGGER.debug("{}connection: size {}, remaining {}!", new Object[]{this.tag, this.connections.size(), remaining});
        return remaining;
    }

    @Override
    public void shrink(int calls, AtomicBoolean running) {
        int size;
        if (this.connectionsByPrincipal != null && 1024 < (size = this.connections.size())) {
            int unique = this.connectionsByPrincipal.size();
            if (unique * 2 < size || calls % 12 == 9) {
                if (this.shrinking.compareAndSet(false, true)) {
                    LOGGER.info("{}: start shrinking {}/{}", new Object[]{this.tag, unique, size});
                    this.shrink(running, false);
                } else {
                    LOGGER.info("{}: shrinking {}/{} ...", new Object[]{this.tag, unique, size});
                }
            } else {
                LOGGER.info("{}: no shrinking {}/{}", new Object[]{this.tag, unique, size});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrink(AtomicBoolean running, boolean full) {
        int loops = 0;
        int count = 0;
        int log = Math.max(10000, this.connections.size() / 5);
        Throwable error = null;
        this.shrinkTime = ClockUtil.nanoRealtime();
        Iterator iterator = this.connections.ascendingIterator();
        try {
            while (running.get() && iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                if (++loops % log == 0) {
                    LOGGER.info("{}shrink {}: {}", new Object[]{this.tag, loops, connection.getConnectionId()});
                }
                if (!connection.isDouble()) continue;
                if (this.connections.isStale((Object)connection.getConnectionId())) {
                    connection.execute(() -> this.remove(connection, false));
                    ++count;
                    continue;
                }
                if (full) continue;
                break;
            }
        }
        catch (Throwable ex) {
            try {
                error = ex;
            }
            catch (Throwable throwable) {
                this.shrinkTime = ClockUtil.nanoRealtime() - this.shrinkTime;
                int size = this.connections.size();
                int unique = this.connectionsByPrincipal.size();
                if (error != null) {
                    LOGGER.error("{}: shrinking failed, {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
                } else if (count > 0) {
                    LOGGER.info("{}: shrinked {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
                } else {
                    LOGGER.info("{}: nothing shrinked, {}/{} in {} ms", new Object[]{this.tag, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
                }
                this.shrinking.set(false);
                throw throwable;
            }
            this.shrinkTime = ClockUtil.nanoRealtime() - this.shrinkTime;
            int size = this.connections.size();
            int unique = this.connectionsByPrincipal.size();
            if (error != null) {
                LOGGER.error("{}: shrinking failed, {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
            } else if (count > 0) {
                LOGGER.info("{}: shrinked {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
            } else {
                LOGGER.info("{}: nothing shrinked, {}/{} in {} ms", new Object[]{this.tag, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
            }
            this.shrinking.set(false);
        }
        this.shrinkTime = ClockUtil.nanoRealtime() - this.shrinkTime;
        int size = this.connections.size();
        int unique = this.connectionsByPrincipal.size();
        if (error != null) {
            LOGGER.error("{}: shrinking failed, {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
        } else if (count > 0) {
            LOGGER.info("{}: shrinked {} of {}/{} in {} ms", new Object[]{this.tag, count, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
        } else {
            LOGGER.info("{}: nothing shrinked, {}/{} in {} ms", new Object[]{this.tag, unique, size, TimeUnit.NANOSECONDS.toMillis(this.shrinkTime), error});
        }
        this.shrinking.set(false);
    }

    @Override
    public Connection get(InetSocketAddress peerAddress) {
        Connection connection = (Connection)this.connectionsByAddress.get(peerAddress);
        if (connection == null) {
            LOGGER.trace("{}connection: missing connection for {}!", (Object)this.tag, StringUtil.toLog((SocketAddress)peerAddress));
        } else {
            InetSocketAddress address = connection.getPeerAddress();
            if (address == null) {
                LOGGER.warn("{}connection {} lost ip-address {}!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)peerAddress)});
            } else if (!address.equals(peerAddress)) {
                LOGGER.warn("{}connection {} changed ip-address {}!={}!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)peerAddress), StringUtil.toLog((SocketAddress)address)});
            }
        }
        return connection;
    }

    @Override
    public Connection get(ConnectionId cid) {
        Connection connection = (Connection)this.connections.get((Object)cid);
        if (connection == null) {
            LOGGER.debug("{}connection: missing connection for {}!", (Object)this.tag, (Object)cid);
        } else {
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                LOGGER.warn("{}connection lost cid {}!", (Object)this.tag, (Object)cid);
            } else if (!connectionId.equals((Object)cid)) {
                LOGGER.warn("{}connection changed cid {}!={}!", new Object[]{this.tag, connectionId, cid});
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Connection connection, boolean removeFromSessionCache) {
        boolean removed;
        DTLSSession session = connection.getEstablishedSession();
        SessionId sessionId = session == null ? null : session.getSessionIdentifier();
        Principal principal = session == null ? null : session.getPeerIdentity();
        this.connections.writeLock().lock();
        try {
            boolean bl = removed = this.connections.remove((Object)connection.getConnectionId(), (Object)connection) == connection;
            if (removed) {
                int pendings = connection.shutdown();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}connection: remove {} (size {}, left jobs: {})", new Object[]{this.tag, connection, this.connections.size(), pendings, new Throwable("connection removed!")});
                } else if (pendings == 0) {
                    LOGGER.debug("{}connection: remove {} (size {})", new Object[]{this.tag, connection, this.connections.size()});
                } else {
                    LOGGER.debug("{}connection: remove {} (size {}, left jobs: {})", new Object[]{this.tag, connection, this.connections.size(), pendings});
                }
                connection.startByClientHello(null);
                this.removeByAddressConnections(connection);
                this.removeByEstablishedSessions(sessionId, connection);
                this.removeByPrincipal(principal, connection);
                ConnectionListener listener = this.connectionListener;
                if (listener != null) {
                    listener.onConnectionRemoved(connection);
                }
                SecretUtil.destroy(connection.getDtlsContext());
            }
        }
        finally {
            this.connections.writeLock().unlock();
        }
        if (removeFromSessionCache) {
            this.removeSessionFromStore(sessionId);
        }
        return removed;
    }

    private void removeByEstablishedSessions(SessionId sessionId, Connection connection) {
        if (this.connectionsByEstablishedSession != null && Bytes.hasBytes((Bytes)sessionId)) {
            this.connectionsByEstablishedSession.remove((Object)sessionId, connection);
        }
    }

    private void removeByPrincipal(Principal principal, Connection connection) {
        if (this.connectionsByPrincipal != null && principal != null) {
            this.connectionsByPrincipal.remove(principal, connection);
        }
    }

    private void removeByAddressConnections(Connection connection) {
        InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            this.connectionsByAddress.remove(peerAddress, connection);
            connection.updatePeerAddress(null);
        }
    }

    private void removeSessionFromStore(SessionId sessionId) {
        if (this.sessionStore != null && Bytes.hasBytes((Bytes)sessionId)) {
            this.sessionStore.remove(sessionId);
        }
    }

    private void addToAddressConnections(Connection connection) {
        InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            Connection previous = this.connectionsByAddress.put(peerAddress, connection);
            if (previous != null && previous != connection) {
                LOGGER.debug("{}connection: {} - {} added! {} removed from address.", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)peerAddress), previous.getConnectionId()});
                previous.execute(() -> {
                    if (previous.equalsPeerAddress(peerAddress)) {
                        boolean internalRemove;
                        previous.updatePeerAddress(null);
                        boolean fullRemove = previous.getEstablishedPeerIdentity() == null;
                        boolean bl = internalRemove = !previous.expectCid() && (this.connectionsByEstablishedSession == null || Bytes.isEmpty((Bytes)previous.getEstablishedSessionIdentifier()));
                        if (fullRemove || internalRemove) {
                            this.remove(previous, fullRemove);
                        }
                    }
                });
            } else {
                LOGGER.debug("{}connection: {} - {} added!", new Object[]{this.tag, connection.getConnectionId(), StringUtil.toLog((SocketAddress)peerAddress)});
            }
        } else {
            LOGGER.debug("{}connection: {} - missing address!", (Object)this.tag, (Object)connection.getConnectionId());
        }
    }

    private boolean addToEstablishedConnections(SessionId sessionId, Connection connection) {
        Connection previous;
        if (this.connectionsByEstablishedSession != null && !sessionId.isEmpty() && (previous = this.connectionsByEstablishedSession.put(sessionId, connection)) != null && previous != connection) {
            this.removePreviousConnection("session", previous);
            return true;
        }
        return false;
    }

    private boolean addToPrincipalsConnections(Principal principal, Connection connection, boolean removePrevious) {
        if (this.connectionsByPrincipal != null && principal != null) {
            if (principal instanceof ExtensiblePrincipal && ((ExtensiblePrincipal)principal).isAnonymous()) {
                return false;
            }
            Connection previous = this.connectionsByPrincipal.put(principal, connection);
            if (previous != null && previous != connection) {
                if (removePrevious) {
                    this.removePreviousConnection("principal", previous);
                    return true;
                }
                previous.setDouble();
                previous.getEstablishedSession().setPeerIdentity(principal);
            }
        }
        return false;
    }

    private void removePreviousConnection(String cause, Connection connection) {
        connection.execute(() -> {
            LOGGER.debug("{}Remove connection from {}", (Object)this.tag, (Object)cause);
            this.remove(connection, false);
        }, true);
    }

    @Override
    public final void clear() {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow();
        }
        this.connections.clear();
        if (this.connectionsByEstablishedSession != null) {
            this.connectionsByEstablishedSession.clear();
        }
        this.connectionsByAddress.clear();
    }

    @Override
    public final void stop(List<Runnable> pending) {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow(pending);
        }
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.connections.valuesIterator();
    }

    @Override
    public int saveConnections(OutputStream out, long maxQuietPeriodInSeconds) throws IOException {
        int size = this.connections.size();
        int progress = size / 20;
        int count = 0;
        DatagramWriter writer = new DatagramWriter(4096);
        long startNanos = ClockUtil.nanoRealtime();
        boolean writeProgress = false;
        long progressNanos = startNanos;
        Iterator iterator = this.connections.ascendingIterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            long updateNanos = connection.getLastMessageNanos();
            long quiet = TimeUnit.NANOSECONDS.toSeconds(startNanos - updateNanos);
            if (quiet > maxQuietPeriodInSeconds) {
                LOGGER.trace("{}skip {} ts, {}s too quiet! {}", new Object[]{this.tag, updateNanos, quiet, connection.getConnectionId()});
                continue;
            }
            LOGGER.trace("{}write {} ts, {}s {}", new Object[]{this.tag, updateNanos, quiet, connection.getConnectionId()});
            if (connection.writeTo(writer)) {
                writer.writeTo(out);
                ++count;
            } else {
                writer.reset();
            }
            if (progress > 100 && count % progress == 0) {
                writeProgress = true;
            }
            if (!writeProgress) continue;
            long now = ClockUtil.nanoRealtime();
            if (!writeProgress || now - progressNanos <= TimeUnit.SECONDS.toNanos(2L)) continue;
            LOGGER.info("{}written {} connections of {}", new Object[]{this.tag, count, size});
            writeProgress = false;
            progressNanos = now;
        }
        SerializationUtil.writeNoItem((OutputStream)out);
        out.flush();
        writer.close();
        this.clear();
        return count;
    }

    @Override
    public int loadConnections(InputStream in, long delta) throws IOException {
        boolean clear = true;
        int count = 0;
        long startNanos = ClockUtil.nanoRealtime();
        DataStreamReader reader = new DataStreamReader(in);
        long progressNanos = startNanos;
        try {
            Connection connection;
            while ((connection = Connection.fromReader(reader, delta)) != null) {
                long now;
                boolean restore = true;
                long lastUpdate = connection.getLastMessageNanos();
                if (lastUpdate - startNanos > 0L) {
                    WARN_FILTER.warn("{}read {} ts is after {} (future)", new Object[]{this.tag, lastUpdate, startNanos});
                } else if (connection.isDouble()) {
                    boolean bl = restore = !this.connections.isStale((Object)connection.getConnectionId());
                }
                if (restore) {
                    LOGGER.trace("{}read {} ts, {}s {}", new Object[]{this.tag, lastUpdate, TimeUnit.NANOSECONDS.toSeconds(startNanos - lastUpdate), connection.getConnectionId()});
                    this.restore(connection);
                    ++count;
                }
                if ((now = ClockUtil.nanoRealtime()) - progressNanos <= TimeUnit.SECONDS.toNanos(2L)) continue;
                LOGGER.info("{}read {} connections", (Object)this.tag, (Object)count);
                progressNanos = now;
            }
            clear = false;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("{}reading failed after {} connections", new Object[]{this.tag, count, ex});
            this.clear();
            throw ex;
        }
        finally {
            if (clear) {
                this.clear();
                count = 0;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(Connection connection) {
        ConnectionId connectionId = connection.getConnectionId();
        if (connectionId == null) {
            throw new IllegalStateException("Connection must have a connection id!");
        }
        if (connectionId.isEmpty()) {
            throw new IllegalStateException("Connection must have a none empty connection id!");
        }
        if (this.connections.get((Object)connectionId) != null) {
            throw new IllegalStateException("Connection id already used! " + (Object)((Object)connectionId));
        }
        boolean restored = false;
        this.connections.writeLock().lock();
        try {
            if (this.connections.put((Object)connectionId, (Object)connection, connection.getLastMessageNanos())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}connection: restore {} (size {})", new Object[]{this.tag, connection, this.connections.size(), new Throwable("connection restored!")});
                } else {
                    LOGGER.debug("{}connection: restore {} (size {})", new Object[]{this.tag, connectionId, this.connections.size()});
                }
                this.addToAddressConnections(connection);
                if (!connection.isExecuting()) {
                    connection.setConnectorContext(this.executor, this.connectionListener);
                }
                restored = true;
            } else {
                LOGGER.warn("{}connection store is full! {} max. entries.", (Object)this.tag, (Object)this.connections.getCapacity());
            }
        }
        finally {
            this.connections.writeLock().unlock();
        }
        if (restored && connection.hasEstablishedDtlsContext()) {
            this.putEstablishedSession(connection);
        }
        return restored;
    }
}

