/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.TlsKeyLog;
import org.eclipse.californium.scandium.dtls.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsKeyLogFile
implements TlsKeyLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsKeyLogFile.class);
    private static final Map<String, TlsKeyLogFile> map = new HashMap<String, TlsKeyLogFile>(16);
    private File file;
    private OutputStream out;

    public TlsKeyLogFile(String filename) {
        this.file = new File(filename);
        this.open();
    }

    public synchronized OutputStream open() {
        this.delete();
        try {
            this.out = new FileOutputStream(this.file);
            LOGGER.info("TLSKEYLOG: {} created", (Object)this.file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("TLSKEYLOG: create", (Throwable)e);
        }
        return this.out;
    }

    public synchronized void delete() {
        this.close();
        this.file.delete();
    }

    private synchronized OutputStream getOutputStream() {
        return this.out;
    }

    private byte[] format(Random clientRandom, SecretKey masterSecret) {
        StringBuffer buffer = new StringBuffer("CLIENT_RANDOM ");
        buffer.append(clientRandom.getAsString());
        buffer.append(' ');
        buffer.append(StringUtil.byteArray2Hex((byte[])masterSecret.getEncoded()));
        buffer.append(StringUtil.lineSeparator());
        return buffer.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(InetSocketAddress source, Principal principal, Random clientRandom, SecretKey masterSecret) {
        OutputStream out = this.getOutputStream();
        if (out != null) {
            byte[] line = this.format(clientRandom, masterSecret);
            TlsKeyLogFile tlsKeyLogFile = this;
            synchronized (tlsKeyLogFile) {
                if (this.file.length() > 10000L && (out = this.open()) == null) {
                    return;
                }
                try {
                    out.write(line);
                    out.flush();
                }
                catch (IOException e) {
                    LOGGER.warn("TLSKEYLOG: write", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized void close() {
        OutputStream out = this.out;
        if (out != null) {
            this.out = null;
            try {
                out.close();
            }
            catch (IOException e) {
                LOGGER.warn("TLSKEYLOG: close", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TlsKeyLogFile get(String name) {
        Map<String, TlsKeyLogFile> map = TlsKeyLogFile.map;
        synchronized (map) {
            TlsKeyLogFile file = TlsKeyLogFile.map.get(name);
            if (file == null) {
                file = new TlsKeyLogFile(name);
                TlsKeyLogFile.map.put(name, file);
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Map<String, TlsKeyLogFile> map = TlsKeyLogFile.map;
        synchronized (map) {
            for (TlsKeyLogFile file : TlsKeyLogFile.map.values()) {
                file.delete();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("TLSKEYLOG-SHUTDOWN"){

            @Override
            public void run() {
                TlsKeyLogFile.closeAll();
            }
        });
    }
}

