/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public class DtlsHealthLogger
extends CounterStatisticManager
implements DtlsHealth {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(DTLSConnector.class.getCanonicalName() + ".health"));
    public static final String DROPPED_UDP_MESSAGES = "dropped udp messages";
    private volatile int maxConnections = 0;
    protected final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final SimpleCounterStatistic connections = new SimpleCounterStatistic("associations", this.align);
    private final SimpleCounterStatistic pendingHandshakes = new SimpleCounterStatistic("handshakes pending", this.align);
    private final SimpleCounterStatistic succeededHandshakes = new SimpleCounterStatistic("handshakes succeeded", this.align);
    private final SimpleCounterStatistic failedHandshakes = new SimpleCounterStatistic("handshakes failed", this.align);
    private final SimpleCounterStatistic receivedRecords = new SimpleCounterStatistic("received records", this.align);
    private final SimpleCounterStatistic droppedReceivedRecords = new SimpleCounterStatistic("dropped received records", this.align);
    private final SimpleCounterStatistic droppedReceivedMacErrors = new SimpleCounterStatistic("dropped received mac-errors", this.align);
    private final SimpleCounterStatistic sentRecords = new SimpleCounterStatistic("sending records", this.align);
    private final SimpleCounterStatistic droppedSentRecords = new SimpleCounterStatistic("dropped sending records", this.align);
    private final SimpleCounterStatistic droppedMessages = new SimpleCounterStatistic("dropped udp messages", this.align);
    private final SimpleCounterStatistic pendingIncoming = new SimpleCounterStatistic("pending in jobs", this.align);
    private final SimpleCounterStatistic pendingOutgoing = new SimpleCounterStatistic("pending out jobs", this.align);
    private final SimpleCounterStatistic pendingHandshakeJobs = new SimpleCounterStatistic("pending handshake jobs", this.align);
    private final SimpleCounterStatistic missingAuthorizations = new SimpleCounterStatistic("application missing authorizations", this.align);
    private final SimpleCounterStatistic rejectedAuthorizations = new SimpleCounterStatistic("application rejected authorizations", this.align);

    public DtlsHealthLogger() {
        this("");
    }

    public DtlsHealthLogger(String tag) {
        super(tag);
        this.init();
    }

    private void init() {
        this.add(this.connections);
        this.add(this.pendingHandshakes);
        this.add(this.succeededHandshakes);
        this.add(this.failedHandshakes);
        this.add(this.receivedRecords);
        this.add(this.droppedReceivedRecords);
        this.add(this.droppedReceivedMacErrors);
        this.add(this.sentRecords);
        this.add(this.droppedSentRecords);
        this.add(this.droppedMessages);
        this.add(this.pendingIncoming);
        this.add(this.pendingOutgoing);
        this.add(this.pendingHandshakeJobs);
        this.add(this.missingAuthorizations);
        this.add(this.rejectedAuthorizations);
    }

    @Override
    public void dump() {
        try {
            if (this.isEnabled()) {
                if (this.isUsed() && LOGGER.isDebugEnabled()) {
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + this.tag;
                    StringBuilder log = new StringBuilder();
                    long remainingCapacity = (long)this.maxConnections - this.connections.getCounter();
                    log.append(this.tag).append("dtls statistic:").append(eol);
                    log.append(head).append(this.connections).append(" (").append(remainingCapacity).append(" remaining capacity).").append(eol);
                    log.append(head).append(this.pendingHandshakes).append(eol);
                    log.append(head).append(this.succeededHandshakes).append(eol);
                    log.append(head).append(this.failedHandshakes).append(eol);
                    log.append(head).append(this.sentRecords).append(eol);
                    log.append(head).append(this.droppedSentRecords).append(eol);
                    log.append(head).append(this.receivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedRecords).append(eol);
                    log.append(head).append(this.droppedReceivedMacErrors);
                    if (this.droppedMessages.isStarted()) {
                        log.append(eol).append(head).append(this.droppedMessages);
                    }
                    log.append(eol).append(head).append(this.pendingIncoming);
                    log.append(eol).append(head).append(this.pendingOutgoing);
                    log.append(eol).append(head).append(this.pendingHandshakeJobs);
                    if (this.rejectedAuthorizations.isStarted() || this.missingAuthorizations.isStarted()) {
                        log.append(eol).append(head).append(this.missingAuthorizations);
                        log.append(eol).append(head).append(this.rejectedAuthorizations);
                    }
                    this.dump(head, log);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)this.tag, (Object)e);
        }
    }

    protected boolean isUsed() {
        return this.receivedRecords.isUsed() || this.sentRecords.isUsed();
    }

    protected void dump(String head, StringBuilder log) {
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    @Override
    public void startHandshake() {
        this.pendingHandshakes.increment();
    }

    @Override
    public void endHandshake(boolean success) {
        this.pendingHandshakes.decrement();
        if (success) {
            this.succeededHandshakes.increment();
        } else {
            this.failedHandshakes.increment();
        }
    }

    @Override
    public void receivingRecord(boolean drop) {
        if (drop) {
            this.droppedReceivedRecords.increment();
        } else {
            this.receivedRecords.increment();
        }
    }

    @Override
    public void sendingRecord(boolean drop) {
        if (drop) {
            this.droppedSentRecords.increment();
        } else {
            this.sentRecords.increment();
        }
    }

    @Override
    public void receivingMacError() {
        this.droppedReceivedMacErrors.increment();
    }

    @Override
    public void setMaxConnections(int max) {
        this.maxConnections = max;
    }

    @Override
    public void setConnections(int count) {
        this.connections.set((long)count);
    }

    @Override
    public void setPendingIncomingJobs(int count) {
        this.pendingIncoming.set((long)count);
    }

    @Override
    public void setPendingOutgoingJobs(int count) {
        this.pendingOutgoing.set((long)count);
    }

    @Override
    public void setPendingHandshakeJobs(int count) {
        this.pendingHandshakeJobs.set((long)count);
    }

    @Override
    public void applicationAuthorizationRejected(boolean rejected) {
        if (rejected) {
            this.rejectedAuthorizations.increment();
        } else {
            this.missingAuthorizations.increment();
        }
    }
}

