/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsClusterConnector;
import org.eclipse.californium.scandium.config.DtlsClusterConnectorConfig;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionStore;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionAdapter;
import org.eclipse.californium.scandium.dtls.pskstore.SinglePskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtlsManagedClusterConnector
extends DtlsClusterConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtlsManagedClusterConnector.class);
    public static final String PROTOCOL_MANAGEMENT_UDP = "mgmt-udp";
    public static final String PROTOCOL_MANAGEMENT_DTLS = "mgmt-dtls";
    public static final String PROTOCOL_MANAGEMENT_DTLS_MAC = "mgmt-dtls-mac";
    private final String protocol;
    private final boolean useClusterMac;
    private final Connector clusterManagementConnector;

    public DtlsManagedClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration) {
        this(configuration, clusterConfiguration, DtlsManagedClusterConnector.createConnectionStore(configuration));
    }

    protected DtlsManagedClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration, ConnectionStore connectionStore) {
        super(configuration, clusterConfiguration, connectionStore, false);
        String identity = clusterConfiguration.getSecureIdentity();
        Integer mgmtReceiveBuffer = DtlsManagedClusterConnector.addConditionally((Integer)this.config.get(DtlsConfig.DTLS_RECEIVE_BUFFER_SIZE), 28);
        Integer mgmtSendBuffer = DtlsManagedClusterConnector.addConditionally((Integer)this.config.get(DtlsConfig.DTLS_SEND_BUFFER_SIZE), 28);
        if (identity != null) {
            SecretKey secretkey = clusterConfiguration.getSecretKey();
            String tag = configuration.getLoggingTag();
            if (tag == null || tag.isEmpty()) {
                tag = "dtls-cluster-mgmt";
            } else {
                tag = StringUtil.normalizeLoggingTag((String)tag);
                tag = tag + "dtls-cluster-mgmt";
            }
            DtlsConnectorConfig.Builder builder = DtlsConnectorConfig.builder(configuration.getConfiguration()).setLoggingTag(tag).set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, 500, TimeUnit.MILLISECONDS).set(DtlsConfig.DTLS_MAX_RETRANSMISSIONS, 3).set(DtlsConfig.DTLS_RETRANSMISSION_BACKOFF, 0).set(DtlsConfig.DTLS_MAX_CONNECTIONS, 1024).set(DtlsConfig.DTLS_RECEIVER_THREAD_COUNT, 0).set(DtlsConfig.DTLS_RECEIVE_BUFFER_SIZE, mgmtReceiveBuffer).set(DtlsConfig.DTLS_SEND_BUFFER_SIZE, mgmtSendBuffer).set(DtlsConfig.DTLS_ROLE, DtlsConfig.DtlsRole.BOTH).setAddress(clusterConfiguration.getAddress()).setPskStore(new SinglePskStore(identity, secretkey)).setConnectionListener(new ConnectionListener(){

                @Override
                public void updateExecution(Connection connection) {
                }

                @Override
                public boolean onConnectionUpdatesSequenceNumbers(Connection connection, boolean writeSequenceNumber) {
                    return false;
                }

                @Override
                public void onConnectionRemoved(Connection connection) {
                    LOGGER.info("cluster-node {}: lost connection {}!", (Object)DtlsManagedClusterConnector.this.getNodeID(), (Object)connection.getPeerAddress());
                }

                @Override
                public boolean onConnectionMacError(Connection connection) {
                    return false;
                }

                @Override
                public void onConnectionEstablished(Connection connection) {
                }

                @Override
                public void beforeExecution(Connection connection) {
                }

                @Override
                public void afterExecution(Connection connection) {
                }
            });
            SecretUtil.destroy(secretkey);
            this.clusterManagementConnector = new ClusterManagementDtlsConnector(builder.build());
            this.useClusterMac = clusterConfiguration.useClusterMac();
            this.protocol = this.useClusterMac ? PROTOCOL_MANAGEMENT_DTLS_MAC : PROTOCOL_MANAGEMENT_DTLS;
        } else {
            Configuration config = new Configuration();
            config.set((BasicDefinition)UdpConfig.UDP_RECEIVER_THREAD_COUNT, (Object)0);
            config.set((BasicDefinition)UdpConfig.UDP_SENDER_THREAD_COUNT, (Object)2);
            config.set((BasicDefinition)UdpConfig.UDP_RECEIVE_BUFFER_SIZE, (Object)mgmtReceiveBuffer);
            config.set((BasicDefinition)UdpConfig.UDP_SEND_BUFFER_SIZE, (Object)mgmtSendBuffer);
            ClusterManagementUdpConnector udpConnector = new ClusterManagementUdpConnector(clusterConfiguration.getAddress(), config);
            this.clusterManagementConnector = udpConnector;
            this.useClusterMac = false;
            this.protocol = PROTOCOL_MANAGEMENT_UDP;
        }
        LOGGER.info("cluster-node {} ({}): recv. buffer {}, send buffer {}", new Object[]{this.getNodeID(), this.protocol, mgmtReceiveBuffer, mgmtSendBuffer});
    }

    @Override
    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        super.init(bindAddress, socket, mtu);
        this.clusterManagementConnector.start();
        this.startReceiver();
    }

    @Override
    public void stop() {
        super.stop();
        this.clusterManagementConnector.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.clusterManagementConnector.destroy();
    }

    @Override
    protected int getClusterMacLength() {
        return this.useClusterMac ? 8 : 0;
    }

    public String getManagementProtocol() {
        return this.protocol;
    }

    public Connector getClusterManagementConnector() {
        return this.clusterManagementConnector;
    }

    @Override
    protected void processDatagramFromClusterNetwork(Byte type, DatagramPacket clusterPacket) throws IOException {
        if (this.useClusterMac) {
            try {
                DTLSContext context = ((DTLSConnector)this.clusterManagementConnector).getDtlsContextByAddress((InetSocketAddress)clusterPacket.getSocketAddress());
                if (context == null) {
                    throw new IOException("Cluster MAC could not be validated! Missing DTLS context.");
                }
                Mac mac = context.getThreadLocalClusterReadMac();
                if (mac == null) {
                    throw new IOException("Cluster MAC could not be validated! Missing keys.");
                }
                if (!DtlsManagedClusterConnector.validateClusterMac(mac, clusterPacket)) {
                    if (LOGGER.isInfoEnabled()) {
                        byte[] mac2 = Arrays.copyOf(DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket), 8);
                        byte[] data = clusterPacket.getData();
                        int offset = clusterPacket.getOffset();
                        int macOffset = 4 + (data[offset + 3] & 0xFF);
                        byte[] mac3 = Arrays.copyOfRange(data, offset + macOffset, offset + macOffset + 8);
                        LOGGER.info("cluster-node {} ({}): drop internal record, cluster MAC failure! {} != {}", new Object[]{this.getNodeID(), this.protocol, StringUtil.byteArray2Hex((byte[])mac2), StringUtil.byteArray2Hex((byte[])mac3)});
                    }
                    if (this.clusterHealth != null) {
                        if (RECORD_TYPE_INCOMING.equals(type)) {
                            this.clusterHealth.badForwardMessage();
                        } else if (RECORD_TYPE_OUTGOING.equals(type)) {
                            this.clusterHealth.badBackwardMessage();
                        }
                    }
                    return;
                }
            }
            catch (RuntimeException ex) {
                LOGGER.debug("cluster-node {} ({}): receiving failed!", new Object[]{this.getNodeID(), this.protocol, ex});
                throw new IOException("Cluster MAC could not be validated!", ex);
            }
        }
        super.processDatagramFromClusterNetwork(type, clusterPacket);
    }

    @Override
    protected void sendDatagramToClusterNetwork(DatagramPacket clusterPacket) throws IOException {
        if (this.useClusterMac) {
            try {
                DTLSContext context = ((DTLSConnector)this.clusterManagementConnector).getDtlsContextByAddress((InetSocketAddress)clusterPacket.getSocketAddress());
                if (context == null) {
                    throw new IOException("Cluster MAC could not be generated! Missing dtls context.");
                }
                Mac mac = context.getThreadLocalClusterWriteMac();
                if (mac == null) {
                    throw new IOException("Cluster MAC could not be generated! Missing keys.");
                }
                DtlsManagedClusterConnector.setClusterMac(mac, clusterPacket);
            }
            catch (RuntimeException ex) {
                LOGGER.debug("cluster-node {} ({}): sending failed!", new Object[]{this.getNodeID(), this.protocol, ex});
                throw new IOException("Cluster MAC could not be generated!", ex);
            }
        }
        super.sendDatagramToClusterNetwork(clusterPacket);
    }

    public static boolean validateClusterMac(Mac mac, DatagramPacket clusterPacket) {
        byte[] macBytes = DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket);
        byte[] data = clusterPacket.getData();
        int offset = clusterPacket.getOffset();
        int macOffset = offset + 4 + (data[offset + 3] & 0xFF);
        int diffs = 0;
        for (int index = 0; index < 8; ++index) {
            if (macBytes[index] == data[macOffset + index]) continue;
            ++diffs;
        }
        return diffs == 0;
    }

    public static void setClusterMac(Mac mac, DatagramPacket clusterPacket) {
        byte[] macBytes = DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket);
        byte[] data = clusterPacket.getData();
        int offset = clusterPacket.getOffset();
        int macOffset = 4 + (data[offset + 3] & 0xFF);
        System.arraycopy(macBytes, 0, data, offset + macOffset, 8);
    }

    public static byte[] calculateClusterMac(Mac mac, DatagramPacket clusterPacket) {
        int length;
        int offset;
        byte[] data = clusterPacket.getData();
        int macOffset = 4 + (data[(offset = clusterPacket.getOffset()) + 3] & 0xFF);
        int headerOffset = macOffset + 8;
        if (headerOffset < (length = clusterPacket.getLength())) {
            mac.update(data, offset, macOffset);
            if ((length -= headerOffset) > 0) {
                offset += headerOffset;
                if (length > 64 - macOffset) {
                    mac.update(data, offset, 32);
                    offset += length - 32;
                    length = 32;
                }
                mac.update(data, offset, length);
            }
            return mac.doFinal();
        }
        throw new IllegalArgumentException(length + " bytes is too small for cluster MAC message!");
    }

    @Override
    protected void processManagementDatagramFromClusterNetwork(DatagramPacket clusterPacket) throws IOException {
        LOGGER.trace("cluster-node {} ({}): process datagram from {}, {} bytes", new Object[]{this.getNodeID(), this.protocol, clusterPacket.getAddress(), clusterPacket.getLength()});
        this.clusterManagementConnector.processDatagram(clusterPacket);
    }

    private static Integer addConditionally(Integer value, int add) {
        if (value != null && value != 0) {
            return value + add;
        }
        return value;
    }

    private class ClusterManagementDtlsConnector
    extends DTLSConnector {
        public ClusterManagementDtlsConnector(DtlsConnectorConfig configuration) {
            super(configuration);
            this.addSessionListener(new SessionAdapter(){

                @Override
                public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
                    if (DtlsManagedClusterConnector.this.useClusterMac) {
                        handshaker.setGenerateClusterMacKeys(DtlsManagedClusterConnector.this.useClusterMac);
                    }
                }
            });
        }

        @Override
        protected void start(InetSocketAddress bindAddress) throws IOException {
            if (this.isRunning()) {
                return;
            }
            super.init(bindAddress, DtlsManagedClusterConnector.this.clusterInternalSocket, null);
        }

        @Override
        public void setRawDataReceiver(final RawDataChannel messageHandler) {
            super.setRawDataReceiver(new RawDataChannel(){

                public void receiveData(RawData raw) {
                    messageHandler.receiveData(raw);
                    if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                        DtlsManagedClusterConnector.this.clusterHealth.receivingClusterManagementMessage();
                    }
                }
            });
        }

        @Override
        public void send(RawData msg) {
            super.send(msg);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.sendingClusterManagementMessage();
            }
        }
    }

    private class ClusterManagementUdpConnector
    extends UDPConnector {
        public ClusterManagementUdpConnector(InetSocketAddress bindAddress, Configuration configuration) {
            super(bindAddress, configuration);
        }

        public synchronized void start() throws IOException {
            if (this.isRunning()) {
                return;
            }
            this.init(DtlsManagedClusterConnector.this.clusterInternalSocket);
        }

        public void processDatagram(DatagramPacket datagram) {
            super.processDatagram(datagram);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.receivingClusterManagementMessage();
            }
        }

        public void send(RawData msg) {
            super.send(msg);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.sendingClusterManagementMessage();
            }
        }
    }
}

