/*
 * Copyright (c) 2024 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.map.primitive.IntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;

/**
 * A factory which creates instances of type {@link ImmutableIntLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableIntLongMapFactory
{
    /**
     * @since 6.0
     */
    ImmutableIntLongMap empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableIntLongMap of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableIntLongMap with();

    /**
     * Same as {@link #with(int, long)}.
     */
    ImmutableIntLongMap of(int key, long value);

    ImmutableIntLongMap with(int key, long value);

    /**
     * Same as {@link #withAll(IntLongMap)}.
     */
    ImmutableIntLongMap ofAll(IntLongMap map);

    ImmutableIntLongMap withAll(IntLongMap map);

    /**
     * Creates an {@code ImmutableIntLongMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> ImmutableIntLongMap from(Iterable<T> iterable, IntFunction<? super T> keyFunction, LongFunction<? super T> valueFunction);
}
